/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.deployment;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AccessorInfo;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberInfo;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerImplementor;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import ai.timefold.solver.quarkus.deployment.QuarkusGizmoSolutionClonerImplementor;
import ai.timefold.solver.quarkus.gizmo.TimefoldGizmoBeanFactory;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

@NullMarked
final class GizmoMemberAccessorEntityEnhancer {
    private final Set<Class<?>> visitedClasses = new HashSet();
    private final Set<Field> visitedFields = new HashSet<Field>();
    private final Set<Field> visitedFinalFields = new HashSet<Field>();
    private final Set<MethodInfo> visitedMethods = new HashSet<MethodInfo>();

    GizmoMemberAccessorEntityEnhancer() {
    }

    private static String getVirtualGetterName(boolean isField, String name) {
        return "$get$timefold$__" + (isField ? "field$__" : "method$__") + name;
    }

    private static String getVirtualSetterName(boolean isField, String name) {
        return "$set$timefold$__" + (isField ? "field$__" : "method$__") + name;
    }

    public String generateFieldAccessor(AnnotationInstance annotationInstance, ClassOutput classOutput, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> declaringClass = Class.forName(fieldInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Field fieldMember = declaringClass.getDeclaredField(fieldInfo.name());
        GizmoMemberDescriptor member = this.createMemberDescriptorForField(fieldMember, transformers);
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(member, true, false, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)fieldMember);
        GizmoMemberAccessorImplementor.defineAccessorFor((String)generatedClassName, (ClassOutput)classOutput, (GizmoMemberInfo)memberInfo);
        return generatedClassName;
    }

    private void addVirtualFieldGetter(Class<?> classInfo, Field fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!this.visitedFields.contains(fieldInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.getName(), (className, classVisitor) -> new TimefoldFieldEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, fieldInfo)));
            this.visitedFields.add(fieldInfo);
        }
    }

    private void makeFieldNonFinal(Field finalField, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (this.visitedFinalFields.contains(finalField)) {
            return;
        }
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(finalField.getDeclaringClass().getName(), (className, classVisitor) -> new TimefoldFinalFieldEnhancingClassVisitor((ClassVisitor)classVisitor, finalField)));
        this.visitedFinalFields.add(finalField);
    }

    private static String getMemberName(Member member) {
        return Objects.requireNonNullElse(ReflectionHelper.getGetterPropertyName((Member)member), member.getName());
    }

    private static Optional<MethodDesc> getSetterDescriptor(ClassInfo classInfo, MethodInfo methodInfo, String name) {
        if (methodInfo.name().startsWith("get") || methodInfo.name().startsWith("is")) {
            return Optional.ofNullable(classInfo.method("set" + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1), new org.jboss.jandex.Type[]{methodInfo.returnType()})).map(setterInfo -> ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(classInfo.descriptor()), (String)setterInfo.name(), (ClassDesc)ClassDesc.ofDescriptor(setterInfo.returnType().descriptor()), (ClassDesc[])((ClassDesc[])setterInfo.parameterTypes().stream().map(parameter -> ClassDesc.ofDescriptor(parameter.descriptor())).toArray(ClassDesc[]::new))));
        }
        return Optional.empty();
    }

    public String generateMethodAccessor(@Nullable AnnotationInstance annotationInstance, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, AccessorInfo accessorInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchMethodException {
        GizmoMemberDescriptor descriptor;
        Class<?> declaringClass = Class.forName(methodInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Method methodMember = GizmoMemberAccessorEntityEnhancer.getDeclaredMethod(declaringClass, methodInfo);
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)methodMember);
        String name = GizmoMemberAccessorEntityEnhancer.getMemberName(methodMember);
        Optional<MethodDesc> setterDescriptor = GizmoMemberAccessorEntityEnhancer.getSetterDescriptor(classInfo, methodInfo, name);
        ClassMethodDesc memberDescriptor = ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(methodInfo.declaringClass().descriptor()), (String)methodInfo.name(), (ClassDesc)ClassDesc.ofDescriptor(methodInfo.returnType().descriptor()), (ClassDesc[])((ClassDesc[])methodInfo.parameterTypes().stream().map(parameterType -> ClassDesc.ofDescriptor(parameterType.descriptor())).toArray(ClassDesc[]::new)));
        Type methodParameterType = GizmoMemberDescriptor.getMethodParameterType((Method)methodMember, (boolean)accessorInfo.readMethodWithParameter());
        if (Modifier.isPublic(methodInfo.flags())) {
            descriptor = new GizmoMemberDescriptor(name, (MethodDesc)memberDescriptor, methodParameterType, declaringClass, (MethodDesc)setterDescriptor.orElse(null));
        } else {
            setterDescriptor = this.addVirtualMethodGetter(classInfo, methodInfo, name, setterDescriptor.orElse(null), transformers);
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, name);
            ClassMethodDesc newMethodDescriptor = ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(declaringClass.descriptorString()), (String)methodName, (ClassDesc)memberDescriptor.returnType(), (ClassDesc[])new ClassDesc[0]);
            descriptor = new GizmoMemberDescriptor(name, (MethodDesc)newMethodDescriptor, (MethodDesc)memberDescriptor, methodParameterType, declaringClass, (MethodDesc)setterDescriptor.orElse(null));
        }
        Class<?> annotationClass = null;
        if (accessorInfo.returnTypeRequired() || annotationInstance != null) {
            annotationClass = Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(descriptor, accessorInfo.returnTypeRequired(), descriptor.getMethodParameterType() != null, annotationClass);
        GizmoMemberAccessorImplementor.defineAccessorFor((String)generatedClassName, (ClassOutput)classOutput, (GizmoMemberInfo)memberInfo);
        return generatedClassName;
    }

    private static Method getDeclaredMethod(Class<?> declaringClass, MethodInfo methodInfo) throws NoSuchMethodException {
        List<Method> methodList = Arrays.stream(declaringClass.getDeclaredMethods()).filter(m -> m.getName().equals(methodInfo.name()) && m.getParameterCount() == methodInfo.parameterTypes().size() && Arrays.equals(m.getParameterTypes(), methodInfo.parameterTypes().stream().map(ConstantLambdaUtils.uncheck(t -> Class.forName(t.name().toString(), false, Thread.currentThread().getContextClassLoader()))).toArray(Class[]::new))).toList();
        if (methodList.isEmpty()) {
            throw new NoSuchMethodException(methodInfo.name());
        }
        return methodList.get(0);
    }

    private Optional<MethodDesc> addVirtualMethodGetter(ClassInfo classInfo, MethodInfo methodInfo, String name, @Nullable MethodDesc setterDescriptor, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!this.visitedMethods.contains(methodInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new TimefoldMethodEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, methodInfo, name, setterDescriptor)));
            this.visitedMethods.add(methodInfo);
        }
        return Optional.ofNullable(setterDescriptor).map(md -> ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(classInfo.descriptor()), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, name), (ClassDesc)md.returnType(), (List)md.parameterTypes()));
    }

    public <Solution_> String generateSolutionCloner(SolutionDescriptor<Solution_> solutionDescriptor, ClassOutput classOutput, IndexView indexView, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        String generatedClassName = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput);
        gizmo.class_(generatedClassName, classCreator -> {
            classCreator.implements_(GizmoSolutionCloner.class);
            classCreator.final_();
            Set solutionSubclassSet = indexView.getAllKnownSubclasses(DotName.createSimple((String)solutionDescriptor.getSolutionClass().getName())).stream().map(classInfo -> {
                try {
                    return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to find class (%s), which is a known subclass of the solution class (%s).".formatted(classInfo.name(), solutionDescriptor.getSolutionClass()), e);
                }
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            solutionSubclassSet.add(solutionDescriptor.getSolutionClass());
            HashMap memoizedGizmoSolutionOrEntityDescriptorForClassMap = new HashMap();
            for (Class solutionSubclass : solutionSubclassSet) {
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, solutionSubclass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            for (Object entityClass : solutionDescriptor.getEntityClassSet()) {
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, (Class<?>)entityClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            HashSet solutionAndEntitySubclassSet = new HashSet(solutionSubclassSet);
            for (Class entityClass : solutionDescriptor.getEntityClassSet()) {
                Collection classInfoCollection = entityClass.isInterface() ? indexView.getAllKnownImplementations(DotName.createSimple((String)entityClass.getName())) : indexView.getAllKnownSubclasses(DotName.createSimple((String)entityClass.getName()));
                classInfoCollection.stream().map(classInfo -> {
                    try {
                        return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to find class (%s), which is a known subclass of the entity class (%s).".formatted(classInfo.name(), entityClass), e);
                    }
                }).forEach(solutionAndEntitySubclassSet::add);
            }
            Set deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses((SolutionDescriptor)solutionDescriptor, solutionAndEntitySubclassSet);
            for (Class deepCloningClass : deepClonedClassSet) {
                this.makeConstructorAccessible(deepCloningClass, transformers);
                if (memoizedGizmoSolutionOrEntityDescriptorForClassMap.containsKey(deepCloningClass)) continue;
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, deepCloningClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            GizmoSolutionClonerImplementor.defineClonerFor(QuarkusGizmoSolutionClonerImplementor::new, (ClassCreator)classCreator, (SolutionDescriptor)solutionDescriptor, (Set)solutionSubclassSet, memoizedGizmoSolutionOrEntityDescriptorForClassMap, (Set)deepClonedClassSet);
        });
        return generatedClassName;
    }

    private void makeConstructorAccessible(Class<?> clazz, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        try {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                return;
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers()) && !this.visitedClasses.contains(clazz)) {
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(clazz.getName(), (className, classVisitor) -> new TimefoldConstructorEnhancingClassVisitor((ClassVisitor)classVisitor)));
                this.visitedClasses.add(clazz);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class (%s) must have a no-args constructor so it can be constructed by Timefold.".formatted(clazz.getName()), e);
        }
    }

    private <Solution_> void getGizmoSolutionOrEntityDescriptorForEntity(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> entityClass, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedMap, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        HashMap<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptor = new HashMap<Field, GizmoMemberDescriptor>();
        for (Class<?> currentClass = entityClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                solutionFieldToMemberDescriptor.put(field, this.createMemberDescriptorForField(field, transformers));
            }
        }
        GizmoSolutionOrEntityDescriptor out = new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass, solutionFieldToMemberDescriptor);
        memoizedMap.put(entityClass, out);
    }

    private GizmoMemberDescriptor createMemberDescriptorForField(Field field, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (Modifier.isFinal(field.getModifiers())) {
            this.makeFieldNonFinal(field, transformers);
        }
        Class<?> declaringClass = field.getDeclaringClass();
        FieldDesc memberDescriptor = FieldDesc.of((Field)field);
        String name = field.getName();
        if (Modifier.isPublic(field.getModifiers())) {
            return new GizmoMemberDescriptor(name, memberDescriptor, declaringClass);
        }
        this.addVirtualFieldGetter(declaringClass, field, transformers);
        String getterName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, name);
        ClassMethodDesc getterDescriptor = ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(declaringClass.descriptorString()), (String)getterName, field.getType(), (Class[])new Class[0]);
        String setterName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, name);
        ClassMethodDesc setterDescriptor = ClassMethodDesc.of((ClassDesc)ClassDesc.ofDescriptor(declaringClass.descriptorString()), (String)setterName, Void.TYPE, (Class[])new Class[]{field.getType()});
        return new GizmoMemberDescriptor(name, (MethodDesc)getterDescriptor, memberDescriptor, null, declaringClass, (MethodDesc)setterDescriptor);
    }

    public static Map<String, RuntimeValue<MemberAccessor>> getGeneratedGizmoMemberAccessorMap(RecorderContext recorderContext, Set<String> generatedMemberAccessorsClassNames) {
        HashMap<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorNameToInstanceMap = new HashMap<String, RuntimeValue<MemberAccessor>>();
        for (String className : generatedMemberAccessorsClassNames) {
            generatedGizmoMemberAccessorNameToInstanceMap.put(className, (RuntimeValue<MemberAccessor>)recorderContext.newInstance(className));
        }
        return generatedGizmoMemberAccessorNameToInstanceMap;
    }

    public static <Solution_> Map<String, RuntimeValue<SolutionCloner<Solution_>>> getGeneratedSolutionClonerMap(RecorderContext recorderContext, Set<String> generatedSolutionClonersClassNames) {
        HashMap<String, RuntimeValue<SolutionCloner<Solution_>>> generatedGizmoSolutionClonerNameToInstanceMap = new HashMap<String, RuntimeValue<SolutionCloner<Solution_>>>();
        for (String className : generatedSolutionClonersClassNames) {
            generatedGizmoSolutionClonerNameToInstanceMap.put(className, recorderContext.newInstance(className));
        }
        return generatedGizmoSolutionClonerNameToInstanceMap;
    }

    public void generateGizmoBeanFactory(ClassOutput classOutput, Set<Class<?>> beanClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        String generatedClassName = TimefoldGizmoBeanFactory.class.getName() + "$Implementation";
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput);
        gizmo.class_(generatedClassName, classCreator -> {
            classCreator.implements_(TimefoldGizmoBeanFactory.class);
            classCreator.addAnnotation(ApplicationScoped.class);
            classCreator.defaultConstructor();
            classCreator.method("newInstance", methodCreator -> {
                ParamVar query = methodCreator.parameter("query", Class.class);
                methodCreator.returning(Object.class);
                methodCreator.body(blockCreator -> {
                    for (Class beanClass : beanClasses) {
                        if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) continue;
                        this.makeConstructorAccessible(beanClass, transformers);
                        Const beanClassHandle = Const.of((Class)beanClass);
                        blockCreator.if_(blockCreator.objEquals((Expr)beanClassHandle, (Expr)query), isQueryBranch -> isQueryBranch.return_(isQueryBranch.new_(beanClass)));
                    }
                    blockCreator.returnNull();
                });
            });
        });
    }

    private static class TimefoldConstructorEnhancingClassVisitor
    extends ClassVisitor {
        public TimefoldConstructorEnhancingClassVisitor(ClassVisitor outputClassVisitor) {
            super(589824, outputClassVisitor);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("<init>")) {
                return this.cv.visitMethod(1, name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    @NullMarked
    private static class TimefoldMethodEnhancingClassVisitor
    extends ClassVisitor {
        private final MethodInfo methodInfo;
        private final Class<?> clazz;
        private final String returnTypeDescriptor;
        private final @Nullable MethodDesc setter;
        private final String name;

        public TimefoldMethodEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, MethodInfo methodInfo, String name, @Nullable MethodDesc setter) {
            super(589824, outputClassVisitor);
            this.methodInfo = methodInfo;
            this.name = name;
            this.setter = setter;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.returnTypeDescriptor = methodInfo.returnType().descriptor();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            if (this.setter != null) {
                this.addSetter(this.cv);
            }
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.returnTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), this.methodInfo.name(), "()" + this.returnTypeDescriptor, false);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.returnTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }

        private void addSetter(ClassVisitor classWriter) {
            if (this.setter == null) {
                return;
            }
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, this.setter.type().descriptorString(), null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), this.setter.name(), this.setter.type().descriptorString(), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
    }

    private static class TimefoldFinalFieldEnhancingClassVisitor
    extends ClassVisitor {
        final Field finalField;

        public TimefoldFinalFieldEnhancingClassVisitor(ClassVisitor outputClassVisitor, Field finalField) {
            super(589824, outputClassVisitor);
            this.finalField = finalField;
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (name.equals(this.finalField.getName())) {
                return super.visitField(access & 0xFFFFFFEF, name, descriptor, signature, value);
            }
            return super.visitField(access, name, descriptor, signature, value);
        }
    }

    private static class TimefoldFieldEnhancingClassVisitor
    extends ClassVisitor {
        private final Field fieldInfo;
        private final Class<?> clazz;
        private final String fieldTypeDescriptor;

        public TimefoldFieldEnhancingClassVisitor(Class<?> classInfo, ClassVisitor outputClassVisitor, Field fieldInfo) {
            super(589824, outputClassVisitor);
            this.fieldInfo = fieldInfo;
            this.clazz = classInfo;
            this.fieldTypeDescriptor = org.objectweb.asm.Type.getDescriptor(fieldInfo.getType());
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            this.addSetter(this.cv);
        }

        private void addSetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + this.fieldTypeDescriptor + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(21), 1);
            mv.visitFieldInsn(181, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.fieldTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }
    }
}

