/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.deployment;

import ai.timefold.solver.core.api.domain.autodiscover.AutoDiscoverMemberType;
import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.api.domain.variable.ShadowSources;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.api.score.calculator.EasyScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.PathPart;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.quarkus.TimefoldRecorder;
import ai.timefold.solver.quarkus.bean.BeanUtil;
import ai.timefold.solver.quarkus.bean.DefaultTimefoldBeanProvider;
import ai.timefold.solver.quarkus.bean.TimefoldSolverBannerBean;
import ai.timefold.solver.quarkus.bean.UnavailableTimefoldBeanProvider;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import ai.timefold.solver.quarkus.deployment.DetermineIfNativeBuildItem;
import ai.timefold.solver.quarkus.deployment.DotNames;
import ai.timefold.solver.quarkus.deployment.GeneratedGizmoClasses;
import ai.timefold.solver.quarkus.deployment.GizmoMemberAccessorEntityEnhancer;
import ai.timefold.solver.quarkus.deployment.SolverConfigBuildItem;
import ai.timefold.solver.quarkus.deployment.api.ConstraintMetaModelBuildItem;
import ai.timefold.solver.quarkus.deployment.config.SolverBuildTimeConfig;
import ai.timefold.solver.quarkus.deployment.config.TimefoldBuildTimeConfig;
import ai.timefold.solver.quarkus.devui.DevUISolverConfig;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIPropertiesRPCService;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIRecorder;
import ai.timefold.solver.quarkus.gizmo.TimefoldGizmoBeanFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

class TimefoldProcessor {
    private static final Logger log = Logger.getLogger((String)TimefoldProcessor.class.getName());
    TimefoldBuildTimeConfig timefoldBuildTimeConfig;

    TimefoldProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("timefold-solver");
    }

    @BuildStep
    void watchSolverConfigXml(BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        String solverConfigXML = this.timefoldBuildTimeConfig.solverConfigXml().orElse("solverConfig.xml");
        HashSet<String> solverCongigXmlFileSet = new HashSet<String>();
        solverCongigXmlFileSet.add(solverConfigXML);
        this.timefoldBuildTimeConfig.solver().values().stream().map(SolverBuildTimeConfig::solverConfigXml).filter(Optional::isPresent).map(Optional::get).forEach(solverCongigXmlFileSet::add);
        solverCongigXmlFileSet.forEach(file -> hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file)));
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencyBuildItem() {
        return new IndexDependencyBuildItem("ai.timefold.solver", "timefold-solver-core");
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void makeGizmoBeanFactoryUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldGizmoBeanFactory.class}));
    }

    @BuildStep(onlyIfNot={NativeBuild.class})
    DetermineIfNativeBuildItem ifNotNativeBuild() {
        return new DetermineIfNativeBuildItem(false);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    DetermineIfNativeBuildItem ifNativeBuild() {
        return new DetermineIfNativeBuildItem(true);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem registerDevUICard() {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Configuration")).icon("font-awesome-solid:wrench")).componentLink("config-component.js"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Model")).icon("font-awesome-solid:wrench")).componentLink("model-component.js"));
        cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Constraints")).icon("font-awesome-solid:wrench")).componentLink("constraints-component.js"));
        return cardPageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public JsonRPCProvidersBuildItem registerRPCService() {
        return new JsonRPCProvidersBuildItem("Timefold Solver", TimefoldDevUIPropertiesRPCService.class);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void makeSolverFactoryUnremovableInDevMode(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{SolverFactory.class}));
    }

    @BuildStep
    SolverConfigBuildItem recordAndRegisterBuildTimeBeans(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        IndexView indexView = combinedIndex.getIndex();
        HashSet<String> solverNames = new HashSet<String>();
        HashMap<String, SolverConfig> solverConfigMap = new HashMap<String, SolverConfig>();
        for (AnnotationInstance namedItem : indexView.getAnnotations(DotNames.NAMED)) {
            DotName type;
            AnnotationTarget target = namedItem.target();
            if ((type = (switch (target.kind()) {
                default -> throw new IncompatibleClassChangeError();
                case AnnotationTarget.Kind.CLASS -> target.asClass().name();
                case AnnotationTarget.Kind.FIELD -> target.asField().type().name();
                case AnnotationTarget.Kind.METHOD_PARAMETER -> target.asMethodParameter().type().name();
                case AnnotationTarget.Kind.RECORD_COMPONENT -> target.asRecordComponent().type().name();
                case AnnotationTarget.Kind.TYPE, AnnotationTarget.Kind.METHOD -> null;
            })) == null || !DotNames.SOLVER_INJECTABLE_TYPES.contains(type)) continue;
            AnnotationValue annotationValue = namedItem.value();
            String value = annotationValue != null ? annotationValue.asString() : "";
            solverNames.add(value);
        }
        if (indexView.getAnnotations(DotNames.PLANNING_SOLUTION).isEmpty() && indexView.getAnnotations(DotNames.PLANNING_ENTITY).isEmpty()) {
            log.warn((Object)"Skipping Timefold extension because there are no @%s or @%s annotated classes.\nIf your domain classes are located in a dependency of this project, maybe try generating the Jandex index by using the jandex-maven-plugin in that dependency, or by addingapplication.properties entries (quarkus.index-dependency.<name>.group-id and quarkus.index-dependency.<name>.artifact-id).".formatted(PlanningSolution.class.getSimpleName(), PlanningEntity.class.getSimpleName()));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableTimefoldBeanProvider.class}));
            solverNames.forEach(solverName -> solverConfigMap.put((String)solverName, (SolverConfig)null));
            return new SolverConfigBuildItem(solverConfigMap, null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        TimefoldRecorder.assertNoUnmatchedProperties(solverNames, this.timefoldBuildTimeConfig.solver().keySet());
        if (solverNames.isEmpty()) {
            solverConfigMap.put("default", this.createSolverConfig(classLoader, "default"));
        } else {
            solverNames.forEach(solverName -> solverConfigMap.put((String)solverName, this.createSolverConfig(classLoader, (String)solverName)));
        }
        this.assertNoMemberAnnotationWithoutClassAnnotation(indexView);
        this.assertNodeSharingDisabled(solverConfigMap);
        this.assertSolverConfigSolutionClasses(indexView, solverConfigMap);
        this.assertSolverConfigEntityClasses(indexView);
        this.assertSolverConfigConstraintClasses(indexView, solverConfigMap);
        LinkedHashSet reflectiveClassSet = new LinkedHashSet();
        solverConfigMap.forEach((solverName, solverConfig) -> this.loadSolverConfig(indexView, reflectiveHierarchyClass, (SolverConfig)solverConfig, (String)solverName, reflectiveClassSet));
        this.registerClassesFromAnnotations(indexView, reflectiveClassSet);
        solverConfigMap.values().stream().filter(config -> config.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null).map(config -> config.getScoreDirectorFactoryConfig().getConstraintProviderClass().getName()).distinct().map(constraintName -> solverConfigMap.entrySet().stream().filter(entryConfig -> ((SolverConfig)entryConfig.getValue()).getScoreDirectorFactoryConfig().getConstraintProviderClass().getName().equals(constraintName)).findFirst().get()).forEach(entryConfig -> this.generateConstraintVerifier((SolverConfig)entryConfig.getValue(), syntheticBeanBuildItemBuildProducer));
        GeneratedGizmoClasses generatedGizmoClasses = this.generateDomainAccessors(solverConfigMap, indexView, generatedBeans, generatedClasses, transformers, reflectiveClassSet);
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{TimefoldSolverBannerBean.class}));
        if (solverConfigMap.size() <= 1) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultTimefoldBeanProvider.class}));
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldRuntimeConfig.class}));
        return new SolverConfigBuildItem(solverConfigMap, generatedGizmoClasses);
    }

    private void assertNoMemberAnnotationWithoutClassAnnotation(IndexView indexView) {
        HashSet timefoldFieldAnnotationCollection = new HashSet();
        for (DotName annotationName : DotNames.PLANNING_ENTITY_FIELD_ANNOTATIONS) {
            timefoldFieldAnnotationCollection.addAll(indexView.getAnnotationsWithRepeatable(annotationName, indexView));
        }
        for (AnnotationInstance annotationInstance : timefoldFieldAnnotationCollection) {
            ClassInfo declaringClass;
            String prefix;
            AnnotationTarget annotationTarget = annotationInstance.target();
            if ((declaringClass = (switch (annotationTarget.kind()) {
                case AnnotationTarget.Kind.FIELD -> {
                    prefix = "The field (%s)".formatted(annotationTarget.asField().name());
                    yield annotationTarget.asField().declaringClass();
                }
                case AnnotationTarget.Kind.METHOD -> {
                    prefix = "The method (%s)".formatted(annotationTarget.asMethod().name());
                    yield annotationTarget.asMethod().declaringClass();
                }
                default -> throw new IllegalStateException("Member annotation @%s is on (%s), which is an invalid target type (%s) for @%s.".formatted(annotationInstance.name().withoutPackagePrefix(), annotationTarget, annotationTarget.kind(), annotationInstance.name().withoutPackagePrefix()));
            })).annotationsMap().containsKey(DotNames.PLANNING_ENTITY)) continue;
            throw new IllegalStateException("%s with a @%s annotation is in a class (%s) that does not have a @%s annotation.\nMaybe add a @%s annotation on the class (%s).".formatted(prefix, annotationInstance.name().withoutPackagePrefix(), declaringClass.name(), PlanningEntity.class.getSimpleName(), PlanningEntity.class.getSimpleName(), declaringClass.name()));
        }
    }

    private void assertSolverConfigSolutionClasses(IndexView indexView, Map<String, SolverConfig> solverConfigMap) {
        this.assertEmptyInstances(indexView, DotNames.PLANNING_SOLUTION);
        List<AnnotationInstance> annotationInstanceList = TimefoldProcessor.getAllConcreteSolutionClasses(indexView);
        SolverConfig firstConfig = solverConfigMap.values().stream().findFirst().orElse(null);
        if (annotationInstanceList.size() > 1 && solverConfigMap.size() == 1 && firstConfig != null && firstConfig.getSolutionClass() == null) {
            throw new IllegalStateException("Multiple classes (%s) found in the classpath with a @%s annotation.".formatted(this.convertAnnotationInstancesToString(annotationInstanceList), PlanningSolution.class.getSimpleName()));
        }
        List<String> unconfiguredSolverConfigList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getSolutionClass() == null).map(Map.Entry::getKey).toList();
        if (annotationInstanceList.size() > 1 && !unconfiguredSolverConfigList.isEmpty()) {
            throw new IllegalStateException("Some solver configs (%s) don't specify a %s class, yet there are multiple available (%s) on the classpath.\nMaybe set the XML config file to the related solver configs, or add the missing solution classes to the XML files,\nor remove the unnecessary solution classes from the classpath.".formatted(String.join((CharSequence)", ", unconfiguredSolverConfigList), PlanningSolution.class.getSimpleName(), this.convertAnnotationInstancesToString(annotationInstanceList)));
        }
        List<String> unusedSolutionClassList = annotationInstanceList.stream().map(planningClass -> planningClass.target().asClass().name().toString()).filter(planningClassName -> solverConfigMap.values().stream().filter(c -> c.getSolutionClass() != null).noneMatch(c -> c.getSolutionClass().getName().equals(planningClassName) || c.getSolutionClass().getSuperclass().getName().equals(planningClassName))).toList();
        if (annotationInstanceList.size() > 1 && !unusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException("Unused classes ([%s]) found with a @%s annotation.".formatted(String.join((CharSequence)", ", unusedSolutionClassList), PlanningSolution.class.getSimpleName()));
        }
    }

    private void assertNodeSharingDisabled(Map<String, SolverConfig> solverConfigMap) {
        for (Map.Entry<String, SolverConfig> entry : solverConfigMap.entrySet()) {
            SolverConfig solverConfig = entry.getValue();
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
            if (scoreDirectorFactoryConfig == null || !Boolean.TRUE.equals(scoreDirectorFactoryConfig.getConstraintStreamAutomaticNodeSharing())) continue;
            throw new IllegalStateException("SolverConfig %s enabled automatic node sharing via SolverConfig, which is not allowed.\nEnable automatic node sharing with the property %s instead.".formatted(entry.getKey(), "quarkus.timefold.solver.constraint-stream-automatic-node-sharing=true"));
        }
    }

    private void assertSolverConfigEntityClasses(IndexView indexView) {
        this.assertEmptyInstances(indexView, DotNames.PLANNING_ENTITY);
    }

    private void assertSolverConfigConstraintClasses(IndexView indexView, Map<String, SolverConfig> solverConfigMap) {
        List<ClassInfo> simpleScoreClassCollection = indexView.getAllKnownImplementations(DotNames.EASY_SCORE_CALCULATOR).stream().filter(clazz -> !clazz.isAbstract()).toList();
        List<ClassInfo> constraintScoreClassCollection = indexView.getAllKnownImplementations(DotNames.CONSTRAINT_PROVIDER).stream().filter(clazz -> !clazz.isAbstract()).toList();
        List<ClassInfo> incrementalScoreClassCollection = indexView.getAllKnownImplementations(DotNames.INCREMENTAL_SCORE_CALCULATOR).stream().filter(clazz -> !clazz.isAbstract()).toList();
        if (simpleScoreClassCollection.isEmpty() && constraintScoreClassCollection.isEmpty() && incrementalScoreClassCollection.isEmpty()) {
            throw new IllegalStateException("No classes found that implement %s, %s, or %s.".formatted(EasyScoreCalculator.class.getSimpleName(), ConstraintProvider.class.getSimpleName(), IncrementalScoreCalculator.class.getSimpleName()));
        }
        String errorMessage = "Multiple score classes classes (%s) that implements %s were found in the classpath.";
        if (simpleScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(simpleScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), EasyScoreCalculator.class.getSimpleName()));
        }
        if (constraintScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(constraintScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), ConstraintProvider.class.getSimpleName()));
        }
        if (incrementalScoreClassCollection.size() > 1 && solverConfigMap.size() == 1) {
            throw new IllegalStateException(errorMessage.formatted(incrementalScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", ")), IncrementalScoreCalculator.class.getSimpleName()));
        }
        errorMessage = "Some solver configs (%s) don't specify a %s score class, yet there are multiple available (%s) on the classpath.\nMaybe set the XML config file to the related solver configs, or add the missing score classes to the XML files,\nor remove the unnecessary score classes from the classpath.";
        List<String> solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass() == null).map(Map.Entry::getKey).toList();
        if (simpleScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), EasyScoreCalculator.class.getSimpleName(), simpleScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getConstraintProviderClass() == null).map(Map.Entry::getKey).toList();
        if (constraintScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), ConstraintProvider.class.getSimpleName(), constraintScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        solverConfigWithoutConstraintClassList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig() == null || ((SolverConfig)e.getValue()).getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass() == null).map(Map.Entry::getKey).toList();
        if (incrementalScoreClassCollection.size() > 1 && !solverConfigWithoutConstraintClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithoutConstraintClassList), IncrementalScoreCalculator.class.getSimpleName(), incrementalScoreClassCollection.stream().map(c -> c.name().toString()).collect(Collectors.joining(", "))));
        }
        List<String> solverConfigWithUnusedSolutionClassList = simpleScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getEasyScoreCalculatorClass().getName().equals(className))).toList();
        errorMessage = "Unused classes ([%s]) that implements %s were found.";
        if (simpleScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), EasyScoreCalculator.class.getSimpleName()));
        }
        solverConfigWithUnusedSolutionClassList = constraintScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getConstraintProviderClass().getName().equals(className))).toList();
        if (constraintScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), ConstraintProvider.class.getSimpleName()));
        }
        solverConfigWithUnusedSolutionClassList = incrementalScoreClassCollection.stream().map(clazz -> clazz.name().toString()).filter(className -> solverConfigMap.values().stream().filter(c -> c.getScoreDirectorFactoryConfig() != null && c.getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass() != null).noneMatch(c -> c.getScoreDirectorFactoryConfig().getIncrementalScoreCalculatorClass().getName().equals(className))).toList();
        if (incrementalScoreClassCollection.size() > 1 && !solverConfigWithUnusedSolutionClassList.isEmpty()) {
            throw new IllegalStateException(errorMessage.formatted(String.join((CharSequence)", ", solverConfigWithUnusedSolutionClassList), IncrementalScoreCalculator.class.getSimpleName()));
        }
    }

    private void assertEmptyInstances(IndexView indexView, DotName dotName) {
        Collection annotationInstanceCollection = indexView.getAnnotations(dotName);
        if (annotationInstanceCollection.isEmpty()) {
            try {
                throw new IllegalStateException("No classes were found with a @%s annotation.".formatted(Class.forName(dotName.local()).getSimpleName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private SolverConfig createSolverConfig(ClassLoader classLoader, String solverName) {
        SolverConfig solverConfig;
        Optional<Object> solverConfigXml = this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::solverConfigXml);
        if (solverConfigXml.isEmpty()) {
            solverConfigXml = this.timefoldBuildTimeConfig.solverConfigXml();
        }
        if (solverConfigXml.isPresent()) {
            String solverUrl = (String)solverConfigXml.get();
            if (classLoader.getResource(solverUrl) == null) {
                String message = "Invalid quarkus.timefold.solverConfigXML property (%s): that classpath resource does not exist.".formatted(solverUrl);
                if (!solverName.equals("default")) {
                    message = "Invalid quarkus.timefold.solver.\"%s\".solverConfigXML property (%s): that classpath resource does not exist.".formatted(solverName, solverUrl);
                }
                throw new ConfigurationException(message);
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverUrl);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml") : new SolverConfig();
        }
        return solverConfig;
    }

    private SolverConfig loadSolverConfig(IndexView indexView, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, SolverConfig solverConfig, String solverName, Set<Class<?>> reflectiveClassSet) {
        this.applySolverProperties(indexView, solverName, solverConfig);
        Class solutionClass = solverConfig.getSolutionClass();
        if (solutionClass != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solutionClass.getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).ignoreTypePredicate(dotName -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName) || dotName.toString().startsWith("ai.timefold.solver.api") || dotName.toString().startsWith("ai.timefold.solver.config") || dotName.toString().startsWith("ai.timefold.solver.impl")).build());
        }
        this.registerCustomClassesFromSolverConfig(solverConfig, reflectiveClassSet);
        return solverConfig;
    }

    @BuildStep
    void buildConstraintMetaModel(SolverConfigBuildItem solverConfigBuildItem, BuildProducer<ConstraintMetaModelBuildItem> constraintMetaModelBuildItemBuildProducer) {
        if (solverConfigBuildItem.getSolverConfigMap().isEmpty()) {
            return;
        }
        HashMap<String, ConstraintMetaModel> constraintMetaModelsBySolverNames = new HashMap<String, ConstraintMetaModel>();
        solverConfigBuildItem.getSolverConfigMap().forEach((solverName, solverConfig) -> {
            DomainAccessType originalDomainAccessType = solverConfig.getDomainAccessType();
            solverConfig.setDomainAccessType(DomainAccessType.REFLECTION);
            SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
            ConstraintMetaModel constraintMetaModel = BeanUtil.buildConstraintMetaModel((SolverFactory)solverFactory);
            solverConfig.setDomainAccessType(originalDomainAccessType);
            constraintMetaModelsBySolverNames.put((String)solverName, constraintMetaModel);
        });
        constraintMetaModelBuildItemBuildProducer.produce((BuildItem)new ConstraintMetaModelBuildItem(constraintMetaModelsBySolverNames));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void recordAndRegisterRuntimeBeans(TimefoldRecorder recorder, RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, SolverConfigBuildItem solverConfigBuildItem) {
        if (solverConfigBuildItem.getGeneratedGizmoClasses() == null) {
            return;
        }
        recorder.assertNoUnmatchedRuntimeProperties(solverConfigBuildItem.getSolverConfigMap().keySet());
        solverConfigBuildItem.getSolverConfigMap().forEach((key, value) -> {
            if (solverConfigBuildItem.isDefaultSolverConfig((String)key)) {
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).supplier(recorder.solverConfigSupplier(key, value, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).setRuntimeInit().defaultBean()).done());
                SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).supplier(recorder.solverManagerConfig(solverManagerConfig)).setRuntimeInit().defaultBean()).done());
            }
            if (!"default".equals(key)) {
                syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManager.class).scope(Singleton.class)).addType((Type)ParameterizedType.create((DotName)DotName.createSimple((String)SolverManager.class.getName()), (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)value.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS), TypeVariable.create((String)Object.class.getName())}))).supplier(recorder.solverManager(key, value, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).setRuntimeInit().named(key)).done());
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordAndRegisterDevUIBean(TimefoldDevUIRecorder devUIRecorder, RecorderContext recorderContext, SolverConfigBuildItem solverConfigBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        if (solverConfigBuildItem.getGeneratedGizmoClasses() == null) {
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DevUISolverConfig.class).scope(ApplicationScoped.class)).supplier(devUIRecorder.solverConfigSupplier(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap())).defaultBean()).setRuntimeInit().done());
            return;
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DevUISolverConfig.class).scope(ApplicationScoped.class)).supplier(devUIRecorder.solverConfigSupplier(solverConfigBuildItem.getSolverConfigMap(), GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, solverConfigBuildItem.getGeneratedGizmoClasses().generatedGizmoSolutionClonerClassSet))).defaultBean()).setRuntimeInit().done());
    }

    private void generateConstraintVerifier(SolverConfig solverConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        String constraintVerifierClassName = DotNames.CONSTRAINT_VERIFIER.toString();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = Objects.requireNonNull(solverConfig.getScoreDirectorFactoryConfig());
        Class constraintProviderClass = scoreDirectorFactoryConfig.getConstraintProviderClass();
        if (constraintProviderClass != null && this.isClassDefined(constraintVerifierClassName)) {
            Class planningSolutionClass = Objects.requireNonNull(solverConfig.getSolutionClass());
            List planningEntityClassList = Objects.requireNonNull(solverConfig.getEntityClassList());
            SyntheticBeanBuildItem.ExtendedBeanConfigurator constraintDescriptor = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.CONSTRAINT_VERIFIER).scope(Singleton.class)).creator(methodCreator -> {
                ResultHandle constraintProviderResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Class)constraintProviderClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle planningSolutionClassResultHandle = methodCreator.loadClass(planningSolutionClass);
                ResultHandle planningEntityClassesResultHandle = methodCreator.newArray(Class.class, planningEntityClassList.size());
                for (int i = 0; i < planningEntityClassList.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClassList.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle enabledPreviewFeatureSet = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(EnumSet.class, (String)"noneOf", EnumSet.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{methodCreator.loadClass(PreviewFeature.class)});
                if (solverConfig.getEnablePreviewFeatureSet() != null) {
                    for (PreviewFeature enabledPreviewFeature : solverConfig.getEnablePreviewFeatureSet()) {
                        methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(EnumSet.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), enabledPreviewFeatureSet, new ResultHandle[]{methodCreator.load((Enum)enabledPreviewFeature)});
                    }
                }
                for (int i = 0; i < planningEntityClassList.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClassList.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle solutionDescriptorResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(SolutionDescriptor.class, (String)"buildSolutionDescriptor", SolutionDescriptor.class, (Class[])new Class[]{Set.class, Class.class, Class[].class}), new ResultHandle[]{enabledPreviewFeatureSet, planningSolutionClassResultHandle, planningEntityClassesResultHandle});
                ResultHandle constraintVerifierResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Object)"ai.timefold.solver.test.impl.score.stream.DefaultConstraintVerifier", (Object[])new Object[]{ConstraintProvider.class, SolutionDescriptor.class}), new ResultHandle[]{constraintProviderResultHandle, solutionDescriptorResultHandle});
                methodCreator.returnValue(constraintVerifierResultHandle);
            })).addType((Type)ParameterizedType.create((DotName)DotNames.CONSTRAINT_VERIFIER, (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)constraintProviderClass.getName()), (Type.Kind)Type.Kind.CLASS), Type.create((DotName)DotName.createSimple((String)planningSolutionClass.getName()), (Type.Kind)Type.Kind.CLASS)}, null))).forceApplicationClass()).defaultBean();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)constraintDescriptor.done());
        }
    }

    private void applySolverProperties(IndexView indexView, String solverName, SolverConfig solverConfig) {
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findFirstSolutionClass(indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::domainAccessType).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDomainAccessType(arg_0));
        if (solverConfig.getDomainAccessType() == null) {
            solverConfig.setDomainAccessType(DomainAccessType.GIZMO);
        }
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::enabledPreviewFeatures).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnablePreviewFeatureSet(arg_0));
        this.timefoldBuildTimeConfig.getSolverConfig(solverName).flatMap(SolverBuildTimeConfig::nearbyDistanceMeterClass).ifPresent(clazz -> {
            if (!NearbyDistanceMeter.class.isAssignableFrom((Class<?>)clazz)) {
                throw new IllegalArgumentException("The Nearby Selection Meter class (%s) of the solver config (%s) does not implement NearbyDistanceMeter.".formatted(clazz, solverName));
            }
            solverConfig.withNearbyDistanceMeterClass(clazz);
        });
    }

    private static List<AnnotationInstance> getAllConcreteSolutionClasses(IndexView indexView) {
        return indexView.getAnnotations(DotNames.PLANNING_SOLUTION).stream().filter(annotationInstance -> !annotationInstance.target().asClass().isAbstract()).toList();
    }

    private Class<?> findFirstSolutionClass(IndexView indexView) {
        List<AnnotationInstance> annotationInstanceCollection = TimefoldProcessor.getAllConcreteSolutionClasses(indexView);
        AnnotationTarget solutionTarget = annotationInstanceCollection.iterator().next().target();
        return this.convertClassInfoToClass(solutionTarget.asClass());
    }

    private List<Class<?>> findEntityClassList(IndexView indexView) {
        ArrayList entityList = new ArrayList(indexView.getAnnotations(DotNames.PLANNING_ENTITY).stream().map(AnnotationInstance::target).map(target -> this.convertClassInfoToClass(target.asClass())).toList());
        ArrayList<Class> childEntityList = new ArrayList<Class>(entityList);
        while (!childEntityList.isEmpty()) {
            List<Class> childEntityImplementorList;
            List<Class> childEntityInterfaceList;
            Class entityClass = childEntityList.remove(0);
            List<Class> childEntityClassList = indexView.getAllKnownSubclasses(entityClass).stream().map(target -> this.convertClassInfoToClass(target.asClass())).toList();
            if (!childEntityClassList.isEmpty()) {
                entityList.addAll(childEntityClassList.stream().filter(c -> !entityList.contains(c)).toList());
                childEntityList.addAll(childEntityClassList);
            }
            if (!(childEntityInterfaceList = indexView.getAllKnownSubinterfaces(entityClass).stream().map(target -> this.convertClassInfoToClass(target.asClass())).toList()).isEmpty()) {
                entityList.addAll(childEntityInterfaceList.stream().filter(c -> !entityList.contains(c)).toList());
                childEntityList.addAll(childEntityInterfaceList);
            }
            if ((childEntityImplementorList = indexView.getAllKnownImplementations(entityClass).stream().map(target -> this.convertClassInfoToClass(target.asClass())).toList()).isEmpty()) continue;
            entityList.addAll(childEntityImplementorList.stream().filter(c -> !entityList.contains(c)).toList());
            childEntityList.addAll(childEntityImplementorList);
        }
        return entityList;
    }

    private void registerClassesFromAnnotations(IndexView indexView, Set<Class<?>> reflectiveClassSet) {
        for (DotNames.BeanDefiningAnnotations beanDefiningAnnotation : DotNames.BeanDefiningAnnotations.values()) {
            for (AnnotationInstance annotationInstance : indexView.getAnnotationsWithRepeatable(beanDefiningAnnotation.getAnnotationDotName(), indexView)) {
                for (String parameterName : beanDefiningAnnotation.getParameterNames()) {
                    AnnotationValue value = annotationInstance.value(parameterName);
                    if (value == null) continue;
                    Type type = value.asClass();
                    try {
                        Class<?> beanClass = Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                        reflectiveClassSet.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find bean class (%s) referenced in annotation (%s).".formatted(type.name(), annotationInstance));
                    }
                }
            }
        }
    }

    protected void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = this.defaultScoreDirectoryFactoryConfig(indexView);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        }
    }

    private boolean isClassDefined(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(IndexView indexView) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findFirstImplementingConcreteClass(DotNames.EASY_SCORE_CALCULATOR, indexView));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findFirstImplementingConcreteClass(DotNames.CONSTRAINT_PROVIDER, indexView));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findFirstImplementingConcreteClass(DotNames.INCREMENTAL_SCORE_CALCULATOR, indexView));
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findFirstImplementingConcreteClass(DotName targetDotName, IndexView indexView) {
        List<ClassInfo> classInfoCollection = indexView.getAllKnownImplementations(targetDotName).stream().filter(classInfo -> !classInfo.isAbstract()).toList();
        if (classInfoCollection.isEmpty()) {
            return null;
        }
        ClassInfo classInfo2 = classInfoCollection.iterator().next();
        return this.convertClassInfoToClass(classInfo2);
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstanceCollection) {
        return "[%s]".formatted(annotationInstanceCollection.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")));
    }

    private <T> Class<? extends T> convertClassInfoToClass(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (%s) cannot be created during deployment.".formatted(className), e);
        }
    }

    private GeneratedGizmoClasses generateDomainAccessors(Map<String, SolverConfig> solverConfigMap, IndexView indexView, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, Set<Class<?>> reflectiveClassSet) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        HashSet<String> generatedMemberAccessorsClassNameSet = new HashSet<String>();
        HashSet<String> gizmoSolutionClonerClassNameSet = new HashSet<String>();
        this.assertSolverDomainAccessType(solverConfigMap);
        GizmoMemberAccessorEntityEnhancer entityEnhancer = new GizmoMemberAccessorEntityEnhancer();
        if (solverConfigMap.values().stream().anyMatch(c -> c.getDomainAccessType() == DomainAccessType.GIZMO)) {
            ArrayList<AnnotationInstance> membersToGeneratedAccessorsForCollection = new ArrayList<AnnotationInstance>();
            for (DotName dotName : DotNames.GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
                membersToGeneratedAccessorsForCollection.addAll(indexView.getAnnotationsWithRepeatable(dotName, indexView));
            }
            TimefoldProcessor.generateDomainAccessorsForShadowSources(indexView, membersToGeneratedAccessorsForCollection);
            membersToGeneratedAccessorsForCollection.removeIf(this::shouldIgnoreMember);
            List<AnnotationInstance> planningSolutionAnnotationInstanceCollection = TimefoldProcessor.getAllConcreteSolutionClasses(indexView);
            List<String> unconfiguredSolverConfigList = solverConfigMap.entrySet().stream().filter(e -> ((SolverConfig)e.getValue()).getSolutionClass() == null).map(Map.Entry::getKey).toList();
            List<String> unusedSolutionClassList = planningSolutionAnnotationInstanceCollection.stream().map(planningClass -> planningClass.target().asClass().name().toString()).filter(planningClassName -> reflectiveClassSet.stream().noneMatch(clazz -> clazz.getName().equals(planningClassName))).toList();
            if (planningSolutionAnnotationInstanceCollection.isEmpty()) {
                throw new IllegalStateException("No classes found with a @%s annotation.".formatted(PlanningSolution.class.getSimpleName()));
            }
            if (planningSolutionAnnotationInstanceCollection.size() > 1 && !unconfiguredSolverConfigList.isEmpty() && !unusedSolutionClassList.isEmpty()) {
                throw new IllegalStateException("Unused classes (%s) found with a @%s annotation.".formatted(String.join((CharSequence)", ", unusedSolutionClassList), PlanningSolution.class.getSimpleName()));
            }
            planningSolutionAnnotationInstanceCollection.forEach(planningSolutionAnnotationInstance -> {
                AutoDiscoverMemberType autoDiscoverMemberType = planningSolutionAnnotationInstance.values().stream().filter(v -> v.name().equals("autoDiscoverMemberType")).findFirst().map(AnnotationValue::asEnum).map(AutoDiscoverMemberType::valueOf).orElse(AutoDiscoverMemberType.NONE);
                if (autoDiscoverMemberType != AutoDiscoverMemberType.NONE) {
                    throw new UnsupportedOperationException("Auto-discovery of members using %s is not supported under Quarkus.\nRemove the autoDiscoverMemberType property from the @%s annotation\nand explicitly annotate the fields or getters with annotations such as @%s, @%s or @%s.".strip().formatted(AutoDiscoverMemberType.class.getSimpleName(), PlanningSolution.class.getSimpleName(), PlanningScore.class.getSimpleName(), PlanningEntityCollectionProperty.class.getSimpleName(), ProblemFactCollectionProperty.class.getSimpleName()));
                }
            });
            for (AnnotationInstance annotatedMember : membersToGeneratedAccessorsForCollection) {
                MethodInfo methodInfo;
                String targetMethodName;
                ClassInfo classInfo = null;
                String memberName = null;
                switch (annotatedMember.target().kind()) {
                    case FIELD: {
                        FieldInfo fieldInfo = annotatedMember.target().asField();
                        classInfo = fieldInfo.declaringClass();
                        memberName = fieldInfo.name();
                        TimefoldProcessor.buildFieldAccessor(annotatedMember, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, classInfo, fieldInfo, transformers);
                        break;
                    }
                    case METHOD: {
                        MethodInfo methodInfo2 = annotatedMember.target().asMethod();
                        classInfo = methodInfo2.declaringClass();
                        memberName = methodInfo2.name();
                        TimefoldProcessor.buildMethodAccessor(annotatedMember, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, classInfo, methodInfo2, true, transformers);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The member (%s) is not on a field or method.".formatted(annotatedMember));
                    }
                }
                if (annotatedMember.name().equals((Object)DotNames.CASCADING_UPDATE_SHADOW_VARIABLE)) {
                    targetMethodName = annotatedMember.value("targetMethodName").asString();
                    methodInfo = classInfo.method(targetMethodName, new Type[0]);
                    TimefoldProcessor.buildMethodAccessor(null, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, classInfo, methodInfo, false, transformers);
                    continue;
                }
                if (!annotatedMember.name().equals((Object)DotNames.SHADOW_VARIABLE) || annotatedMember.value("supplierName") == null) continue;
                targetMethodName = annotatedMember.value("supplierName").asString();
                methodInfo = classInfo.method(targetMethodName, new Type[0]);
                if (methodInfo == null) {
                    throw new IllegalArgumentException("@%s (%s) defines a supplierMethod (%s) that does not exist inside its declaring class (%s).\nMaybe you misspelled the supplierMethod name?".formatted(ShadowVariable.class.getSimpleName(), memberName, targetMethodName, classInfo.name().toString()));
                }
                TimefoldProcessor.buildMethodAccessor(annotatedMember, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, classInfo, methodInfo, true, transformers);
            }
            AnnotationInstance solutionClassInstance = planningSolutionAnnotationInstanceCollection.iterator().next();
            ClassInfo solutionClassInfo = solutionClassInstance.target().asClass();
            FieldInfo constraintFieldInfo = solutionClassInfo.fields().stream().filter(f -> f.type().name().equals((Object)DotNames.CONSTRAINT_WEIGHT_OVERRIDES)).findFirst().orElse(null);
            if (constraintFieldInfo != null) {
                Class solutionClass = this.convertClassInfoToClass(solutionClassInfo);
                Method constraintMethod = ReflectionHelper.getGetterMethod(solutionClass, (String)constraintFieldInfo.name());
                MethodInfo constraintMethodInfo = solutionClassInfo.methods().stream().filter(m -> constraintMethod != null && m.name().equals(constraintMethod.getName()) && m.parametersCount() == 0).findFirst().orElse(null);
                if (constraintMethodInfo != null) {
                    TimefoldProcessor.buildMethodAccessor(solutionClassInstance, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, solutionClassInfo, constraintMethodInfo, true, transformers);
                } else {
                    TimefoldProcessor.buildFieldAccessor(solutionClassInstance, generatedMemberAccessorsClassNameSet, entityEnhancer, (ClassOutput)classOutput, solutionClassInfo, constraintFieldInfo, transformers);
                }
            }
            solverConfigMap.values().forEach(c -> {
                SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((Set)c.getEnablePreviewFeatureSet(), (DomainAccessType)DomainAccessType.REFLECTION, (Class)c.getSolutionClass(), null, null, (List)c.getEntityClassList());
                gizmoSolutionClonerClassNameSet.add(entityEnhancer.generateSolutionCloner(solutionDescriptor, (ClassOutput)classOutput, indexView, transformers));
            });
        }
        entityEnhancer.generateGizmoBeanFactory((ClassOutput)beanClassOutput, reflectiveClassSet, transformers);
        return new GeneratedGizmoClasses(generatedMemberAccessorsClassNameSet, gizmoSolutionClonerClassNameSet);
    }

    private static void generateDomainAccessorsForShadowSources(IndexView indexView, List<AnnotationInstance> membersToGeneratedAccessorsForCollection) {
        for (AnnotationInstance shadowSources : indexView.getAnnotations(DotNames.SHADOW_SOURCES)) {
            Class<?> rootType;
            try {
                rootType = Thread.currentThread().getContextClassLoader().loadClass(shadowSources.target().asMethod().declaringClass().name().toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to load class (%s) which has a @%s annotation.".formatted(shadowSources.target().asMethod().declaringClass().name(), ShadowSources.class.getSimpleName()));
            }
            String[] sources = shadowSources.value().asStringArray();
            AnnotationValue alignmentKey = shadowSources.value("alignmentKey");
            if (alignmentKey != null && !alignmentKey.asString().isEmpty()) {
                TimefoldProcessor.generateDomainAccessorsForSourcePath(indexView, rootType, alignmentKey.asString(), membersToGeneratedAccessorsForCollection);
            }
            for (String source : sources) {
                TimefoldProcessor.generateDomainAccessorsForSourcePath(indexView, rootType, source, membersToGeneratedAccessorsForCollection);
            }
        }
    }

    private static void generateDomainAccessorsForSourcePath(IndexView indexView, Class<?> rootType, String source, List<AnnotationInstance> membersToGeneratedAccessorsForCollection) {
        Iterator iterator = RootVariableSource.pathIterator(rootType, (String)source);
        while (iterator.hasNext()) {
            FieldInfo target;
            Member member = ((PathPart)iterator.next()).member();
            if (member instanceof Field) {
                Field field = (Field)member;
                target = indexView.getClassByName(field.getDeclaringClass()).field(field.getName());
            } else if (member instanceof Method) {
                Method method = (Method)member;
                target = indexView.getClassByName(method.getDeclaringClass()).method(method.getName(), new Type[0]);
            } else {
                throw new IllegalStateException("Member (%s) is not on a field or method.".formatted(member));
            }
            membersToGeneratedAccessorsForCollection.add(AnnotationInstance.builder((DotName)DotNames.SHADOW_SOURCES).value(source).buildWithTarget((AnnotationTarget)target));
        }
    }

    private static void buildFieldAccessor(AnnotationInstance annotatedMember, Set<String> generatedMemberAccessorsClassNameSet, GizmoMemberAccessorEntityEnhancer entityEnhancer, ClassOutput classOutput, ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        try {
            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateFieldAccessor(annotatedMember, classOutput, fieldInfo, transformers));
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new IllegalStateException("Fail to generate member accessor for field (%s) of the class(%s).".formatted(fieldInfo.name(), classInfo.name().toString()), e);
        }
    }

    private static void buildMethodAccessor(AnnotationInstance annotatedMember, Set<String> generatedMemberAccessorsClassNameSet, GizmoMemberAccessorEntityEnhancer entityEnhancer, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, boolean requiredReturnType, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        try {
            generatedMemberAccessorsClassNameSet.add(entityEnhancer.generateMethodAccessor(annotatedMember, classOutput, classInfo, methodInfo, requiredReturnType, transformers));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalStateException("Failed to generate member accessor for the method (%s) of the class (%s).".formatted(methodInfo.name(), classInfo.name()), e);
        }
    }

    private void assertSolverDomainAccessType(Map<String, SolverConfig> solverConfigMap) {
        if (solverConfigMap.values().stream().map(SolverConfig::getDomainAccessType).distinct().count() > 1L) {
            throw new ConfigurationException("The domain access type must be unique across all Solver configurations.\n%s".formatted(solverConfigMap.entrySet().stream().map(e -> String.format("quarkus.timefold.\"%s\".domain-access-type=%s", e.getKey(), ((SolverConfig)e.getValue()).getDomainAccessType())).collect(Collectors.joining("\n"))));
        }
    }

    private boolean shouldIgnoreMember(AnnotationInstance annotationInstance) {
        switch (annotationInstance.target().kind()) {
            case FIELD: {
                return (annotationInstance.target().asField().flags() & 8) != 0;
            }
            case METHOD: {
                return (annotationInstance.target().asMethod().flags() & 8) != 0;
            }
        }
        throw new IllegalArgumentException("Annotation (%s) can only be applied to methods and fields.".formatted(annotationInstance.name()));
    }

    private void registerCustomClassesFromSolverConfig(SolverConfig solverConfig, Set<Class<?>> reflectiveClassSet) {
        solverConfig.visitReferencedClasses(clazz -> {
            if (clazz != null) {
                reflectiveClassSet.add((Class<?>)clazz);
            }
        });
    }
}

