/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python.score;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonJavaTypeMapping;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.numeric.PythonDecimal;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;

public final class BendableDecimalScorePythonJavaTypeMapping
implements PythonJavaTypeMapping<PythonLikeObject, BendableBigDecimalScore> {
    private final PythonLikeType type;
    private final Constructor<?> constructor;
    private final Field hardScoresField;
    private final Field softScoresField;

    public BendableDecimalScorePythonJavaTypeMapping(PythonLikeType type) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        this.type = type;
        Class clazz = type.getJavaClass();
        this.constructor = clazz.getConstructor(new Class[0]);
        this.hardScoresField = clazz.getField("hard_scores");
        this.softScoresField = clazz.getField("soft_scores");
    }

    public PythonLikeType getPythonType() {
        return this.type;
    }

    public Class<? extends BendableBigDecimalScore> getJavaType() {
        return BendableBigDecimalScore.class;
    }

    private static PythonLikeTuple<PythonDecimal> toPythonList(BigDecimal[] scores) {
        PythonLikeTuple out = new PythonLikeTuple();
        for (BigDecimal score : scores) {
            out.add((Object)new PythonDecimal(score));
        }
        return out;
    }

    public PythonLikeObject toPythonObject(BendableBigDecimalScore javaObject) {
        try {
            Object instance = this.constructor.newInstance(new Object[0]);
            this.hardScoresField.set(instance, BendableDecimalScorePythonJavaTypeMapping.toPythonList(javaObject.hardScores()));
            this.softScoresField.set(instance, BendableDecimalScorePythonJavaTypeMapping.toPythonList(javaObject.softScores()));
            return (PythonLikeObject)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public BendableBigDecimalScore toJavaObject(PythonLikeObject pythonObject) {
        try {
            int i;
            PythonLikeTuple hardScoreTuple = (PythonLikeTuple)this.hardScoresField.get(pythonObject);
            PythonLikeTuple softScoreTuple = (PythonLikeTuple)this.softScoresField.get(pythonObject);
            BigDecimal[] hardScores = new BigDecimal[hardScoreTuple.size()];
            BigDecimal[] softScores = new BigDecimal[softScoreTuple.size()];
            for (i = 0; i < hardScores.length; ++i) {
                hardScores[i] = ((PythonDecimal)hardScoreTuple.get((int)i)).value;
            }
            for (i = 0; i < softScores.length; ++i) {
                softScores[i] = ((PythonDecimal)softScoreTuple.get((int)i)).value;
            }
            return BendableBigDecimalScore.of((BigDecimal[])hardScores, (BigDecimal[])softScores);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

