/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python.logging;

import ch.qos.logback.classic.Level;

public enum PythonLogLevel {
    CRITICAL(50, Level.ERROR),
    ERROR(40, Level.ERROR),
    WARNING(30, Level.WARN),
    INFO(20, Level.INFO),
    DEBUG(10, Level.DEBUG),
    TRACE(5, Level.TRACE),
    NOTSET(0, Level.INFO);

    final int pythonLevelNumber;
    final Level javaLogLevel;

    private PythonLogLevel(int pythonLevelNumber, Level javaLogLevel) {
        this.pythonLevelNumber = pythonLevelNumber;
        this.javaLogLevel = javaLogLevel;
    }

    public int getPythonLevelNumber() {
        return this.pythonLevelNumber;
    }

    public Level getJavaLogLevel() {
        return this.javaLogLevel;
    }

    public static PythonLogLevel fromJavaLevel(Level level) {
        if (level.equals(Level.INFO)) {
            return INFO;
        }
        if (level.equals(Level.ERROR)) {
            return ERROR;
        }
        int levelNumber = level.toInt();
        for (PythonLogLevel pythonLogLevel : PythonLogLevel.values()) {
            if (pythonLogLevel.getJavaLogLevel().toInt() != levelNumber) continue;
            return pythonLogLevel;
        }
        throw new IllegalStateException("Unmatched log level (" + String.valueOf(level) + ") with level number (" + level.toInt() + ").");
    }

    public static PythonLogLevel fromPythonLevelNumber(int levelNumber) {
        PythonLogLevel bestMatch = CRITICAL;
        int bestMatchLevelNumber = 50;
        for (PythonLogLevel pythonLogLevel : PythonLogLevel.values()) {
            if (pythonLogLevel.pythonLevelNumber < levelNumber || pythonLogLevel.pythonLevelNumber >= bestMatchLevelNumber) continue;
            bestMatch = pythonLogLevel;
        }
        return bestMatch;
    }
}

