/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.python.score;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonJavaTypeMapping;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class BendableScorePythonJavaTypeMapping
implements PythonJavaTypeMapping<PythonLikeObject, BendableLongScore> {
    private final PythonLikeType type;
    private final Constructor<?> constructor;
    private final Field initScoreField;
    private final Field hardScoresField;
    private final Field softScoresField;

    public BendableScorePythonJavaTypeMapping(PythonLikeType type) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        this.type = type;
        Class clazz = type.getJavaClass();
        this.constructor = clazz.getConstructor(new Class[0]);
        this.initScoreField = clazz.getField("init_score");
        this.hardScoresField = clazz.getField("hard_scores");
        this.softScoresField = clazz.getField("soft_scores");
    }

    public PythonLikeType getPythonType() {
        return this.type;
    }

    public Class<? extends BendableLongScore> getJavaType() {
        return BendableLongScore.class;
    }

    private static PythonLikeTuple<PythonInteger> toPythonList(long[] scores) {
        PythonLikeTuple out = new PythonLikeTuple();
        for (long score : scores) {
            out.add((Object)PythonInteger.valueOf((long)score));
        }
        return out;
    }

    public PythonLikeObject toPythonObject(BendableLongScore javaObject) {
        try {
            Object instance = this.constructor.newInstance(new Object[0]);
            this.initScoreField.set(instance, PythonInteger.valueOf((int)javaObject.initScore()));
            this.hardScoresField.set(instance, BendableScorePythonJavaTypeMapping.toPythonList(javaObject.hardScores()));
            this.softScoresField.set(instance, BendableScorePythonJavaTypeMapping.toPythonList(javaObject.softScores()));
            return (PythonLikeObject)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public BendableLongScore toJavaObject(PythonLikeObject pythonObject) {
        try {
            int i;
            int initScore = ((PythonInteger)this.initScoreField.get((Object)pythonObject)).value.intValue();
            PythonLikeTuple hardScoreTuple = (PythonLikeTuple)this.hardScoresField.get(pythonObject);
            PythonLikeTuple softScoreTuple = (PythonLikeTuple)this.softScoresField.get(pythonObject);
            long[] hardScores = new long[hardScoreTuple.size()];
            long[] softScores = new long[softScoreTuple.size()];
            for (i = 0; i < hardScores.length; ++i) {
                hardScores[i] = ((PythonInteger)hardScoreTuple.get((int)i)).value.longValue();
            }
            for (i = 0; i < softScores.length; ++i) {
                softScores[i] = ((PythonInteger)softScoreTuple.get((int)i)).value.longValue();
            }
            if (initScore == 0) {
                return BendableLongScore.of((long[])hardScores, (long[])softScores);
            }
            return BendableLongScore.ofUninitialized((int)initScore, (long[])hardScores, (long[])softScores);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

