/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LinkedIdentityHashSet<V>
extends AbstractSet<V> {
    private final ElementAwareLinkedList<V> delegate = new ElementAwareLinkedList();
    private final IdentityHashMap<V, ElementAwareLinkedList.Entry<V>> identityMap = new IdentityHashMap();
    private int size = 0;

    @Override
    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        return this.identityMap.containsKey(o);
    }

    @Override
    public boolean add(V v) {
        ElementAwareLinkedList.Entry<V> entry = this.identityMap.get(v);
        if (entry == null) {
            this.identityMap.put((ElementAwareLinkedList.Entry<V>)v, (ElementAwareLinkedList.Entry<ElementAwareLinkedList.Entry<V>>)this.delegate.add(v));
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.size == 0) {
            return false;
        }
        ElementAwareLinkedList.Entry<V> entry = this.identityMap.remove(o);
        if (entry == null) {
            return false;
        }
        entry.remove();
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.identityMap.clear();
        this.delegate.clear();
        this.size = 0;
    }
}

