/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class ElementAwareLinkedList<T>
implements Iterable<T> {
    private int size = 0;
    private Entry<T> first = null;
    private Entry<T> last = null;

    public Entry<T> add(T tuple) {
        Entry<T> entry = new Entry<T>(this, tuple, this.last);
        if (this.first == null) {
            this.first = entry;
        } else {
            this.last.next = entry;
        }
        this.last = entry;
        ++this.size;
        return entry;
    }

    public Entry<T> addFirst(T tuple) {
        if (this.first != null) {
            Entry<T> entry = new Entry<T>(this, tuple, null);
            this.first.previous = entry;
            entry.next = this.first;
            this.first = entry;
            ++this.size;
            return entry;
        }
        return this.add(tuple);
    }

    public Entry<T> addAfter(T tuple, Entry<T> previous) {
        Objects.requireNonNull(previous);
        if (this.first == null || previous == this.last) {
            return this.add(tuple);
        }
        Entry<T> entry = new Entry<T>(this, tuple, previous);
        Entry currentNext = previous.next;
        if (currentNext != null) {
            currentNext.previous = entry;
        } else {
            this.last = entry;
        }
        previous.next = entry;
        entry.next = currentNext;
        ++this.size;
        return entry;
    }

    public void remove(Entry<T> entry) {
        if (this.first == entry) {
            this.first = entry.next;
        } else {
            entry.previous.next = entry.next;
        }
        if (this.last == entry) {
            this.last = entry.previous;
        } else {
            entry.next.previous = entry.previous;
        }
        entry.previous = null;
        entry.next = null;
        --this.size;
    }

    public Entry<T> first() {
        return this.first;
    }

    public Entry<T> last() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void forEach(Consumer<? super T> tupleConsumer) {
        Entry<T> entry = this.first;
        while (entry != null) {
            Entry next = entry.next;
            tupleConsumer.accept(entry.getElement());
            entry = next;
        }
    }

    public void clear(Consumer<? super T> tupleConsumer) {
        this.forEach(tupleConsumer);
        this.clear();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.size == 0) {
            return Collections.emptyIterator();
        }
        return new ElementAwareListIterator<T>(this.first);
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public Iterator<T> randomizedIterator(Random random) {
        return switch (this.size) {
            case 0 -> Collections.emptyIterator();
            case 1 -> Collections.singleton(this.first.getElement()).iterator();
            case 2 -> {
                List<T> list = random.nextBoolean() ? List.of(this.first.getElement(), this.last.getElement()) : List.of(this.last.getElement(), this.first.getElement());
                yield list.iterator();
            }
            default -> {
                ArrayList copy = new ArrayList(this.size);
                ArrayList<Integer> indexList = new ArrayList<Integer>(this.size);
                this.forEach(e -> {
                    copy.add(e);
                    indexList.add(copy.size() - 1);
                });
                yield new RandomElementAwareListIterator(copy, indexList, random);
            }
        };
    }

    public String toString() {
        switch (this.size) {
            case 0: {
                return "[]";
            }
            case 1: {
                return "[" + String.valueOf(this.first.getElement()) + "]";
            }
        }
        StringBuilder builder = new StringBuilder("[");
        for (T entry : this) {
            builder.append(entry).append(", ");
        }
        builder.replace(builder.length() - 2, builder.length(), "");
        return builder.append("]").toString();
    }

    @NullMarked
    public static final class Entry<T>
    implements ListEntry<T> {
        private @Nullable ElementAwareLinkedList<T> list;
        private final T element;
        @Nullable Entry<T> previous;
        @Nullable Entry<T> next;

        Entry(ElementAwareLinkedList<T> list, T element, @Nullable Entry<T> previous) {
            this.list = list;
            this.element = element;
            this.previous = previous;
            this.next = null;
        }

        public @Nullable Entry<T> previous() {
            return this.previous;
        }

        public @Nullable Entry<T> next() {
            return this.next;
        }

        public void remove() {
            if (this.isRemoved()) {
                throw new IllegalStateException("The element (" + String.valueOf(this.element) + ") was already removed.");
            }
            this.list.remove(this);
            this.list = null;
        }

        @Override
        public boolean isRemoved() {
            return this.list == null;
        }

        @Override
        public T getElement() {
            return this.element;
        }

        public @Nullable ElementAwareLinkedList<T> getList() {
            return this.list;
        }

        public String toString() {
            return this.element.toString();
        }
    }

    private static final class ElementAwareListIterator<T>
    implements Iterator<T> {
        private Entry<T> nextEntry;

        public ElementAwareListIterator(Entry<T> nextEntry) {
            this.nextEntry = nextEntry;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T element = this.nextEntry.getElement();
            this.nextEntry = this.nextEntry.next;
            return element;
        }
    }

    private static final class RandomElementAwareListIterator<T>
    implements Iterator<T> {
        private final List<T> elementList;
        private final List<Integer> unusedIndexList;
        private final Random random;

        public RandomElementAwareListIterator(List<T> copiedList, List<Integer> unusedIndexList, Random random) {
            this.random = random;
            this.elementList = copiedList;
            this.unusedIndexList = unusedIndexList;
        }

        @Override
        public boolean hasNext() {
            return !this.unusedIndexList.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int randomUnusedIndex = this.random.nextInt(this.unusedIndexList.size());
            Integer elementIndex = this.unusedIndexList.remove(randomUnusedIndex);
            return this.elementList.get(elementIndex);
        }
    }
}

