/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ElementAwareArrayList<T> {
    private final List<Entry<T>> elementList = new ArrayList<Entry<T>>();
    private int lastElementPosition = -1;
    private int gapCount = 0;

    public Entry<T> add(T element) {
        Entry<T> newEntry = new Entry<T>(element, ++this.lastElementPosition);
        this.elementList.add(newEntry);
        return newEntry;
    }

    public void remove(Entry<T> entry) {
        if (entry.isRemoved()) {
            throw new IllegalStateException("The entry (%s) was already removed.".formatted(entry));
        }
        entry.position = -1;
        ++this.gapCount;
        this.clearIfPossible();
    }

    private boolean clearIfPossible() {
        if (this.gapCount > 0 && this.lastElementPosition + 1 == this.gapCount) {
            this.forceClear();
            return true;
        }
        return false;
    }

    private void forceClear() {
        this.elementList.clear();
        this.gapCount = 0;
        this.lastElementPosition = -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.lastElementPosition - this.gapCount + 1;
    }

    public void forEach(Consumer<T> elementConsumer) {
        if (this.gapCount == 0) {
            this.forEachWithoutGaps(elementConsumer);
        } else {
            this.forEachCompacting(elementConsumer);
        }
    }

    private void forEachWithoutGaps(Consumer<T> elementConsumer) {
        for (int i = 0; i <= this.lastElementPosition; ++i) {
            elementConsumer.accept(this.elementList.get(i).getElement());
        }
    }

    private void forEachCompacting(Consumer<T> elementConsumer) {
        if (this.clearIfPossible()) {
            return;
        }
        int[] indexesToRemove = new int[this.gapCount];
        int encounteredGaps = 0;
        for (int i = 0; i <= this.lastElementPosition; ++i) {
            Entry<T> element = this.elementList.get(i);
            if (element.isRemoved()) {
                if (this.clearTailGapsIfPossible(i, encounteredGaps + 1, indexesToRemove)) {
                    return;
                }
                indexesToRemove[encounteredGaps++] = i;
                continue;
            }
            elementConsumer.accept(element.getElement());
            if (encounteredGaps <= 0) continue;
            element.position = i - encounteredGaps;
        }
        this.clearGaps(indexesToRemove);
    }

    private boolean clearTailGapsIfPossible(int currentGapPosition, int encounteredGaps, int ... indexesToRemove) {
        int remainingGaps = this.gapCount - encounteredGaps;
        if (remainingGaps == 0) {
            return false;
        }
        int remainingElements = this.lastElementPosition - currentGapPosition;
        if (remainingElements == remainingGaps) {
            this.elementList.subList(currentGapPosition, this.lastElementPosition + 1).clear();
            this.clearGaps(indexesToRemove, encounteredGaps - 2);
            return true;
        }
        if (remainingElements > remainingGaps) {
            return false;
        }
        throw new IllegalStateException("Impossible state: the number of remaining elements (%d) is less than the number of remaining gaps (%d).".formatted(remainingElements, remainingGaps));
    }

    private void clearGaps(int[] gaps, int topMostIndexToInclude) {
        for (int index = topMostIndexToInclude; index >= 0; --index) {
            this.elementList.remove(gaps[index]);
        }
        this.lastElementPosition = this.elementList.size() - 1;
        this.gapCount = 0;
    }

    private void clearGaps(int[] indexesToRemove) {
        this.clearGaps(indexesToRemove, indexesToRemove.length - 1);
    }

    public List<Entry<T>> asList() {
        if (this.isEmpty() || this.compact()) {
            return Collections.emptyList();
        }
        return this.elementList;
    }

    private boolean compact() {
        if (this.gapCount == 0) {
            return this.isEmpty();
        }
        if (this.clearIfPossible()) {
            return true;
        }
        int[] indexesToRemove = new int[this.gapCount];
        int encounteredGaps = 0;
        for (int i = 0; i <= this.lastElementPosition; ++i) {
            Entry<T> element = this.elementList.get(i);
            if (element.isRemoved()) {
                if (this.clearTailGapsIfPossible(i, encounteredGaps + 1, indexesToRemove)) {
                    return false;
                }
                indexesToRemove[encounteredGaps++] = i;
                continue;
            }
            if (encounteredGaps <= 0) continue;
            element.position = i - encounteredGaps;
        }
        this.clearGaps(indexesToRemove);
        return false;
    }

    public static final class Entry<T>
    implements ListEntry<T> {
        private final T element;
        private int position;

        private Entry(T element, int position) {
            this.element = element;
            this.position = position;
        }

        @Override
        public boolean isRemoved() {
            return this.position < 0;
        }

        @Override
        public T getElement() {
            return this.element;
        }

        public String toString() {
            return this.isRemoved() ? "null" : String.valueOf(this.element) + "@" + this.position;
        }
    }
}

