/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedAssignment;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.VariableSnapshotTotal;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.Assigner;
import ai.timefold.solver.core.impl.solver.DefaultRecommendedAssignment;
import ai.timefold.solver.core.impl.solver.DefaultRecommendedFit;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import ai.timefold.solver.core.impl.util.MutableReference;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DefaultSolutionManager<Solution_, Score_ extends Score<Score_>>
implements SolutionManager<Solution_, Score_> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final ScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public <ProblemId_> DefaultSolutionManager(SolverManager<Solution_, ProblemId_> solverManager) {
        this(((DefaultSolverManager)solverManager).getSolverFactory());
    }

    public DefaultSolutionManager(SolverFactory<Solution_> solverFactory) {
        this.solverFactory = (DefaultSolverFactory)solverFactory;
        this.scoreDirectorFactory = this.solverFactory.getScoreDirectorFactory();
    }

    public ScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Score_ update(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (solutionUpdatePolicy == SolutionUpdatePolicy.NO_UPDATE) {
            throw new IllegalArgumentException("Can not call " + this.getClass().getSimpleName() + ".update() with this solutionUpdatePolicy (" + String.valueOf((Object)solutionUpdatePolicy) + ").");
        }
        return (Score_)this.callScoreDirector(solution, solutionUpdatePolicy, s -> s.getSolutionDescriptor().getScore(s.getWorkingSolution()), ConstraintMatchPolicy.DISABLED, false);
    }

    private <Result_> Result_ callScoreDirector(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy, Function<InnerScoreDirector<Solution_, Score_>, Result_> function, ConstraintMatchPolicy constraintMatchPolicy, boolean cloneSolution) {
        boolean isShadowVariableUpdateEnabled = solutionUpdatePolicy.isShadowVariableUpdateEnabled();
        Solution_ nonNullSolution = Objects.requireNonNull(solution);
        try (AbstractScoreDirector scoreDirector = ((AbstractScoreDirector.AbstractScoreDirectorBuilder)((AbstractScoreDirector.AbstractScoreDirectorBuilder)((AbstractScoreDirector.AbstractScoreDirectorBuilder)this.getScoreDirectorFactory().createScoreDirectorBuilder().withLookUpEnabled(cloneSolution)).withConstraintMatchPolicy(constraintMatchPolicy)).withExpectShadowVariablesInCorrectState(!isShadowVariableUpdateEnabled)).build();){
            Solution_ Solution_ = nonNullSolution = cloneSolution ? scoreDirector.cloneSolution(nonNullSolution) : nonNullSolution;
            if (isShadowVariableUpdateEnabled) {
                scoreDirector.setWorkingSolution(nonNullSolution);
            } else {
                VariableSnapshotTotal<Solution_> oldSnapshot = VariableSnapshotTotal.takeSnapshot(this.scoreDirectorFactory.getSolutionDescriptor(), nonNullSolution);
                scoreDirector.setWorkingSolutionWithoutUpdatingShadows(nonNullSolution);
                oldSnapshot.restore();
            }
            if (constraintMatchPolicy.isEnabled() && !scoreDirector.getConstraintMatchPolicy().isEnabled()) {
                throw new IllegalStateException("Requested constraint matching but score director doesn't support it.\nMaybe use Constraint Streams instead of Easy or Incremental score calculator?");
            }
            if (solutionUpdatePolicy.isScoreUpdateEnabled()) {
                scoreDirector.calculateScore();
            }
            Result_ Result_ = function.apply(scoreDirector);
            return Result_;
        }
    }

    @Override
    public ScoreExplanation<Solution_, Score_> explain(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        DefaultScoreExplanation explanation = this.callScoreDirector(solution, solutionUpdatePolicy, DefaultScoreExplanation::new, ConstraintMatchPolicy.ENABLED, false);
        this.assertFreshScore(solution, currentScore, explanation.getScore(), solutionUpdatePolicy);
        return explanation;
    }

    private void assertFreshScore(Solution_ solution, Score_ currentScore, Score_ calculatedScore, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (!solutionUpdatePolicy.isScoreUpdateEnabled() && !Objects.equals(currentScore, calculatedScore)) {
            throw new IllegalStateException("Current score (%s) and freshly calculated score (%s) for solution (%s) do not match.\nMaybe run %s environment mode to check for score corruptions.\nOtherwise enable %s.%s to update the stale score.\n".formatted(new Object[]{currentScore, calculatedScore, solution, EnvironmentMode.TRACKED_FULL_ASSERT, SolutionUpdatePolicy.class.getSimpleName(), SolutionUpdatePolicy.UPDATE_ALL}));
        }
    }

    @Override
    public ScoreAnalysis<Score_> analyze(Solution_ solution, ScoreAnalysisFetchPolicy fetchPolicy, SolutionUpdatePolicy solutionUpdatePolicy) {
        Objects.requireNonNull(fetchPolicy, "fetchPolicy");
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        ScoreAnalysis analysis = this.callScoreDirector(solution, solutionUpdatePolicy, scoreDirector -> scoreDirector.buildScoreAnalysis(fetchPolicy), ConstraintMatchPolicy.match(fetchPolicy), false);
        this.assertFreshScore(solution, currentScore, analysis.score(), solutionUpdatePolicy);
        return analysis;
    }

    @Override
    public PlanningSolutionDiff<Solution_> diff(Solution_ oldSolution, Solution_ newSolution) {
        this.solverFactory.ensurePreviewFeature(PreviewFeature.PLANNING_SOLUTION_DIFF);
        return this.solverFactory.getSolutionDescriptor().diff(oldSolution, newSolution);
    }

    @Override
    public <In_, Out_> List<RecommendedAssignment<Out_, Score_>> recommendAssignment(Solution_ solution, In_ evaluatedEntityOrElement, Function<In_, @Nullable Out_> propositionFunction, ScoreAnalysisFetchPolicy fetchPolicy) {
        Assigner assigner = new Assigner(this.solverFactory, propositionFunction, DefaultRecommendedAssignment::new, fetchPolicy, solution, evaluatedEntityOrElement);
        return (List)this.callScoreDirector(solution, SolutionUpdatePolicy.UPDATE_ALL, assigner, ConstraintMatchPolicy.match(fetchPolicy), true);
    }

    @Override
    public <In_, Out_> List<RecommendedFit<Out_, Score_>> recommendFit(Solution_ solution, In_ fittedEntityOrElement, Function<In_, @Nullable Out_> propositionFunction, ScoreAnalysisFetchPolicy fetchPolicy) {
        Assigner assigner = new Assigner(this.solverFactory, propositionFunction, DefaultRecommendedFit::new, fetchPolicy, solution, fittedEntityOrElement);
        return (List)this.callScoreDirector(solution, SolutionUpdatePolicy.UPDATE_ALL, assigner, ConstraintMatchPolicy.match(fetchPolicy), true);
    }

    public @Nullable String visualizeNodeNetwork(Solution_ solution) {
        ScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.scoreDirectorFactory;
        if (scoreDirectorFactory instanceof BavetConstraintStreamScoreDirectorFactory) {
            BavetConstraintStreamScoreDirectorFactory bavetScoreDirectorFactory = (BavetConstraintStreamScoreDirectorFactory)scoreDirectorFactory;
            MutableReference<Object> result = new MutableReference<Object>(null);
            bavetScoreDirectorFactory.newSession(solution, new ConsistencyTracker(), ConstraintMatchPolicy.ENABLED, false, result::setValue);
            return result.getValue();
        }
        throw new UnsupportedOperationException("Node network visualization is only supported when using Constraint Streams.");
    }
}

