/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.event.EventProducerId;
import java.util.List;
import java.util.concurrent.CompletableFuture;

final class BestSolutionContainingProblemChanges<Solution_> {
    private final Solution_ bestSolution;
    private final EventProducerId producerId;
    private final List<CompletableFuture<Void>> containedProblemChanges;

    public BestSolutionContainingProblemChanges(Solution_ bestSolution, EventProducerId producerId, List<CompletableFuture<Void>> containedProblemChanges) {
        this.bestSolution = bestSolution;
        this.producerId = producerId;
        this.containedProblemChanges = containedProblemChanges;
    }

    public Solution_ getBestSolution() {
        return this.bestSolution;
    }

    public EventProducerId getProducerId() {
        return this.producerId;
    }

    public void completeProblemChanges() {
        this.containedProblemChanges.forEach(futureProblemChange -> futureProblemChange.complete(null));
    }

    public void completeProblemChangesExceptionally(Throwable exception) {
        this.containedProblemChanges.forEach(futureProblemChange -> futureProblemChange.completeExceptionally(exception));
    }
}

