/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.uni;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.bi.joiner.DefaultBiJoiner;
import ai.timefold.solver.core.impl.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.InTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.uni.IndexedIfExistsUniNode;
import ai.timefold.solver.core.impl.bavet.uni.UnindexedIfExistsUniNode;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetIfExistsConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetAbstractUniConstraintStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

final class BavetIfExistsUniConstraintStream<Solution_, A, B>
extends BavetAbstractUniConstraintStream<Solution_, A>
implements BavetIfExistsConstraintStream<Solution_> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parentA;
    private final BavetForeBridgeUniConstraintStream<Solution_, B> parentBridgeB;
    private final boolean shouldExist;
    private final DefaultBiJoiner<A, B> joiner;
    private final BiPredicate<A, B> filtering;

    public BavetIfExistsUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parentA, BavetForeBridgeUniConstraintStream<Solution_, B> parentBridgeB, boolean shouldExist, DefaultBiJoiner<A, B> joiner, BiPredicate<A, B> filtering) {
        super(constraintFactory, parentA.getRetrievalSemantics());
        this.parentA = parentA;
        this.parentBridgeB = parentBridgeB;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parentA.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parentA.collectActiveConstraintStreams(constraintStreamSet);
        this.parentBridgeB.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getTupleSource() {
        return this.parentA.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        InOutTupleStorePositionTracker positionTracker = buildHelper.getTupleStorePositionTracker(this, this.parentA.getTupleSource(), this.parentBridgeB.getTupleSource());
        AbstractIfExistsNode node = indexerFactory.hasJoiners() ? (this.filtering == null ? new IndexedIfExistsUniNode(this.shouldExist, indexerFactory, downstream, (InTupleStorePositionTracker)positionTracker) : new IndexedIfExistsUniNode(this.shouldExist, indexerFactory, downstream, this.filtering, positionTracker)) : (this.filtering == null ? new UnindexedIfExistsUniNode(this.shouldExist, downstream, positionTracker) : new UnindexedIfExistsUniNode(this.shouldExist, downstream, this.filtering, (InTupleStorePositionTracker)positionTracker));
        buildHelper.addNode(node, this, this, this.parentBridgeB);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetIfExistsUniConstraintStream that = (BavetIfExistsUniConstraintStream)object;
        return this.shouldExist == that.shouldExist && Objects.equals(this.parentA, that.parentA) && Objects.equals(this.parentBridgeB.getParent(), that.parentBridgeB.getParent()) && Objects.equals(this.joiner, that.joiner) && Objects.equals(this.filtering, that.filtering);
    }

    public int hashCode() {
        return Objects.hash(this.parentA, this.parentBridgeB.getParent(), this.shouldExist, this.joiner, this.filtering);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.parentA;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.parentBridgeB;
    }
}

