/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.tri;

import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.bavet.common.AbstractJoinNode;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.tri.IndexedJoinTriNode;
import ai.timefold.solver.core.impl.bavet.tri.UnindexedJoinTriNode;
import ai.timefold.solver.core.impl.bavet.tri.joiner.DefaultTriJoiner;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetJoinConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeBiConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import java.util.Objects;
import java.util.Set;

public final class BavetJoinTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent;
    private final BavetForeBridgeUniConstraintStream<Solution_, C> rightParent;
    private final DefaultTriJoiner<A, B, C> joiner;
    private final TriPredicate<A, B, C> filtering;

    public BavetJoinTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeUniConstraintStream<Solution_, C> rightParent, DefaultTriJoiner<A, B, C> joiner, TriPredicate<A, B, C> filtering) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(ConstraintNodeBuildHelper<Solution_, Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        InOutTupleStorePositionTracker positionTracker = buildHelper.getTupleStorePositionTracker(this, this.leftParent.getTupleSource(), this.rightParent.getTupleSource());
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinTriNode(indexerFactory, downstream, this.filtering, positionTracker) : new UnindexedJoinTriNode(downstream, this.filtering, positionTracker);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinTriConstraintStream other = (BavetJoinTriConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner) && Objects.equals(this.filtering, other.filtering);
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering);
    }

    public String toString() {
        return "TriJoin() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }
}

