/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.bavet.common;

import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.api.score.stream.PrecomputeFactory;
import ai.timefold.solver.core.impl.bavet.NodeNetwork;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractNodeBuildHelper;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.BavetRootNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.RecordingTupleLifecycle;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.score.buildin.SimpleScoreDefinition;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.bavet.common.BavetConstraintStreamBinaryOperation;
import ai.timefold.solver.core.impl.score.stream.bavet.common.ConstraintNodeBuildHelper;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class BavetPrecomputeBuildHelper<Tuple_ extends AbstractTuple> {
    private final NodeNetwork nodeNetwork;
    private final RecordingTupleLifecycle<Tuple_> recordingTupleLifecycle;
    private final Class<?>[] sourceClasses;
    private final Set<Class<?>> entityClassSet;

    public <Solution_> BavetPrecomputeBuildHelper(BavetAbstractConstraintStream<Solution_> recordingPrecomputeConstraintStream, Set<Class<?>> entityClassSet) {
        if (recordingPrecomputeConstraintStream.getRetrievalSemantics() != RetrievalSemantics.PRECOMPUTE) {
            throw new IllegalStateException("Impossible state: %s is not %s but is instead %s. Maybe you accidentally used a %s from %s instead of %s?".formatted(new Object[]{RetrievalSemantics.class.getSimpleName(), RetrievalSemantics.PRECOMPUTE, recordingPrecomputeConstraintStream.getRetrievalSemantics(), ConstraintStream.class.getSimpleName(), ConstraintFactory.class.getSimpleName(), PrecomputeFactory.class.getSimpleName()}));
        }
        this.entityClassSet = entityClassSet;
        ArrayList<BavetAbstractConstraintStream> streamList = new ArrayList<BavetAbstractConstraintStream>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.addLast(recordingPrecomputeConstraintStream);
        while (!queue.isEmpty()) {
            BavetAbstractConstraintStream current = (BavetAbstractConstraintStream)queue.pollFirst();
            streamList.add(current);
            if (current instanceof BavetConstraintStreamBinaryOperation) {
                BavetConstraintStreamBinaryOperation binaryOperation = (BavetConstraintStreamBinaryOperation)((Object)current);
                queue.addLast(binaryOperation.getLeftParent());
                queue.addLast(binaryOperation.getRightParent());
                continue;
            }
            if (current.getParent() == null) continue;
            queue.addLast(current.getParent());
        }
        Collections.reverse(streamList);
        LinkedHashSet streamSet = new LinkedHashSet(streamList);
        ConstraintNodeBuildHelper buildHelper = new ConstraintNodeBuildHelper(new ConsistencyTracker(), streamSet, AbstractScoreInliner.buildScoreInliner(new SimpleScoreDefinition(), Collections.emptyMap(), ConstraintMatchPolicy.DISABLED));
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        List<AbstractNode> nodeList = buildHelper.buildNodeList(streamSet, buildHelper, BavetAbstractConstraintStream::buildNode, node -> {
            Class<?>[] nodeSourceClasses;
            if (!(node instanceof BavetRootNode)) {
                return;
            }
            BavetRootNode sourceRootNode = (BavetRootNode)((Object)node);
            for (Class<?> nodeSourceClass : nodeSourceClasses = sourceRootNode.getSourceClasses()) {
                List sourceNodeList = declaredClassToNodeMap.computeIfAbsent(nodeSourceClass, k -> new ArrayList(2));
                sourceNodeList.add(sourceRootNode);
            }
        });
        this.nodeNetwork = AbstractNodeBuildHelper.buildNodeNetwork(nodeList, declaredClassToNodeMap);
        this.recordingTupleLifecycle = (RecordingTupleLifecycle)buildHelper.getAggregatedTupleLifecycle(List.of(recordingPrecomputeConstraintStream));
        this.sourceClasses = declaredClassToNodeMap.keySet().toArray(new Class[0]);
    }

    public NodeNetwork getNodeNetwork() {
        return this.nodeNetwork;
    }

    public RecordingTupleLifecycle<Tuple_> getRecordingTupleLifecycle() {
        return this.recordingTupleLifecycle;
    }

    public Class<?>[] getSourceClasses() {
        return this.sourceClasses;
    }

    public boolean isSourceEntityClass(Class<?> maybeSourceEntityClass) {
        for (Class<?> entityClass : this.entityClassSet) {
            if (!entityClass.isAssignableFrom(maybeSourceEntityClass)) continue;
            return true;
        }
        return false;
    }
}

