/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.stream;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintSession;
import java.util.ArrayList;
import java.util.Map;
import org.jspecify.annotations.NullMarked;

public final class BavetConstraintStreamScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>> {
    private final boolean derived;
    private BavetConstraintSession<Score_> session;

    private BavetConstraintStreamScoreDirector(Builder<Solution_, Score_> builder, boolean derived) {
        super(builder);
        this.derived = derived;
    }

    public void clearShadowVariablesListenerQueue() {
        this.clearVariableListenerEvents();
    }

    public void updateConsistencyFromSolution(Solution_ solution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        ArrayList entityList = new ArrayList();
        solutionDescriptor.visitAllEntities(solution, entityList::add);
        this.variableListenerSupport.setConsistencyTracker(ConsistencyTracker.frozen(this.getSolutionDescriptor(), entityList.toArray()));
    }

    @Override
    public void setWorkingSolutionWithoutUpdatingShadows(Solution_ workingSolution) {
        this.session = ((BavetConstraintStreamScoreDirectorFactory)this.scoreDirectorFactory).newSession(workingSolution, this.variableListenerSupport.getConsistencyTracker(), this.constraintMatchPolicy, this.derived);
        super.setWorkingSolutionWithoutUpdatingShadows(workingSolution, this.session::insert);
    }

    @Override
    protected void afterSetWorkingSolution() {
        this.session.settle();
    }

    @Override
    public InnerScore<Score_> calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score_ score = this.session.calculateScore();
        this.setCalculatedScore(score);
        return new InnerScore<Score_>(score, -this.getWorkingInitScore());
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (!this.constraintMatchPolicy.isEnabled()) {
            throw new IllegalStateException("When constraint matching is disabled, this method should not be called.");
        }
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        return this.session.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (!this.constraintMatchPolicy.isJustificationEnabled()) {
            throw new IllegalStateException("When constraint matching with justifications is disabled, this method should not be called.");
        }
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        return this.session.getIndictmentMap();
    }

    @Override
    public boolean requiresFlushing() {
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.session != null) {
            this.session = null;
        }
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (%s) cannot be added to the ScoreDirector.".formatted(entity));
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (%s) of class (%s) is not a configured @%s.".formatted(entity, entity.getClass(), PlanningEntity.class.getSimpleName()));
        }
        this.session.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.session.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.session.update(entity);
        super.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.session.retract(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (problemFact == null) {
            throw new IllegalArgumentException("The problemFact (%s) cannot be added to the ScoreDirector.".formatted(problemFact));
        }
        this.session.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
        super.beforeProblemPropertyChanged(problemFactOrEntity);
        this.session.retract(problemFactOrEntity);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.session.insert(problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.session.retract(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    public BavetConstraintSession<Score_> getSession() {
        return this.session;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @NullMarked
    public static final class Builder<Solution_, Score_ extends Score<Score_>>
    extends AbstractScoreDirector.AbstractScoreDirectorBuilder<Solution_, Score_, BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>, Builder<Solution_, Score_>> {
        public Builder(BavetConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
            super(scoreDirectorFactory);
        }

        public BavetConstraintStreamScoreDirector<Solution_, Score_> build() {
            return new BavetConstraintStreamScoreDirector(this, false);
        }

        @Override
        public AbstractScoreDirector<Solution_, Score_, BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>> buildDerived() {
            return new BavetConstraintStreamScoreDirector(this, true);
        }
    }
}

