/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.incremental;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.calculator.IncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.constraint.DefaultIndictment;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class IncrementalScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, IncrementalScoreDirectorFactory<Solution_, Score_>> {
    private final IncrementalScoreCalculator<Solution_, Score_> incrementalScoreCalculator;

    private IncrementalScoreDirector(Builder<Solution_, Score_> builder) {
        super(builder);
        this.incrementalScoreCalculator = Objects.requireNonNull(builder.incrementalScoreCalculator, "The incrementalScoreCalculator must not be null.");
    }

    public IncrementalScoreCalculator<Solution_, Score_> getIncrementalScoreCalculator() {
        return this.incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolutionWithoutUpdatingShadows(Solution_ workingSolution) {
        super.setWorkingSolutionWithoutUpdatingShadows(workingSolution, null);
        if (this.incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator) {
            ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).resetWorkingSolution(workingSolution, this.getConstraintMatchPolicy().isEnabled());
        } else {
            this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
        }
    }

    @Override
    public InnerScore<Score_> calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        Score score = (Score)Objects.requireNonNull(this.incrementalScoreCalculator.calculateScore(), () -> "The incrementalScoreCalculator (%s) must return a non-null score in the method calculateScore().".formatted(this.incrementalScoreCalculator));
        this.setCalculatedScore(score);
        return new InnerScore<Score>(score, -this.getWorkingInitScore());
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (!this.constraintMatchPolicy.isEnabled()) {
            throw new IllegalStateException("When constraint matching (" + String.valueOf((Object)this.constraintMatchPolicy) + ") is disabled in the constructor, this method should not be called.");
        }
        return ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).getConstraintMatchTotals().stream().collect(Collectors.toMap(c -> c.getConstraintRef().constraintId(), Function.identity()));
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (!this.constraintMatchPolicy.isJustificationEnabled()) {
            throw new IllegalStateException("When constraint matching with justifications (" + String.valueOf((Object)this.constraintMatchPolicy) + ") is disabled in the constructor, this method should not be called.");
        }
        Map incrementalIndictmentMap = ((ConstraintMatchAwareIncrementalScoreCalculator)this.incrementalScoreCalculator).getIndictmentMap();
        if (incrementalIndictmentMap != null) {
            return incrementalIndictmentMap;
        }
        LinkedHashMap indictmentMap = new LinkedHashMap();
        Object zeroScore = this.getScoreDefinition().getZeroScore();
        Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap = this.getConstraintMatchTotalMap();
        for (ConstraintMatchTotal<Score_> constraintMatchTotal : constraintMatchTotalMap.values()) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch.getIndictedObjectList().stream().filter(Objects::nonNull).distinct().forEach(fact -> {
                    DefaultIndictment indictment = (DefaultIndictment)indictmentMap.computeIfAbsent(fact, k -> new DefaultIndictment<Score>(fact, (Score)zeroScore));
                    indictment.addConstraintMatch(constraintMatch);
                });
            }
        }
        return indictmentMap;
    }

    @Override
    public boolean requiresFlushing() {
        return true;
    }

    @Override
    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
        super.beforeEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityAdded(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableDescriptor.getVariableName());
        super.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.beforeListVariableElementAssigned(variableDescriptor.getVariableName(), element);
        super.beforeListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.afterListVariableElementAssigned(variableDescriptor.getVariableName(), element);
        super.afterListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.beforeListVariableElementUnassigned(variableDescriptor.getVariableName(), element);
        super.beforeListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.incrementalScoreCalculator.afterListVariableElementUnassigned(variableDescriptor.getVariableName(), element);
        super.afterListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.incrementalScoreCalculator.beforeListVariableChanged(entity, variableDescriptor.getVariableName(), fromIndex, toIndex);
        super.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.incrementalScoreCalculator.afterListVariableChanged(entity, variableDescriptor.getVariableName(), fromIndex, toIndex);
        super.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
        super.beforeEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
        super.beforeProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
        super.beforeProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
        super.beforeProblemFactRemoved(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
        super.afterProblemFactRemoved(problemFact);
    }

    @NullMarked
    public static final class Builder<Solution_, Score_ extends Score<Score_>>
    extends AbstractScoreDirector.AbstractScoreDirectorBuilder<Solution_, Score_, IncrementalScoreDirectorFactory<Solution_, Score_>, Builder<Solution_, Score_>> {
        private @Nullable IncrementalScoreCalculator<Solution_, Score_> incrementalScoreCalculator;

        public Builder(IncrementalScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
            super(scoreDirectorFactory);
        }

        public Builder<Solution_, Score_> withIncrementalScoreCalculator(IncrementalScoreCalculator<Solution_, Score_> incrementalScoreCalculator) {
            this.incrementalScoreCalculator = incrementalScoreCalculator;
            return this.withConstraintMatchPolicy(this.constraintMatchPolicy);
        }

        @Override
        public Builder<Solution_, Score_> withConstraintMatchPolicy(ConstraintMatchPolicy constraintMatchPolicy) {
            return (Builder)super.withConstraintMatchPolicy(Builder.determineCorrectPolicy(constraintMatchPolicy, this.incrementalScoreCalculator));
        }

        public IncrementalScoreDirector<Solution_, Score_> build() {
            return new IncrementalScoreDirector(this);
        }

        private static ConstraintMatchPolicy determineCorrectPolicy(ConstraintMatchPolicy constraintMatchPolicy, IncrementalScoreCalculator<?, ?> incrementalScoreCalculator) {
            if (incrementalScoreCalculator instanceof ConstraintMatchAwareIncrementalScoreCalculator) {
                return constraintMatchPolicy;
            }
            return ConstraintMatchPolicy.DISABLED;
        }
    }
}

