/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.ProblemScaleTracker;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.director.SolutionInitializationStatistics;
import ai.timefold.solver.core.impl.score.director.ValueRangeManager;
import ai.timefold.solver.core.impl.util.MathUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.impl.util.MutableLong;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ValueRangeStatistics<Solution_> {
    private final ValueRangeManager<Solution_> valueRangeManager;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Solution_ solution;
    private @Nullable SolutionInitializationStatistics cachedInitializationStatistics = null;
    private @Nullable ProblemSizeStatistics cachedProblemSizeStatistics = null;

    ValueRangeStatistics(ValueRangeManager<Solution_> valueRangeManager, SolutionDescriptor<Solution_> solutionDescriptor, Solution_ solution) {
        this.valueRangeManager = valueRangeManager;
        this.solutionDescriptor = solutionDescriptor;
        this.solution = Objects.requireNonNull(solution, "Impossible state: initialization statistics requested before the working solution is known.");
    }

    Solution_ getSolution() {
        return this.solution;
    }

    SolutionInitializationStatistics computeInitializationStatistics(@Nullable Consumer<Object> finisher, boolean useCache) {
        if (useCache && this.cachedInitializationStatistics != null) {
            return this.cachedInitializationStatistics;
        }
        MutableInt uninitializedEntityCount = new MutableInt();
        MutableInt uninitializedVariableCount = new MutableInt();
        MutableInt unassignedValueCount = new MutableInt();
        MutableInt notInAnyListValueCount = new MutableInt();
        MutableInt genuineEntityCount = new MutableInt();
        MutableInt shadowEntityCount = new MutableInt();
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor != null) {
            int countOnSolution = (int)this.valueRangeManager.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), this.solution);
            notInAnyListValueCount.add(countOnSolution);
            if (!listVariableDescriptor.allowsUnassignedValues()) {
                unassignedValueCount.add(countOnSolution);
            }
        }
        this.solutionDescriptor.visitAllEntities(this.solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineEntityCount.increment();
                int uninitializedVariableCountForEntity = entityDescriptor.countUninitializedVariables(entity);
                if (uninitializedVariableCountForEntity > 0) {
                    uninitializedEntityCount.increment();
                    uninitializedVariableCount.add(uninitializedVariableCountForEntity);
                }
            } else {
                shadowEntityCount.increment();
            }
            if (finisher != null) {
                finisher.accept(entity);
            }
            if (!entityDescriptor.hasAnyGenuineListVariables()) {
                return;
            }
            EntityDescriptor listVariableEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
            int countOnEntity = listVariableDescriptor.getListSize(entity);
            notInAnyListValueCount.subtract(countOnEntity);
            if (!listVariableDescriptor.allowsUnassignedValues() && listVariableEntityDescriptor.matchesEntity(entity)) {
                unassignedValueCount.subtract(countOnEntity);
            }
        });
        SolutionInitializationStatistics statistics = new SolutionInitializationStatistics(genuineEntityCount.intValue(), shadowEntityCount.intValue(), uninitializedEntityCount.intValue(), uninitializedVariableCount.intValue(), unassignedValueCount.intValue(), notInAnyListValueCount.intValue());
        if (this.cachedInitializationStatistics == null) {
            this.cachedInitializationStatistics = statistics;
        }
        return statistics;
    }

    public ProblemSizeStatistics getProblemSizeStatistics() {
        if (this.cachedProblemSizeStatistics == null) {
            this.cachedProblemSizeStatistics = new ProblemSizeStatistics(this.solutionDescriptor.getGenuineEntityCount(this.solution), this.solutionDescriptor.getGenuineVariableCount(this.solution), this.getApproximateValueCount(), this.getProblemScale());
        }
        return this.cachedProblemSizeStatistics;
    }

    long getApproximateValueCount() {
        Set<GenuineVariableDescriptor> genuineVariableDescriptorSet = Collections.newSetFromMap(new IdentityHashMap());
        this.solutionDescriptor.visitAllEntities(this.solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineVariableDescriptorSet.addAll(entityDescriptor.getGenuineVariableDescriptorList());
            }
        });
        MutableLong out = new MutableLong();
        for (GenuineVariableDescriptor variableDescriptor : genuineVariableDescriptorSet) {
            ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            if (valueRangeDescriptor.canExtractValueRangeFromSolution()) {
                out.add(this.valueRangeManager.countOnSolution(valueRangeDescriptor, this.solution));
                continue;
            }
            this.solutionDescriptor.visitEntitiesByEntityClass(this.solution, variableDescriptor.getEntityDescriptor().getEntityClass(), entity -> {
                out.add(this.valueRangeManager.countOnEntity(valueRangeDescriptor, entity));
                return false;
            });
        }
        return out.longValue();
    }

    double getProblemScale() {
        double scale;
        long logBase = Math.max(2L, this.getMaximumValueRangeSize());
        ProblemScaleTracker problemScaleTracker = new ProblemScaleTracker(logBase);
        this.solutionDescriptor.visitAllEntities(this.solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                this.processProblemScale(this.valueRangeManager, entityDescriptor, entity, problemScaleTracker);
            }
        });
        long result = problemScaleTracker.getBasicProblemScaleLog();
        if ((long)problemScaleTracker.getListTotalEntityCount() != 0L) {
            int totalListValueCount = problemScaleTracker.getListTotalValueCount();
            int totalListMovableValueCount = totalListValueCount - problemScaleTracker.getListPinnedValueCount();
            int possibleTargetsForListValue = problemScaleTracker.getListMovableEntityCount();
            ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
            if (listVariableDescriptor != null && listVariableDescriptor.allowsUnassignedValues()) {
                ++possibleTargetsForListValue;
            }
            result += MathUtils.getPossibleArrangementsScaledApproximateLog(1000000L, logBase, totalListMovableValueCount, possibleTargetsForListValue);
        }
        if (Double.isNaN(scale = (double)result / 1000000.0 / MathUtils.getLogInBase(logBase, 10.0)) || Double.isInfinite(scale)) {
            return 0.0;
        }
        return scale;
    }

    long getMaximumValueRangeSize() {
        return this.solutionDescriptor.extractAllEntitiesStream(this.solution).mapToLong(entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            return entityDescriptor.isGenuine() ? this.getMaximumValueCount(entityDescriptor, entity) : 0L;
        }).max().orElse(0L);
    }

    private long getMaximumValueCount(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        long maximumValueCount = 0L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            if (variableDescriptor.canExtractValueRangeFromSolution()) {
                maximumValueCount = Math.max(maximumValueCount, this.valueRangeManager.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.solution));
                continue;
            }
            maximumValueCount = Math.max(maximumValueCount, this.valueRangeManager.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity));
        }
        return maximumValueCount;
    }

    private void processProblemScale(ValueRangeManager<Solution_> valueRangeManager, EntityDescriptor<Solution_> entityDescriptor, Object entity, ProblemScaleTracker tracker) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            long valueCount;
            long l = valueCount = variableDescriptor.canExtractValueRangeFromSolution() ? valueRangeManager.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.solution) : valueRangeManager.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity);
            if (variableDescriptor instanceof BasicVariableDescriptor) {
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor;
                if (basicVariableDescriptor.isChained()) {
                    tracker.addListValueCount(1);
                    if (!entityDescriptor.isMovable(this.solution, entity)) {
                        tracker.addPinnedListValueCount(1);
                    }
                    CountableValueRange valueRange = variableDescriptor.canExtractValueRangeFromSolution() ? valueRangeManager.getFromSolution(variableDescriptor.getValueRangeDescriptor(), this.solution) : valueRangeManager.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity);
                    Iterator valueIterator = valueRange.createOriginalIterator();
                    while (valueIterator.hasNext()) {
                        Object value = valueIterator.next();
                        if (!variableDescriptor.isValuePotentialAnchor(value) || tracker.isAnchorVisited(value)) continue;
                        tracker.incrementListEntityCount(true);
                    }
                    continue;
                }
                if (!entityDescriptor.isMovable(this.solution, entity)) continue;
                tracker.addBasicProblemScale(valueCount);
                continue;
            }
            if (variableDescriptor instanceof ListVariableDescriptor) {
                ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
                long size = valueRangeManager.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), this.solution);
                tracker.setListTotalValueCount((int)size);
                if (entityDescriptor.isMovable(this.solution, entity)) {
                    tracker.incrementListEntityCount(true);
                    tracker.addPinnedListValueCount(listVariableDescriptor.getFirstUnpinnedIndex(entity));
                    continue;
                }
                tracker.incrementListEntityCount(false);
                tracker.addPinnedListValueCount(listVariableDescriptor.getListSize(entity));
                continue;
            }
            throw new IllegalStateException("Unhandled subclass of %s encountered (%s).".formatted(VariableDescriptor.class.getSimpleName(), variableDescriptor.getClass().getSimpleName()));
        }
    }
}

