/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.sort.SelectionSorterAdapter;
import ai.timefold.solver.core.impl.domain.valuerange.sort.SortableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.sort.ValueRangeSorter;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ValueRangeState<Solution_, Entity_, Value_> {
    private final ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private final Solution_ cachedWorkingSolution;
    private @Nullable ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> fromSolutionItem;
    private @Nullable Map<Value_, Integer> fromSolutionValueIndexMap;
    private @Nullable Map<Entity_, ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_>> fromEntityMap;
    private @Nullable Map<HashedValueRange<Value_>, Entity_> valueRangeDeduplicationCache;
    private @Nullable ValueRangeItem<Solution_, Entity_, ReachableValues<Entity_, Value_>, Value_> reachableValuesItem;

    ValueRangeState(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ cachedWorkingSolution) {
        this.valueRangeDescriptor = Objects.requireNonNull(valueRangeDescriptor);
        this.cachedWorkingSolution = Objects.requireNonNull(cachedWorkingSolution);
    }

    public CountableValueRange<Value_> getFromSolution(Solution_ solution, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        if (this.fromSolutionItem == null) {
            CountableValueRange<Value_> valueRange = this.fetchValueRangeFromSolution(solution, sorter);
            this.fromSolutionItem = ValueRangeItem.ofLeft(null, valueRange, sorter);
            this.fromSolutionValueIndexMap = ValueRangeState.buildIndexMap(valueRange.createOriginalIterator(), (int)valueRange.getSize(), this.valueRangeDescriptor.isGenericTypeImmutable());
            return valueRange;
        }
        CountableValueRange<Value_> valueRange = this.pickValueBySorter(this.fromSolutionItem, sorter, null);
        if (valueRange != null) {
            return valueRange;
        }
        if (this.fromSolutionItem.leftSorter() == null && sorter != null) {
            CountableValueRange<Value_> sortedValueRange = this.sortValueRange(Objects.requireNonNull(this.fromSolutionItem.leftItem()), sorter);
            this.fromSolutionItem = ValueRangeItem.of(null, sortedValueRange, sorter, this.fromSolutionItem.rightItem(), this.fromSolutionItem.rightSorter());
            this.fromSolutionValueIndexMap = ValueRangeState.buildIndexMap(sortedValueRange.createOriginalIterator(), (int)sortedValueRange.getSize(), this.valueRangeDescriptor.isGenericTypeImmutable());
            return sortedValueRange;
        }
        if (this.fromSolutionItem.rightItem() == null) {
            CountableValueRange<Value_> sortedValueRange = this.sortValueRange(Objects.requireNonNull(this.fromSolutionItem.leftItem()), sorter);
            this.fromSolutionItem = ValueRangeItem.of(null, this.fromSolutionItem.leftItem(), this.fromSolutionItem.leftSorter(), sortedValueRange, sorter);
            return sortedValueRange;
        }
        throw new IllegalStateException("Impossible state: the value range (%s) with sorter (%s) does not align with the existing ascending (%s) and descending (%s) sorters.".formatted(this.valueRangeDescriptor, sorter, this.fromSolutionItem.leftItem(), this.fromSolutionItem.rightItem()));
    }

    private <Type_> @Nullable Type_ pickValueBySorter(ValueRangeItem<Solution_, Entity_, Type_, Value_> item, @Nullable SelectionSorter<Solution_, Value_> sorter, @Nullable BiFunction<Entity_, @Nullable SelectionSorter<Solution_, Value_>, Type_> placeholderFunction) {
        if (item.leftItem() == null && item.rightItem() == null && placeholderFunction != null) {
            Entity_ placeholder = item.entity();
            if (placeholder == null) {
                throw new IllegalStateException("Impossible state: the placeholder is null and no value ranges are found.");
            }
            return placeholderFunction.apply(placeholder, sorter);
        }
        if (item.leftItem() != null && (sorter == null || Objects.equals(item.leftSorter(), sorter))) {
            return item.leftItem();
        }
        if (item.rightItem() != null && Objects.equals(item.rightSorter(), sorter)) {
            return item.rightItem();
        }
        return null;
    }

    private Map<Value_, Integer> getIndexMapFromSolution() {
        if (this.fromSolutionValueIndexMap == null) {
            this.getFromSolution(this.cachedWorkingSolution, null);
        }
        return this.fromSolutionValueIndexMap;
    }

    private CountableValueRange<Value_> fetchValueRangeFromSolution(Solution_ solution, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        CountableValueRange<Value_> valueRange = this.extractValueRange(this.valueRangeDescriptor, solution);
        return this.sortValueRange(valueRange, sorter);
    }

    private CountableValueRange<Value_> extractValueRange(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        ValueRange extractedValueRange = valueRangeDescriptor.extractAllValues(Objects.requireNonNull(solution));
        if (!(extractedValueRange instanceof CountableValueRange)) {
            throw new UnsupportedOperationException("Impossible state: value range (%s) on planning solution (%s) is not countable.\nMaybe replace %s with %s.".formatted(valueRangeDescriptor, solution, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
        }
        CountableValueRange countableValueRange = (CountableValueRange)extractedValueRange;
        if (valueRangeDescriptor.acceptsNullInValueRange()) {
            return new NullAllowingCountableValueRange(countableValueRange);
        }
        return countableValueRange;
    }

    private CountableValueRange<Value_> sortValueRange(CountableValueRange<Value_> originalValueRange, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        if (sorter == null) {
            return originalValueRange;
        }
        if (!(originalValueRange instanceof SortableValueRange)) {
            throw new IllegalStateException("Impossible state: value range (%s) on planning solution (%s) is not sortable.".formatted(this.valueRangeDescriptor, this.cachedWorkingSolution));
        }
        SortableValueRange sortableValueRange = (SortableValueRange)((Object)originalValueRange);
        return (CountableValueRange)sortableValueRange.sort(SelectionSorterAdapter.of(this.cachedWorkingSolution, sorter));
    }

    public CountableValueRange<Value_> getFromEntity(Entity_ entity, int entityCount, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        Map<Entity_, ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_>> entityMap = this.ensureEntityMapIsInitialized(entityCount);
        ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> item = entityMap.get(entity);
        if (item == null) {
            ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> newItem = this.buildEntityValueRangeItem(entity, sorter);
            entityMap.put(entity, newItem);
            if (newItem.entity() != null && newItem.leftItem() == null && newItem.rightItem() == null) {
                return this.getFromEntity(Objects.requireNonNull(newItem.entity()), entityCount, sorter);
            }
            return Objects.requireNonNull(newItem.leftItem());
        }
        CountableValueRange valueRange = this.pickValueBySorter(item, sorter, (p, s) -> this.getFromEntity((Entity_)p, entityCount, (SelectionSorter<Solution_, Value_>)s));
        if (valueRange != null) {
            return valueRange;
        }
        if (item.leftSorter() == null && sorter != null) {
            ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> newItem = ValueRangeItem.of(entity, this.sortValueRange(Objects.requireNonNull(item.leftItem()), sorter), sorter, item.rightItem(), item.rightSorter());
            entityMap.put(entity, newItem);
            return Objects.requireNonNull(newItem.leftItem());
        }
        if (item.rightItem() == null) {
            ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> newItem = ValueRangeItem.of(entity, item.leftItem(), item.leftSorter(), this.sortValueRange(Objects.requireNonNull(item.leftItem()), sorter), sorter);
            entityMap.put(entity, newItem);
            return Objects.requireNonNull(newItem.rightItem());
        }
        throw new IllegalStateException("Impossible state: the value range (%s) with sorter (%s) does not align with the existing ascending (%s) and descending (%s) sorters.".formatted(this.valueRangeDescriptor, sorter, item.leftSorter(), item.rightSorter()));
    }

    private Map<Entity_, ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_>> ensureEntityMapIsInitialized(int entityCount) {
        if (this.fromEntityMap == null) {
            this.fromEntityMap = CollectionUtils.newIdentityHashMap(entityCount);
            this.valueRangeDeduplicationCache = CollectionUtils.newHashMap(entityCount);
        }
        return this.fromEntityMap;
    }

    private ValueRangeItem<Solution_, Entity_, CountableValueRange<Value_>, Value_> buildEntityValueRangeItem(Entity_ entity, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        CountableValueRange<Value_> valueRange = this.fetchValueRangeFromEntity(entity, sorter);
        Entity_ entityMatch = this.findEntityMatch(entity, valueRange);
        if (entityMatch != null) {
            return ValueRangeItem.ofEntity(entityMatch);
        }
        return ValueRangeItem.ofLeft(entity, valueRange, sorter);
    }

    private @Nullable Entity_ findEntityMatch(Entity_ entity, CountableValueRange<Value_> valueRange) {
        HashedValueRange<Value_> hashedValueRange = HashedValueRange.of(valueRange);
        Entity_ fromEntity = this.valueRangeDeduplicationCache.get(hashedValueRange);
        if (fromEntity == null) {
            this.valueRangeDeduplicationCache.put(hashedValueRange, entity);
            return null;
        }
        return fromEntity;
    }

    private CountableValueRange<Value_> fetchValueRangeFromEntity(Entity_ entity, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        ValueRange extractedValueRange = this.valueRangeDescriptor.extractValuesFromEntity(this.cachedWorkingSolution, Objects.requireNonNull(entity));
        if (!(extractedValueRange instanceof CountableValueRange)) {
            throw new UnsupportedOperationException("Impossible state: value range (%s) on planning entity (%s) is not countable.\nMaybe replace %s with %s.".formatted(this.valueRangeDescriptor, entity, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
        }
        NullAllowingCountableValueRange countableValueRange = (NullAllowingCountableValueRange)extractedValueRange;
        NullAllowingCountableValueRange valueRange = this.valueRangeDescriptor.acceptsNullInValueRange() ? new NullAllowingCountableValueRange(countableValueRange) : countableValueRange;
        return this.sortValueRange(valueRange, sorter);
    }

    public ReachableValues<Entity_, Value_> getReachableValues(GenuineVariableDescriptor<Solution_> variableDescriptor, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        if (this.reachableValuesItem == null) {
            ReachableValues<Entity_, Value_> values = this.fetchReachableValues(variableDescriptor, sorter);
            this.reachableValuesItem = ValueRangeItem.ofLeft(null, values, sorter);
            return values;
        }
        ReachableValues<Entity_, Value_> value = this.pickValueBySorter(this.reachableValuesItem, sorter, null);
        if (value != null) {
            return value;
        }
        if (this.reachableValuesItem.leftSorter() == null && sorter != null) {
            ReachableValues<Entity_, Value_> sortedValues = this.buildSortedReachableValues(Objects.requireNonNull(this.reachableValuesItem.leftItem()), sorter, true);
            this.reachableValuesItem = ValueRangeItem.of(null, sortedValues, sorter, this.reachableValuesItem.rightItem(), this.reachableValuesItem.rightSorter());
            return sortedValues;
        }
        if (this.reachableValuesItem.rightItem() == null && sorter != null) {
            ReachableValues<Entity_, Value_> sortedValues = this.buildSortedReachableValues(Objects.requireNonNull(this.reachableValuesItem.leftItem()), sorter, false);
            this.reachableValuesItem = ValueRangeItem.of(null, Objects.requireNonNull(this.reachableValuesItem.leftItem()), this.reachableValuesItem.leftSorter(), sortedValues, sorter);
            return sortedValues;
        }
        throw new IllegalStateException("Impossible state: the reachable values structure for variable (%s) with sorter (%s) does not align with the existing ascending (%s) and descending (%s) sorters.".formatted(variableDescriptor, sorter, this.reachableValuesItem.leftSorter(), this.reachableValuesItem.rightSorter()));
    }

    private ReachableValues<Entity_, Value_> buildSortedReachableValues(ReachableValues<Entity_, Value_> values, SelectionSorter<Solution_, Value_> sorter, boolean clear) {
        ReachableValues<Entity_, Value_> sortedValues = values.copy(SelectionSorterAdapter.of(this.cachedWorkingSolution, sorter));
        if (clear) {
            values.clear();
        }
        return sortedValues;
    }

    private ReachableValues<Entity_, Value_> fetchReachableValues(GenuineVariableDescriptor<Solution_> variableDescriptor, @Nullable SelectionSorter<Solution_, Value_> sorter) {
        EntityDescriptor<Solution_> entityDescriptor = variableDescriptor.getEntityDescriptor();
        List<Object> entityList = entityDescriptor.extractEntities(this.cachedWorkingSolution);
        Map<Object, Integer> entityIndexMap = ValueRangeState.buildIndexMap(entityList.iterator(), entityList.size(), false);
        ReachableValues.ReachableValuesIndex<Object, Object> entityIndexItem = new ReachableValues.ReachableValuesIndex<Object, Object>(entityIndexMap, entityList);
        CountableValueRange<Value_> valueList = this.getFromSolution(this.cachedWorkingSolution, null);
        Map<Value_, Integer> valueIndexMap = ValueRangeState.buildIndexMap(valueList.createOriginalIterator(), (int)valueList.getSize(), this.valueRangeDescriptor.isGenericTypeImmutable());
        long valueListSize = valueList.getSize();
        if (valueListSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The structure %s cannot be built for the entity %s (%s) because value range has a size (%d) which is higher than Integer.MAX_VALUE.".formatted(ReachableValues.class.getSimpleName(), entityDescriptor.getEntityClass().getSimpleName(), variableDescriptor.getVariableName(), valueListSize));
        }
        Class<?> expectedTypeOfValue = this.valueRangeDescriptor.getVariableDescriptor().getVariableMetaModel().type();
        List<ReachableValues.ReachableItemValue<Entity_, Value_>> reachableValueList = this.initReachableValueList(valueList, entityList.size());
        ReachableValues.ReachableValuesIndex<Value_, ReachableValues.ReachableItemValue<Entity_, Value_>> valueIndexItem = new ReachableValues.ReachableValuesIndex<Value_, ReachableValues.ReachableItemValue<Entity_, Value_>>(valueIndexMap, reachableValueList);
        for (int i = 0; i < entityList.size(); ++i) {
            Object entity = entityList.get(i);
            CountableValueRange<Value_> valueRange = this.getFromEntity(entity, entityList.size(), null);
            ValueRangeState.loadEntityValueRange(i, valueIndexMap, valueRange, reachableValueList);
        }
        ValueRangeSorter<Value_> sorterAdapter = sorter != null ? SelectionSorterAdapter.of(this.cachedWorkingSolution, sorter) : null;
        return new ReachableValues<Object, Value_>(entityIndexItem, valueIndexItem, expectedTypeOfValue, sorterAdapter, variableDescriptor.getValueRangeDescriptor().acceptsNullInValueRange());
    }

    private static <Type_> Map<Type_, Integer> buildIndexMap(Iterator<@Nullable Type_> allValues, int size, boolean isImmutable) {
        Map<Type_, Integer> indexMap = isImmutable ? CollectionUtils.newHashMap(size) : CollectionUtils.newIdentityHashMap(size);
        int idx = 0;
        while (allValues.hasNext()) {
            Type_ value = allValues.next();
            if (value == null) continue;
            indexMap.put(value, idx++);
        }
        return indexMap;
    }

    private List<ReachableValues.ReachableItemValue<Entity_, Value_>> initReachableValueList(CountableValueRange<Value_> valueRange, int entityListSize) {
        int valuesSize = (int)valueRange.getSize();
        Iterator<@Nullable Value_> iterator = valueRange.createOriginalIterator();
        Spliterator<Value_> spliterator = Spliterators.spliterator(iterator, (long)valuesSize, 1040);
        MutableInt idx = new MutableInt(-1);
        return StreamSupport.stream(spliterator, false).filter(Objects::nonNull).map(v -> new ReachableValues.ReachableItemValue(idx.increment(), v, entityListSize, valuesSize)).toList();
    }

    private static <Entity_, Value_> void loadEntityValueRange(int entityIndex, Map<Value_, Integer> valueIndexMap, CountableValueRange<Value_> valueRange, List<ReachableValues.ReachableItemValue<Entity_, Value_>> reachableValueList) {
        BitSet allValuesBitSet = ValueRangeState.buildBitSetForValueRange(valueRange, valueIndexMap);
        int valueIndex = allValuesBitSet.nextSetBit(0);
        while (valueIndex >= 0) {
            ReachableValues.ReachableItemValue<Entity_, Value_> item = reachableValueList.get(valueIndex);
            item.addEntity(entityIndex);
            item.addValuesExcept(allValuesBitSet, valueIndex);
            valueIndex = allValuesBitSet.nextSetBit(valueIndex + 1);
        }
    }

    private static <Value_> BitSet buildBitSetForValueRange(CountableValueRange<Value_> valueRange, Map<Value_, Integer> valueIndexMap) {
        BitSet valueBitSet = new BitSet((int)valueRange.getSize());
        Iterator<@Nullable Value_> iterator = valueRange.createOriginalIterator();
        while (iterator.hasNext()) {
            Value_ value = iterator.next();
            if (value == null) continue;
            valueBitSet.set(valueIndexMap.get(value));
        }
        return valueBitSet;
    }

    private record ValueRangeItem<Solution_, Entity_, Type_, Value_>(@Nullable Entity_ entity, @Nullable Type_ leftItem, @Nullable SelectionSorter<Solution_, Value_> leftSorter, @Nullable Type_ rightItem, @Nullable SelectionSorter<Solution_, Value_> rightSorter) {
        public static <Solution_, Entity_, Type_, Value_> ValueRangeItem<Solution_, Entity_, Type_, Value_> ofEntity(Entity_ entity) {
            return new ValueRangeItem<Solution_, Entity_, Object, Value_>(entity, null, null, null, null);
        }

        public static <Solution_, Entity_, Type_, Value_> ValueRangeItem<Solution_, Entity_, Type_, Value_> ofLeft(@Nullable Entity_ entity, Type_ leftItem, @Nullable SelectionSorter<Solution_, Value_> leftSorter) {
            return new ValueRangeItem<Solution_, Entity_, Object, Value_>(entity, leftItem, leftSorter, null, null);
        }

        public static <Solution_, Entity_, Type_, Value_> ValueRangeItem<Solution_, Entity_, Type_, Value_> of(@Nullable Entity_ entity, @Nullable Type_ leftItem, @Nullable SelectionSorter<Solution_, Value_> leftSorter, @Nullable Type_ rightItem, @Nullable SelectionSorter<Solution_, Value_> rightSorter) {
            return new ValueRangeItem<Solution_, Entity_, Type_, Value_>(entity, leftItem, leftSorter, rightItem, rightSorter);
        }
    }

    private record HashedValueRange<T>(CountableValueRange<T> item, int hash) {
        public static <Value_> HashedValueRange<Value_> of(CountableValueRange<Value_> valueRange) {
            return new HashedValueRange<Value_>(valueRange, valueRange.hashCode());
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof HashedValueRange)) {
                return false;
            }
            HashedValueRange that = (HashedValueRange)o;
            return this.hash == that.hash && Objects.equals(this.item, that.item);
        }
    }
}

