/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.joiner;

import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingJoiner;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.joiner.DefaultBiEnumeratingJoiner;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.joiner.FilteringBiEnumeratingJoiner;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record BiEnumeratingJoinerComber<Solution_, A, B>(DefaultBiEnumeratingJoiner<A, B> mergedJoiner, @Nullable BiEnumeratingPredicate<Solution_, A, B> mergedFiltering) {
    public static <Solution_, A, B> BiEnumeratingJoinerComber<Solution_, A, B> comb(BiEnumeratingJoiner<A, B>[] joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList<BiEnumeratingPredicate<Solution_, A, B>> filteringList = new ArrayList<BiEnumeratingPredicate<Solution_, A, B>>(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            BiEnumeratingJoiner<A, B> joiner = joiners[i];
            if (joiner instanceof FilteringBiEnumeratingJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringBiEnumeratingJoiner)joiner).filter());
                continue;
            }
            if (joiner instanceof DefaultBiEnumeratingJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (%s) must not follow a filtering joiner (%s).\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.".formatted(joiner, joiners[indexOfFirstFilter]));
                }
                defaultJoinerList.add((DefaultBiEnumeratingJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (%s) is not supported.".formatted(joiner.getClass().getSimpleName()));
        }
        DefaultBiEnumeratingJoiner mergedJoiner = DefaultBiEnumeratingJoiner.merge(defaultJoinerList);
        BiEnumeratingPredicate<Solution_, A, B> mergedFiltering = BiEnumeratingJoinerComber.mergeFiltering(filteringList);
        return new BiEnumeratingJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <Solution_, A, B> @Nullable BiEnumeratingPredicate<Solution_, A, B> mergeFiltering(List<BiEnumeratingPredicate<Solution_, A, B>> filteringList) {
        if (filteringList.isEmpty()) {
            return null;
        }
        return switch (filteringList.size()) {
            case 1 -> filteringList.get(0);
            case 2 -> filteringList.get(0).and((TriPredicate)filteringList.get(1));
            default -> (solutionView, a, b) -> {
                for (BiEnumeratingPredicate predicate : filteringList) {
                    if (predicate.test(solutionView, a, b)) continue;
                    return false;
                }
                return true;
            };
        };
    }
}

