/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common;

import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DefaultUniqueRandomSequence;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.UniqueRandomSequence;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class FilteredUniqueRandomSequence<T>
implements UniqueRandomSequence<T> {
    private final List<ListEntry<T>> originalList;
    private final Predicate<T> filter;
    private final DefaultUniqueRandomSequence<T> delegate;

    FilteredUniqueRandomSequence(List<? extends ListEntry<T>> listOfUniqueItems, Predicate<T> filter) {
        this.originalList = Collections.unmodifiableList(listOfUniqueItems);
        this.filter = Objects.requireNonNull(filter);
        this.delegate = new DefaultUniqueRandomSequence(listOfUniqueItems);
    }

    @Override
    public UniqueRandomSequence.SequenceElement<T> pick(Random workingRandom) {
        int index = this.pickIndex(workingRandom);
        return new UniqueRandomSequence.SequenceElement<T>(this.originalList.get(index).getElement(), index);
    }

    private int pickIndex(Random workingRandom) {
        int originalRandomIndex;
        if (this.delegate.isEmpty()) {
            throw new NoSuchElementException("No more elements to pick from.");
        }
        UniqueRandomSequence.SequenceElement<T> nonRemovedElement = this.delegate.pick(workingRandom);
        int actualValueIndex = originalRandomIndex = nonRemovedElement.index();
        T value = nonRemovedElement.value();
        while (!this.filter.test(value)) {
            if (this.delegate.isEmpty()) {
                throw new NoSuchElementException("No more elements to pick from.");
            }
            this.delegate.remove(actualValueIndex);
            actualValueIndex = this.delegate.pickIndex(workingRandom, originalRandomIndex);
            value = this.originalList.get(actualValueIndex).getElement();
        }
        return actualValueIndex;
    }

    @Override
    public T remove(Random workingRandom) {
        return this.delegate.remove(this.pickIndex(workingRandom));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

