/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common;

import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.IndexerFactory;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDataset;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.AbstractLeftDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DefaultUniqueRandomSequence;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.FilteredUniqueRandomSequence;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractRightDatasetInstance<Solution_, Right_>
extends AbstractDatasetInstance<Solution_, UniTuple<Right_>> {
    private final IndexerFactory.KeysExtractor<UniTuple<Right_>> compositeKeyExtractor;
    private final int compositeKeyStoreIndex;
    private final Indexer<UniTuple<Right_>> indexer;

    protected AbstractRightDatasetInstance(AbstractDataset<Solution_> parent, IndexerFactory.KeysExtractor<UniTuple<Right_>> compositeKeyExtractor, int compositeKeyStoreIndex, int rightMostPositionStoreIndex, Indexer<UniTuple<Right_>> indexer) {
        super(parent, rightMostPositionStoreIndex);
        this.compositeKeyExtractor = compositeKeyExtractor;
        this.compositeKeyStoreIndex = compositeKeyStoreIndex;
        this.indexer = indexer;
    }

    @Override
    public void insert(UniTuple<Right_> tuple) {
        Object compositeKey = this.compositeKeyExtractor.apply(tuple);
        tuple.setStore(this.entryStoreIndex, this.indexer.put(compositeKey, tuple));
        tuple.setStore(this.compositeKeyStoreIndex, compositeKey);
    }

    @Override
    public void update(UniTuple<Right_> tuple) {
        Object newCompositeKey;
        Object oldCompositeKey = tuple.getStore(this.compositeKeyStoreIndex);
        if (!Objects.equals(oldCompositeKey, newCompositeKey = this.compositeKeyExtractor.apply(tuple))) {
            this.indexer.remove(oldCompositeKey, (ListEntry)tuple.getStore(this.entryStoreIndex));
            tuple.setStore(this.entryStoreIndex, this.indexer.put(newCompositeKey, tuple));
            tuple.setStore(this.compositeKeyStoreIndex, newCompositeKey);
        }
    }

    @Override
    public void retract(UniTuple<Right_> tuple) {
        this.indexer.remove(tuple.removeStore(this.compositeKeyStoreIndex), (ListEntry)tuple.removeStore(this.entryStoreIndex));
    }

    public Iterator<UniTuple<Right_>> iterator(Object compositeKey) {
        List<ListEntry<UniTuple<Right_>>> list = this.indexer.asList(compositeKey);
        return new AbstractLeftDatasetInstance.UnwrappingIterator<UniTuple<Right_>>(list.iterator());
    }

    public DefaultUniqueRandomSequence<UniTuple<Right_>> buildRandomSequence(Object compositeKey) {
        return new DefaultUniqueRandomSequence<UniTuple<Right_>>(this.indexer.asList(compositeKey));
    }

    public FilteredUniqueRandomSequence<UniTuple<Right_>> buildRandomSequence(Object compositeKey, Predicate<UniTuple<Right_>> predicate) {
        return new FilteredUniqueRandomSequence<UniTuple<Right_>>(this.indexer.asList(compositeKey), predicate);
    }

    public int size(Object compositeKey) {
        return this.indexer.size(compositeKey);
    }
}

