/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.stream;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.EnumeratingJoiners;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.UniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingMapper;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.UniEnumeratingFilter;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.sampling.UniSamplingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.DatasetSession;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.DatasetSessionFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.EnumeratingStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.AbstractUniEnumeratingStream;
import ai.timefold.solver.core.impl.neighborhood.stream.sampling.DefaultUniSamplingStream;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultMoveStreamFactory<Solution_>
implements MoveStreamFactory<Solution_> {
    private final EnumeratingStreamFactory<Solution_> enumeratingStreamFactory;
    private final DatasetSessionFactory<Solution_> datasetSessionFactory;
    private final Map<GenuineVariableMetaModel<Solution_, ?, ?>, NodeSharingSupportFunctions<Solution_, ?, ?>> nodeSharingSupportFunctionMap = new HashMap();
    private final Map<PlanningListVariableMetaModel<Solution_, ?, ?>, ListVariableNodeSharingSupportFunctions<Solution_, ?, ?>> listVariableNodeSharingSupportFunctionsMap = new HashMap();

    public DefaultMoveStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        this.enumeratingStreamFactory = new EnumeratingStreamFactory<Solution_>(solutionDescriptor, environmentMode);
        this.datasetSessionFactory = new DatasetSessionFactory<Solution_>(this.enumeratingStreamFactory);
    }

    public DefaultNeighborhoodSession<Solution_> createSession(SessionContext<Solution_> context) {
        DatasetSession<Solution_> session = this.datasetSessionFactory.buildSession(context);
        return new DefaultNeighborhoodSession<Solution_>(session, context.solutionView());
    }

    @Override
    public PlanningSolutionMetaModel<Solution_> getSolutionMetaModel() {
        return this.enumeratingStreamFactory.getSolutionDescriptor().getMetaModel();
    }

    @Override
    public <A> UniEnumeratingStream<Solution_, A> forEach(Class<A> sourceClass, boolean includeNull) {
        EntityDescriptor<Solution_> entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(sourceClass);
        if (entityDescriptor == null) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (entityDescriptor.isGenuine()) {
            return this.enumeratingStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.getSolutionDescriptor().getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.supportsPinning()) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        if (!listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
        }
        return this.enumeratingStreamFactory.forEachExcludingPinned(sourceClass, includeNull);
    }

    @Override
    public <A> UniEnumeratingStream<Solution_, A> forEachUnfiltered(Class<A> sourceClass, boolean includeNull) {
        return this.enumeratingStreamFactory.forEachNonDiscriminating(sourceClass, includeNull);
    }

    public <Entity_, Value_> NodeSharingSupportFunctions<Solution_, Entity_, Value_> getNodeSharingSupportFunctions(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return this.nodeSharingSupportFunctionMap.computeIfAbsent(variableMetaModel, ignored -> new NodeSharingSupportFunctions(variableMetaModel));
    }

    @Override
    public <Entity_, Value_> UniEnumeratingStream<Solution_, ElementPosition> forEachAssignablePosition(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        UniEnumeratingStream unpinnedEntities = this.forEach(variableMetaModel.entity().type(), variableMetaModel.allowsUnassignedValues());
        ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_> nodeSharingSupportFunctions = this.getNodeSharingSupportFunctions(variableMetaModel);
        UniEnumeratingStream unpinnedValues = this.forEach(variableMetaModel.type(), true).filter(nodeSharingSupportFunctions.unpinnedValueFilter);
        return unpinnedEntities.join(unpinnedValues, EnumeratingJoiners.filtering(nodeSharingSupportFunctions.valueInRangeFilter)).map(nodeSharingSupportFunctions.toElementPositionMapper).distinct();
    }

    public <Entity_, Value_> ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_> getNodeSharingSupportFunctions(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return this.listVariableNodeSharingSupportFunctionsMap.computeIfAbsent(variableMetaModel, ListVariableNodeSharingSupportFunctions::new);
    }

    @Override
    public <A> UniSamplingStream<Solution_, A> pick(UniEnumeratingStream<Solution_, A> enumeratingStream) {
        return new DefaultUniSamplingStream(((AbstractUniEnumeratingStream)enumeratingStream).createLeftDataset());
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.enumeratingStreamFactory.getSolutionDescriptor();
    }

    public record NodeSharingSupportFunctions<Solution_, Entity_, Value_>(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, BiEnumeratingPredicate<Solution_, Entity_, Value_> differentValueFilter, BiEnumeratingPredicate<Solution_, Entity_, Value_> valueInRangeFilter) {
        public NodeSharingSupportFunctions(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
            this(variableMetaModel, (solutionView, entity, value) -> !Objects.equals(solutionView.getValue(variableMetaModel, entity), value), (solutionView, entity, value) -> solutionView.isValueInRange(variableMetaModel, entity, value));
        }
    }

    public record ListVariableNodeSharingSupportFunctions<Solution_, Entity_, Value_>(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, UniEnumeratingFilter<Solution_, Value_> unpinnedValueFilter, BiEnumeratingPredicate<Solution_, Entity_, Value_> valueInRangeFilter, BiEnumeratingMapper<Solution_, Entity_, Value_, ElementPosition> toElementPositionMapper) {
        public ListVariableNodeSharingSupportFunctions(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
            this(variableMetaModel, (solutionView, value) -> value == null || solutionView.getPositionOf(variableMetaModel, value) instanceof PositionInList, (solutionView, entity, value) -> {
                if (entity == null || value == null) {
                    return true;
                }
                return solutionView.isValueInRange(variableMetaModel, entity, value);
            }, (solutionView, entity, value) -> {
                if (entity == null) {
                    return ElementPosition.unassigned();
                }
                int valueCount = solutionView.countValues(variableMetaModel, entity);
                if (value == null || valueCount == 0) {
                    return ElementPosition.of(entity, valueCount);
                }
                return solutionView.getPositionOf(variableMetaModel, value);
            });
        }
    }
}

