/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class FilteringIterator<Solution_, A, B>
implements Iterator<UniTuple<B>> {
    private static final UniTuple EMPTY_TUPLE = new UniTuple<Object>(null, 0);
    private final SolutionView<Solution_> solutionView;
    private final BiEnumeratingPredicate<Solution_, A, B> filter;
    private final UniTuple<A> leftTuple;
    private final Iterator<UniTuple<B>> rightTupleIterator;
    private boolean hasNext = false;
    private UniTuple<B> next = EMPTY_TUPLE;

    public FilteringIterator(BiEnumeratingPredicate<Solution_, A, B> filter, SolutionView<Solution_> solutionView, UniTuple<A> leftTuple, Iterator<UniTuple<B>> rightTupleIterator) {
        this.solutionView = Objects.requireNonNull(solutionView);
        this.rightTupleIterator = Objects.requireNonNull(rightTupleIterator);
        this.filter = filter;
        this.leftTuple = leftTuple;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        Object leftFact = this.leftTuple.factA;
        while (this.rightTupleIterator.hasNext()) {
            UniTuple<B> rightTuple = this.rightTupleIterator.next();
            Object rightFact = rightTuple.factA;
            if (!this.filter.test(this.solutionView, leftFact, rightFact)) continue;
            this.hasNext = true;
            this.next = rightTuple;
            return true;
        }
        this.hasNext = false;
        this.next = EMPTY_TUPLE;
        return false;
    }

    @Override
    public UniTuple<B> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        UniTuple<B> result = Objects.requireNonNull(this.next);
        this.hasNext = false;
        this.next = EMPTY_TUPLE;
        return result;
    }
}

