/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.impl.neighborhood.move.BiMoveStreamContext;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.DefaultUniqueRandomSequence;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.common.UniqueRandomSequence;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniLeftDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniRightDatasetInstance;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.SolutionView;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class BiRandomMoveIterator<Solution_, A, B>
implements Iterator<Move<Solution_>> {
    private final BiMoveStreamContext<Solution_, A, B> context;
    private final Random workingRandom;
    private final DefaultUniqueRandomSequence<UniTuple<A>> leftTupleSequence;
    private final Map<UniTuple<A>, UniqueRandomSequence<UniTuple<B>>> rightTupleSequenceMap;
    private @Nullable Move<Solution_> nextMove;

    public BiRandomMoveIterator(BiMoveStreamContext<Solution_, A, B> context, Random workingRandom) {
        this.context = Objects.requireNonNull(context);
        this.workingRandom = Objects.requireNonNull(workingRandom);
        UniLeftDatasetInstance<Solution_, A> leftDatasetInstance = context.getLeftDatasetInstance();
        this.leftTupleSequence = leftDatasetInstance.buildRandomSequence();
        this.rightTupleSequenceMap = this.leftTupleSequence.isEmpty() ? Collections.emptyMap() : CollectionUtils.newIdentityHashMap(leftDatasetInstance.size());
    }

    private UniqueRandomSequence<UniTuple<B>> computeRightSequence(UniTuple<A> leftTuple) {
        Object compositeKey;
        UniRightDatasetInstance<Solution_, A, B> rightDatasetInstance = this.context.getRightDatasetInstance();
        int rightTupleCount = rightDatasetInstance.size(compositeKey = rightDatasetInstance.produceCompositeKey(leftTuple));
        if (rightTupleCount == 0) {
            return DefaultUniqueRandomSequence.empty();
        }
        BiEnumeratingPredicate filter = rightDatasetInstance.getFilter();
        if (filter == null) {
            return rightDatasetInstance.buildRandomSequence(compositeKey);
        }
        Object leftFact = leftTuple.factA;
        SolutionView solutionView = this.context.neighborhoodSession().getSolutionView();
        return rightDatasetInstance.buildRandomSequence(compositeKey, rightTuple -> filter.test(solutionView, leftFact, rightTuple.factA));
    }

    @Override
    public boolean hasNext() {
        if (this.nextMove != null) {
            return true;
        }
        while (!this.leftTupleSequence.isEmpty()) {
            UniqueRandomSequence.SequenceElement<UniTuple<A>> leftElement = this.leftTupleSequence.pick(this.workingRandom);
            this.pickNextMove(leftElement);
            if (this.nextMove == null) continue;
            return true;
        }
        return false;
    }

    private void pickNextMove(UniqueRandomSequence.SequenceElement<UniTuple<A>> leftElement) {
        UniTuple<A> leftTuple = leftElement.value();
        UniqueRandomSequence rightTupleSequence = this.rightTupleSequenceMap.computeIfAbsent(leftTuple, this::computeRightSequence);
        boolean remove = false;
        if (rightTupleSequence.isEmpty()) {
            remove = true;
        } else {
            try {
                UniTuple bTuple = (UniTuple)rightTupleSequence.remove(this.workingRandom);
                Object leftFact = leftTuple.factA;
                Object rightFact = bTuple.factA;
                this.nextMove = this.context.buildMove(leftFact, rightFact);
            }
            catch (NoSuchElementException e) {
                remove = true;
            }
        }
        if (remove) {
            this.leftTupleSequence.remove(leftElement.index());
            this.rightTupleSequenceMap.remove(leftTuple);
        }
    }

    @Override
    public Move<Solution_> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Move<Solution_> result = Objects.requireNonNull(this.nextMove);
        this.nextMove = null;
        return result;
    }
}

