/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood.move;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.stream.enumerating.function.BiEnumeratingPredicate;
import ai.timefold.solver.core.impl.neighborhood.move.BiMoveStreamContext;
import ai.timefold.solver.core.impl.neighborhood.move.FilteringIterator;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniLeftDatasetInstance;
import ai.timefold.solver.core.impl.neighborhood.stream.enumerating.uni.UniRightDatasetInstance;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class BiOriginalMoveIterator<Solution_, A, B>
implements Iterator<Move<Solution_>> {
    private static final UniTuple EMPTY_TUPLE = new UniTuple<Object>(null, 0);
    private final BiMoveStreamContext<Solution_, A, B> context;
    private final UniLeftDatasetInstance<Solution_, A> leftDatasetInstance;
    private final UniRightDatasetInstance<Solution_, A, B> rightDatasetInstance;
    private @Nullable Move<Solution_> nextMove;
    private @Nullable Iterator<UniTuple<A>> leftTupleIterator;
    private @Nullable Iterator<UniTuple<B>> rightTupleIterator;
    private UniTuple<A> leftTuple = EMPTY_TUPLE;

    public BiOriginalMoveIterator(BiMoveStreamContext<Solution_, A, B> context) {
        this.context = Objects.requireNonNull(context);
        this.leftDatasetInstance = context.getLeftDatasetInstance();
        this.rightDatasetInstance = context.getRightDatasetInstance();
    }

    @Override
    public boolean hasNext() {
        if (this.nextMove != null) {
            return true;
        }
        if (this.leftTupleIterator == null) {
            this.leftTupleIterator = this.leftDatasetInstance.iterator();
            if (!this.leftTupleIterator.hasNext()) {
                return false;
            }
        }
        while (this.rightTupleIterator == null || !this.rightTupleIterator.hasNext()) {
            if (this.leftTupleIterator.hasNext()) {
                this.leftTuple = this.leftTupleIterator.next();
                BiEnumeratingPredicate<Solution_, A, B> filter = this.rightDatasetInstance.getFilter();
                this.rightTupleIterator = this.rightDatasetInstance.iterator(this.rightDatasetInstance.produceCompositeKey(this.leftTuple));
                if (filter == null) continue;
                this.rightTupleIterator = new FilteringIterator<Solution_, A, B>(filter, this.context.neighborhoodSession().getSolutionView(), this.leftTuple, this.rightTupleIterator);
                continue;
            }
            return false;
        }
        Object leftFact = this.leftTuple.factA;
        Object rightFact = this.rightTupleIterator.next().factA;
        this.nextMove = this.context.buildMove(leftFact, rightFact);
        return true;
    }

    @Override
    public Move<Solution_> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Move<Solution_> result = Objects.requireNonNull(this.nextMove);
        this.nextMove = null;
        return result;
    }
}

