/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.neighborhood;

import ai.timefold.solver.core.impl.neighborhood.MoveRepository;
import ai.timefold.solver.core.impl.neighborhood.OriginalOrderNeighborhoodIterator;
import ai.timefold.solver.core.impl.neighborhood.RandomOrderNeighborhoodIterator;
import ai.timefold.solver.core.impl.neighborhood.maybeapi.MoveDefinition;
import ai.timefold.solver.core.impl.neighborhood.move.InnerMoveStream;
import ai.timefold.solver.core.impl.neighborhood.move.MoveIterable;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultMoveStreamFactory;
import ai.timefold.solver.core.impl.neighborhood.stream.DefaultNeighborhoodSession;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.SessionContext;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class NeighborhoodsBasedMoveRepository<Solution_>
implements MoveRepository<Solution_> {
    private final DefaultMoveStreamFactory<Solution_> moveStreamFactory;
    private final List<InnerMoveStream<Solution_>> moveStreamList;
    private final boolean random;
    private @Nullable DefaultNeighborhoodSession<Solution_> neighborhoodSession;
    private @Nullable List<MoveIterable<Solution_>> moveIterableList;
    private @Nullable Random workingRandom;

    public NeighborhoodsBasedMoveRepository(DefaultMoveStreamFactory<Solution_> moveStreamFactory, List<MoveDefinition<Solution_>> neighborhood, boolean random) {
        this.moveStreamFactory = Objects.requireNonNull(moveStreamFactory);
        this.moveStreamList = Objects.requireNonNull(neighborhood).stream().map(d -> (InnerMoveStream)d.build(moveStreamFactory)).toList();
        this.random = random;
    }

    @Override
    public boolean isNeverEnding() {
        return this.random;
    }

    @Override
    public void initialize(SessionContext<Solution_> context) {
        if (this.neighborhoodSession != null) {
            throw new IllegalStateException("Impossible state: move repository initialized twice.");
        }
        this.neighborhoodSession = this.moveStreamFactory.createSession(context);
        this.moveStreamFactory.getSolutionDescriptor().visitAll(context.workingSolution(), this.neighborhoodSession::insert);
        this.neighborhoodSession.settle();
        this.moveIterableList = this.moveStreamList.stream().map(m -> m.getMoveIterable(this.neighborhoodSession)).toList();
    }

    public void insert(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).insert(planningEntityOrProblemFact);
    }

    public void update(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).update(planningEntityOrProblemFact);
    }

    public void retract(Object planningEntityOrProblemFact) {
        Objects.requireNonNull(this.neighborhoodSession).retract(planningEntityOrProblemFact);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.workingRandom = phaseScope.getWorkingRandom();
        phaseScope.getScoreDirector().setMoveRepository(this);
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.neighborhoodSession.settle();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.neighborhoodSession = null;
        this.moveIterableList = null;
        this.workingRandom = null;
        phaseScope.getScoreDirector().setMoveRepository(null);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.random) {
            return new RandomOrderNeighborhoodIterator<Solution_>(this.moveIterableList, Objects.requireNonNull(this.workingRandom));
        }
        return new OriginalOrderNeighborhoodIterator<Solution_>(this.moveIterableList);
    }
}

