/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.InnerGenuineVariableMetaModel;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.MoveAdapters;
import ai.timefold.solver.core.impl.move.InnerMutableSolutionView;
import ai.timefold.solver.core.impl.move.director.EphemeralMoveDirector;
import ai.timefold.solver.core.impl.move.director.VariableChangeRecordingScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public class MoveDirector<Solution_, Score_ extends Score<Score_>>
implements InnerMutableSolutionView<Solution_>,
Rebaser {
    protected final VariableDescriptorAwareScoreDirector<Solution_> externalScoreDirector;
    private final InnerScoreDirector<Solution_, Score_> backingScoreDirector;

    public MoveDirector(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        this.backingScoreDirector = Objects.requireNonNull(scoreDirector);
        this.externalScoreDirector = EphemeralMoveDirector.class.isAssignableFrom(this.getClass()) ? new VariableChangeRecordingScoreDirector(scoreDirector, false) : scoreDirector;
    }

    @Override
    public final <Entity_, Value_> void assignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ planningValue, Entity_ destinationEntity, int destinationIndex) {
        GenuineVariableDescriptor variableDescriptor = ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
        this.externalScoreDirector.beforeListVariableElementAssigned((ListVariableDescriptor<Solution_>)variableDescriptor, planningValue);
        this.externalScoreDirector.beforeListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, destinationEntity, destinationIndex, destinationIndex);
        ((ListVariableDescriptor)variableDescriptor).addElement(destinationEntity, destinationIndex, planningValue);
        this.externalScoreDirector.afterListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, destinationEntity, destinationIndex, destinationIndex + 1);
        this.externalScoreDirector.afterListVariableElementAssigned((ListVariableDescriptor<Solution_>)variableDescriptor, planningValue);
    }

    @Override
    public <Entity_, Value_> void unassignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ value) {
        PositionInList locationInList = this.getPositionOf(variableMetaModel, value).ensureAssigned(() -> "The value (%s) is not assigned to a list variable.\nThis may indicate score corruption or a problem with the move's implementation.".formatted(value));
        this.unassignValue(variableMetaModel, value, locationInList.entity(), locationInList.index());
    }

    @Override
    public <Entity_, Value_> Value_ unassignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, int index) {
        Value_ value = this.getValueAtIndex(variableMetaModel, entity, index);
        this.unassignValue(variableMetaModel, value, entity, index);
        return value;
    }

    private <Entity_, Value_> void unassignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ movedValue, Entity_ entity, int index) {
        GenuineVariableDescriptor variableDescriptor = ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
        this.externalScoreDirector.beforeListVariableElementUnassigned((ListVariableDescriptor<Solution_>)variableDescriptor, movedValue);
        this.externalScoreDirector.beforeListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, entity, index, index + 1);
        ((ListVariableDescriptor)variableDescriptor).getValue(entity).remove(index);
        this.externalScoreDirector.afterListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, entity, index, index);
        this.externalScoreDirector.afterListVariableElementUnassigned((ListVariableDescriptor<Solution_>)variableDescriptor, movedValue);
    }

    @Override
    public final <Entity_, Value_> void changeVariable(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, @Nullable Value_ newValue) {
        BasicVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.externalScoreDirector.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.externalScoreDirector.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final <Entity_, Value_> @Nullable Value_ moveValueBetweenLists(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex, Entity_ destinationEntity, int destinationIndex) {
        if (sourceEntity == destinationEntity) {
            return this.moveValueInList(variableMetaModel, sourceEntity, sourceIndex, destinationIndex);
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex + 1);
        Object element = variableDescriptor.removeElement(sourceEntity, sourceIndex);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex);
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex);
        variableDescriptor.addElement(destinationEntity, destinationIndex, element);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex + 1);
        return (Value_)element;
    }

    @Override
    public final <Entity_, Value_> @Nullable Value_ moveValueInList(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex, int destinationIndex) {
        if (sourceIndex == destinationIndex) {
            return null;
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        int fromIndex = Math.min(sourceIndex, destinationIndex);
        int toIndex = Math.max(sourceIndex, destinationIndex) + 1;
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, sourceEntity, fromIndex, toIndex);
        Object element = variableDescriptor.removeElement(sourceEntity, sourceIndex);
        variableDescriptor.addElement(sourceEntity, destinationIndex, element);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, sourceEntity, fromIndex, toIndex);
        return (Value_)element;
    }

    @Override
    public <Entity_, Value_> void swapValuesBetweenLists(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ leftEntity, int leftIndex, Entity_ rightEntity, int rightIndex) {
        if (leftEntity == rightEntity) {
            this.swapValuesInList(variableMetaModel, leftEntity, leftIndex, rightIndex);
        } else {
            ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
            this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, leftEntity, leftIndex, leftIndex + 1);
            this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, rightEntity, rightIndex, rightIndex + 1);
            Object oldLeftElement = variableDescriptor.setElement(leftEntity, leftIndex, variableDescriptor.getElement(rightEntity, rightIndex));
            variableDescriptor.setElement(rightEntity, rightIndex, oldLeftElement);
            this.externalScoreDirector.afterListVariableChanged(variableDescriptor, leftEntity, leftIndex, leftIndex + 1);
            this.externalScoreDirector.afterListVariableChanged(variableDescriptor, rightEntity, rightIndex, rightIndex + 1);
        }
    }

    @Override
    public <Entity_, Value_> void swapValuesInList(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, int leftIndex, int rightIndex) {
        if (leftIndex == rightIndex) {
            return;
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        int fromIndex = Math.min(leftIndex, rightIndex);
        int toIndex = Math.max(leftIndex, rightIndex) + 1;
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
        Object oldLeftElement = variableDescriptor.setElement(entity, leftIndex, variableDescriptor.getElement(entity, rightIndex));
        variableDescriptor.setElement(entity, rightIndex, oldLeftElement);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public <Entity_, Value_> boolean isValueInRange(GenuineVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @Nullable Entity_ entity, @Nullable Value_ value) {
        InnerGenuineVariableMetaModel innerGenuineVariableMetaModel = (InnerGenuineVariableMetaModel)((Object)variableMetaModel);
        ValueRangeDescriptor valueRangeDescriptor = ((GenuineVariableDescriptor)innerGenuineVariableMetaModel.variableDescriptor()).getValueRangeDescriptor();
        if (valueRangeDescriptor.canExtractValueRangeFromSolution()) {
            return this.backingScoreDirector.getValueRangeManager().getFromSolution(valueRangeDescriptor).contains(value);
        }
        return this.backingScoreDirector.getValueRangeManager().getFromEntity(valueRangeDescriptor, Objects.requireNonNull(entity)).contains(value);
    }

    public final void execute(Move<Solution_> move) {
        move.execute(this);
        this.externalScoreDirector.triggerVariableListeners();
    }

    public final void execute(ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move) {
        this.execute(MoveAdapters.toNewMove(move));
    }

    public final InnerScore<Score_> executeTemporary(Move<Solution_> move) {
        EphemeralMoveDirector<Solution_, Score_> ephemeralMoveDirector = this.ephemeral();
        ephemeralMoveDirector.execute(move);
        InnerScore<Score_> score = this.backingScoreDirector.calculateScore();
        ephemeralMoveDirector.close();
        return score;
    }

    public <Result_> Result_ executeTemporary(Move<Solution_> move, TemporaryMovePostprocessor<Solution_, Score_, Result_> postprocessor) {
        EphemeralMoveDirector<Solution_, Score_> ephemeralMoveDirector = this.ephemeral();
        ephemeralMoveDirector.execute(move);
        InnerScore<Score_> score = this.backingScoreDirector.calculateScore();
        Object result = postprocessor.apply(score, ephemeralMoveDirector.createUndoMove());
        ephemeralMoveDirector.close();
        return (Result_)result;
    }

    public final <Result_> Result_ executeTemporary(ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move, TemporaryMovePostprocessor<Solution_, Score_, Result_> postprocessor) {
        return this.executeTemporary(MoveAdapters.toNewMove(move), postprocessor);
    }

    @Override
    public final <Entity_, Value_> Value_ getValue(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity) {
        return MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity);
    }

    @Override
    public <Entity_, Value_> int countValues(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity) {
        return MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity).size();
    }

    @Override
    public final <Entity_, Value_> Value_ getValueAtIndex(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, int index) {
        return (Value_)MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity).get(index);
    }

    @Override
    public <Entity_, Value_> ElementPosition getPositionOf(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ value) {
        return MoveDirector.getPositionOf(this.backingScoreDirector, variableMetaModel, value);
    }

    @Override
    public <Entity_, Value_> boolean isPinned(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @Nullable Entity_ entity) {
        return this.isPinned(MoveDirector.extractVariableDescriptor(variableMetaModel).getEntityDescriptor(), entity);
    }

    public <Value_> boolean isPinned(EntityDescriptor<Solution_> entityDescriptor, @Nullable Value_ entity) {
        if (entity == null) {
            return false;
        }
        return !entityDescriptor.isMovable(this.backingScoreDirector.getWorkingSolution(), entity);
    }

    protected static <Solution_, Entity_, Value_> ElementPosition getPositionOf(InnerScoreDirector<Solution_, ?> scoreDirector, PlanningListVariableMetaModel<Solution_, Entity_, Value_> listVariableDescriptor, Value_ value) {
        return scoreDirector.getListVariableStateSupply(MoveDirector.extractVariableDescriptor(listVariableDescriptor)).getElementPosition(value);
    }

    @Override
    public <Entity_, Value_> boolean isPinned(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @Nullable Value_ value) {
        return this.isPinned(MoveDirector.extractVariableDescriptor(variableMetaModel), value);
    }

    public <Value_> boolean isPinned(ListVariableDescriptor<Solution_> listVariableDescriptor, @Nullable Value_ value) {
        if (value == null) {
            return false;
        }
        return this.backingScoreDirector.getListVariableStateSupply(listVariableDescriptor).isPinned(value);
    }

    @Override
    public final <T> @Nullable T rebase(@Nullable T problemFactOrPlanningEntity) {
        return this.externalScoreDirector.lookUpWorkingObject(problemFactOrPlanningEntity);
    }

    private static <Solution_, Entity_, Value_> BasicVariableDescriptor<Solution_> extractVariableDescriptor(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    private static <Solution_, Entity_, Value_> ListVariableDescriptor<Solution_> extractVariableDescriptor(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    final EphemeralMoveDirector<Solution_, Score_> ephemeral() {
        return new EphemeralMoveDirector<Solution_, Score_>(this.backingScoreDirector);
    }

    @Override
    public final VariableDescriptorAwareScoreDirector<Solution_> getScoreDirector() {
        return this.externalScoreDirector;
    }

    @FunctionalInterface
    public static interface TemporaryMovePostprocessor<Solution_, Score_ extends Score<Score_>, Result_>
    extends BiFunction<InnerScore<Score_>, Move<Solution_>, Result_> {
    }
}

