/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.stepcountinghillclimbing;

import ai.timefold.solver.core.config.localsearch.decider.acceptor.stepcountinghillclimbing.StepCountingHillClimbingType;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;

public class StepCountingHillClimbingAcceptor<Solution_>
extends AbstractAcceptor<Solution_> {
    protected int stepCountingHillClimbingSize = -1;
    protected StepCountingHillClimbingType stepCountingHillClimbingType;
    protected InnerScore<?> thresholdScore;
    protected int count = -1;

    public StepCountingHillClimbingAcceptor(int stepCountingHillClimbingSize, StepCountingHillClimbingType stepCountingHillClimbingType) {
        this.stepCountingHillClimbingSize = stepCountingHillClimbingSize;
        this.stepCountingHillClimbingType = stepCountingHillClimbingType;
        if (stepCountingHillClimbingSize <= 0) {
            throw new IllegalArgumentException("The stepCountingHillClimbingSize (" + stepCountingHillClimbingSize + ") cannot be negative or zero.");
        }
        if (stepCountingHillClimbingType == null) {
            throw new IllegalArgumentException("The stepCountingHillClimbingType (" + String.valueOf((Object)stepCountingHillClimbingType) + ") cannot be null.");
        }
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.thresholdScore = phaseScope.getBestScore();
        this.count = 0;
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope<Solution_> moveScope) {
        InnerScore lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
        InnerScore<Object> moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        return moveScore.compareTo(this.thresholdScore) >= 0;
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.count += this.determineCountIncrement(stepScope);
        if (this.count >= this.stepCountingHillClimbingSize) {
            this.thresholdScore = stepScope.getScore();
            this.count = 0;
        }
    }

    private int determineCountIncrement(LocalSearchStepScope<Solution_> stepScope) {
        return switch (this.stepCountingHillClimbingType) {
            default -> throw new IncompatibleClassChangeError();
            case StepCountingHillClimbingType.SELECTED_MOVE -> {
                long selectedMoveCount = stepScope.getSelectedMoveCount();
                if (selectedMoveCount > Integer.MAX_VALUE) {
                    yield Integer.MAX_VALUE;
                }
                yield (int)selectedMoveCount;
            }
            case StepCountingHillClimbingType.ACCEPTED_MOVE -> {
                long acceptedMoveCount = stepScope.getAcceptedMoveCount();
                if (acceptedMoveCount > Integer.MAX_VALUE) {
                    yield Integer.MAX_VALUE;
                }
                yield (int)acceptedMoveCount;
            }
            case StepCountingHillClimbingType.STEP -> 1;
            case StepCountingHillClimbingType.EQUAL_OR_IMPROVING_STEP -> {
                if (stepScope.getScore().compareTo(((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore()) >= 0) {
                    yield 1;
                }
                yield 0;
            }
            case StepCountingHillClimbingType.IMPROVING_STEP -> stepScope.getScore().compareTo(((LocalSearchPhaseScope)stepScope.getPhaseScope()).getLastCompletedStepScope().getScore()) > 0 ? 1 : 0;
        };
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.thresholdScore = null;
        this.count = -1;
    }
}

