/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Iterator;
import java.util.Objects;

public final class FromEntityPropertyValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueSelector<Solution_> {
    private final ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private final SelectionSorter<Solution_, Object> selectionSorter;
    private final boolean randomSelection;
    private CountableValueRange<Object> countableValueRange;
    private InnerScoreDirector<Solution_, ?> scoreDirector;

    public FromEntityPropertyValueSelector(ValueRangeDescriptor<Solution_> valueRangeDescriptor, SelectionSorter<Solution_, Object> selectionSorter, boolean randomSelection) {
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.selectionSorter = selectionSorter;
        this.randomSelection = randomSelection;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
        this.countableValueRange = this.scoreDirector.getValueRangeManager().getFromSolution((ValueRangeDescriptor<SelectionSorter<Solution_, Object>>)this.valueRangeDescriptor, this.selectionSorter);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
        this.countableValueRange = null;
    }

    @Override
    public SelectionSorter<Solution_, Object> getSelectionSorter() {
        return this.selectionSorter;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueRangeDescriptor.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        if (entity == null) {
            return Objects.requireNonNull(this.countableValueRange).getSize();
        }
        return this.scoreDirector.getValueRangeManager().countOnEntity(this.valueRangeDescriptor, entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        CountableValueRange<Object> valueRange = this.scoreDirector.getValueRangeManager().getFromEntity(this.valueRangeDescriptor, entity, this.selectionSorter);
        if (!this.randomSelection) {
            return valueRange.createOriginalIterator();
        }
        return valueRange.createRandomIterator(this.workingRandom);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        if (entity == null) {
            return this.countableValueRange.createOriginalIterator();
        }
        CountableValueRange<Object> valueRange = this.scoreDirector.getValueRangeManager().getFromEntity(this.valueRangeDescriptor, entity, this.selectionSorter);
        return valueRange.createOriginalIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FromEntityPropertyValueSelector)) {
            return false;
        }
        FromEntityPropertyValueSelector that = (FromEntityPropertyValueSelector)o;
        return Objects.equals(this.valueRangeDescriptor, that.valueRangeDescriptor) && Objects.equals(this.selectionSorter, that.selectionSorter) && this.randomSelection == that.randomSelection;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueRangeDescriptor, this.selectionSorter, this.randomSelection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVariableDescriptor().getVariableName() + ")";
    }
}

