/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.composite;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.BiasedRandomUnionMoveIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.CompositeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UniformRandomUnionMoveIterator;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UnionMoveSelector<Solution_>
extends CompositeMoveSelector<Solution_> {
    protected final SelectionProbabilityWeightFactory<Solution_, MoveSelector<Solution_>> selectorProbabilityWeightFactory;
    protected ScoreDirector<Solution_> scoreDirector;

    public UnionMoveSelector(List<MoveSelector<Solution_>> childMoveSelectorList, boolean randomSelection) {
        this(childMoveSelectorList, randomSelection, null);
    }

    public UnionMoveSelector(List<MoveSelector<Solution_>> childMoveSelectorList, boolean randomSelection, SelectionProbabilityWeightFactory<Solution_, MoveSelector<Solution_>> selectorProbabilityWeightFactory) {
        super(childMoveSelectorList, randomSelection);
        this.selectorProbabilityWeightFactory = selectorProbabilityWeightFactory;
        if (!randomSelection && selectorProbabilityWeightFactory != null) {
            throw new IllegalArgumentException("The selector (" + String.valueOf(this) + ") without randomSelection (" + randomSelection + ") cannot have a selectorProbabilityWeightFactory (" + String.valueOf(selectorProbabilityWeightFactory) + ").");
        }
    }

    public SelectionProbabilityWeightFactory<Solution_, MoveSelector<Solution_>> getSelectorProbabilityWeightFactory() {
        return this.selectorProbabilityWeightFactory;
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        this.scoreDirector = stepScope.getScoreDirector();
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection) {
            for (MoveSelector moveSelector : this.childMoveSelectorList) {
                if (!moveSelector.isNeverEnding()) continue;
                return true;
            }
            return false;
        }
        return !this.childMoveSelectorList.isEmpty() && ((MoveSelector)this.childMoveSelectorList.get(this.childMoveSelectorList.size() - 1)).isNeverEnding();
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            size += moveSelector.getSize();
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            Stream<Object> stream = Stream.empty();
            for (MoveSelector moveSelector2 : this.childMoveSelectorList) {
                stream = Stream.concat(stream, UnionMoveSelector.toStream(moveSelector2));
            }
            return stream.iterator();
        }
        if (this.selectorProbabilityWeightFactory == null) {
            return new UniformRandomUnionMoveIterator(this.childMoveSelectorList, this.workingRandom);
        }
        return new BiasedRandomUnionMoveIterator(this.childMoveSelectorList, moveSelector -> {
            double weight = this.selectorProbabilityWeightFactory.createProbabilityWeight(this.scoreDirector, (MoveSelector<Solution_>)moveSelector);
            if (weight < 0.0) {
                throw new IllegalStateException("The selectorProbabilityWeightFactory (" + String.valueOf(this.selectorProbabilityWeightFactory) + ") returned a negative probabilityWeight (" + weight + ").");
            }
            return weight;
        }, this.workingRandom);
    }

    private static <Solution_> Stream<Move<Solution_>> toStream(MoveSelector<Solution_> moveSelector) {
        return StreamSupport.stream(moveSelector.spliterator(), false);
    }

    @Override
    public String toString() {
        return "Union(" + String.valueOf(this.childMoveSelectorList) + ")";
    }
}

