/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.AbstractCachingEntitySelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;

public final class SortingEntitySelector<Solution_>
extends AbstractCachingEntitySelector<Solution_> {
    private final SelectionSorter<Solution_, Object> sorter;
    private SolverScope<Solution_> solverScope;

    public SortingEntitySelector(EntitySelector<Solution_> childEntitySelector, SelectionCacheType cacheType, SelectionSorter<Solution_, Object> sorter) {
        super(childEntitySelector, cacheType);
        this.sorter = sorter;
    }

    private void ensureStepCacheIsLoaded() {
        if (this.cacheType != SelectionCacheType.STEP || this.cachedEntityList != null) {
            return;
        }
        this.constructCache(this.solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.solverScope = phaseScope.getSolverScope();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.solverScope = null;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        if (this.cachedEntityList != null) {
            return;
        }
        super.constructCache(solverScope);
        this.sorter.sort(solverScope.getScoreDirector().getWorkingSolution(), this.cachedEntityList);
        this.logger.trace("    Sorted cachedEntityList: size ({}), entitySelector ({}).", (Object)this.cachedEntityList.size(), (Object)this);
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize() {
        this.ensureStepCacheIsLoaded();
        return super.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        this.ensureStepCacheIsLoaded();
        return this.cachedEntityList.iterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        this.ensureStepCacheIsLoaded();
        return this.cachedEntityList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        this.ensureStepCacheIsLoaded();
        return this.cachedEntityList.listIterator(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortingEntitySelector that = (SortingEntitySelector)o;
        return Objects.equals(this.sorter, that.sorter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sorter);
    }

    public String toString() {
        return "Sorting(" + String.valueOf(this.childEntitySelector) + ")";
    }
}

