/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionListIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class FilteringEntityByValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final IterableValueSelector<Solution_> replayingValueSelector;
    private final EntitySelector<Solution_> childEntitySelector;
    private final boolean randomSelection;
    private Object replayedValue;
    private ReachableValues<Object, Object> reachableValues;
    private long entitiesSize;

    public FilteringEntityByValueSelector(EntitySelector<Solution_> childEntitySelector, IterableValueSelector<Solution_> replayingValueSelector, boolean randomSelection) {
        this.replayingValueSelector = replayingValueSelector;
        this.childEntitySelector = childEntitySelector;
        this.randomSelection = randomSelection;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.childEntitySelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitiesSize = this.childEntitySelector.getEntityDescriptor().extractEntities(phaseScope.getWorkingSolution()).size();
        this.reachableValues = phaseScope.getScoreDirector().getValueRangeManager().getReachableValues(Objects.requireNonNull(phaseScope.getScoreDirector().getSolutionDescriptor().getListVariableDescriptor(), "Impossible state: the list variable cannot be null."));
        this.childEntitySelector.phaseStarted(phaseScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.childEntitySelector.phaseEnded(phaseScope);
        this.replayedValue = null;
        this.reachableValues = null;
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.childEntitySelector.stepStarted(stepScope);
    }

    public EntitySelector<Solution_> getChildEntitySelector() {
        return this.childEntitySelector;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public long getSize() {
        return this.entitiesSize;
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    private Object selectReplayedValue() {
        Iterator iterator = this.replayingValueSelector.iterator();
        if (iterator.hasNext()) {
            this.replayedValue = iterator.next();
        }
        return this.replayedValue;
    }

    @Override
    public Iterator<Object> endingIterator() {
        return new OriginalFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues);
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            return new RandomFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues, this.workingRandom);
        }
        return new OriginalFilteringValueRangeIterator<Object, Object>(this::selectReplayedValue, this.reachableValues);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new OriginalFilteringValueRangeListIterator<Object, Object>(this::selectReplayedValue, this.childEntitySelector.listIterator(), this.reachableValues);
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new OriginalFilteringValueRangeListIterator<Object, Object>(this::selectReplayedValue, this.childEntitySelector.listIterator(index), this.reachableValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringEntityByValueSelector)) return false;
        FilteringEntityByValueSelector that = (FilteringEntityByValueSelector)other;
        if (!Objects.equals(this.childEntitySelector, that.childEntitySelector)) return false;
        if (!Objects.equals(this.replayingValueSelector, that.replayingValueSelector)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.replayingValueSelector);
    }

    private static class OriginalFilteringValueRangeIterator<Entity_, Value_>
    extends UpcomingSelectionIterator<Entity_> {
        private final Supplier<Value_> upcomingValueSupplier;
        private final ReachableValues<Entity_, Value_> reachableValues;
        private Iterator<Entity_> entityIterator;

        private OriginalFilteringValueRangeIterator(Supplier<Value_> upcomingValueSupplier, ReachableValues<Entity_, Value_> reachableValues) {
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.upcomingValueSupplier = Objects.requireNonNull(upcomingValueSupplier);
        }

        private void initialize() {
            if (this.entityIterator != null) {
                return;
            }
            Value_ currentUpcomingValue = this.upcomingValueSupplier.get();
            if (currentUpcomingValue == null) {
                this.entityIterator = Collections.emptyIterator();
            } else {
                List<Entity_> allValues = this.reachableValues.extractEntitiesAsList(Objects.requireNonNull(currentUpcomingValue));
                this.entityIterator = Objects.requireNonNull(allValues).iterator();
            }
        }

        @Override
        protected Entity_ createUpcomingSelection() {
            this.initialize();
            if (!this.entityIterator.hasNext()) {
                return (Entity_)this.noUpcomingSelection();
            }
            return this.entityIterator.next();
        }
    }

    private static class RandomFilteringValueRangeIterator<Entity_, Value_>
    implements Iterator<Entity_> {
        private final Supplier<Value_> upcomingValueSupplier;
        private final ReachableValues<Entity_, Value_> reachableValues;
        private final Random workingRandom;
        private Value_ currentUpcomingValue;
        private List<Entity_> entityList;

        private RandomFilteringValueRangeIterator(Supplier<Value_> upcomingValueSupplier, ReachableValues<Entity_, Value_> reachableValues, Random workingRandom) {
            this.upcomingValueSupplier = upcomingValueSupplier;
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.workingRandom = workingRandom;
        }

        private void checkReplayedValue() {
            Value_ oldUpcomingValue = this.currentUpcomingValue;
            this.currentUpcomingValue = this.upcomingValueSupplier.get();
            if (this.currentUpcomingValue == null) {
                this.entityList = Collections.emptyList();
            } else if (oldUpcomingValue != this.currentUpcomingValue) {
                this.loadValues();
            }
        }

        private void loadValues() {
            this.entityList = this.reachableValues.extractEntitiesAsList(this.currentUpcomingValue);
        }

        @Override
        public boolean hasNext() {
            this.checkReplayedValue();
            return this.entityList != null && !this.entityList.isEmpty();
        }

        @Override
        public Entity_ next() {
            if (this.entityList.isEmpty()) {
                throw new NoSuchElementException();
            }
            int index = this.workingRandom.nextInt(this.entityList.size());
            return this.entityList.get(index);
        }
    }

    private static class OriginalFilteringValueRangeListIterator<Entity_, Value_>
    extends UpcomingSelectionListIterator<Entity_> {
        private final Supplier<Value_> upcomingValueSupplier;
        private final ListIterator<Entity_> entityIterator;
        private final ReachableValues<Entity_, Value_> reachableValues;
        private Value_ replayedValue;

        private OriginalFilteringValueRangeListIterator(Supplier<Value_> upcomingValueSupplier, ListIterator<Entity_> entityIterator, ReachableValues<Entity_, Value_> reachableValues) {
            this.upcomingValueSupplier = upcomingValueSupplier;
            this.entityIterator = entityIterator;
            this.reachableValues = reachableValues;
        }

        void checkReplayedValue() {
            Value_ newReplayedValue = this.upcomingValueSupplier.get();
            if (newReplayedValue != this.replayedValue) {
                this.replayedValue = newReplayedValue;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkReplayedValue();
            return super.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            this.checkReplayedValue();
            return super.hasPrevious();
        }

        @Override
        protected Entity_ createUpcomingSelection() {
            if (!this.entityIterator.hasNext()) {
                return (Entity_)this.noUpcomingSelection();
            }
            while (this.entityIterator.hasNext()) {
                Entity_ otherEntity = this.entityIterator.next();
                if (!this.reachableValues.isEntityReachable(this.replayedValue, otherEntity)) continue;
                return otherEntity;
            }
            return (Entity_)this.noUpcomingSelection();
        }

        @Override
        protected Entity_ createPreviousSelection() {
            if (!this.entityIterator.hasPrevious()) {
                return (Entity_)this.noUpcomingSelection();
            }
            while (this.entityIterator.hasPrevious()) {
                Entity_ otherEntity = this.entityIterator.previous();
                if (!this.reachableValues.isEntityReachable(this.replayedValue, otherEntity)) continue;
                return otherEntity;
            }
            return (Entity_)this.noUpcomingSelection();
        }
    }
}

