/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common;

import ai.timefold.solver.core.impl.domain.valuerange.sort.ValueRangeSorter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ReachableValues<Entity_, Value_> {
    private final ReachableValuesIndex<Entity_, Entity_> entitiesIndex;
    private final ReachableValuesIndex<Value_, ReachableItemValue<Entity_, Value_>> valuesIndex;
    private final Class<?> expectedSupertypeOfValue;
    private final @Nullable ValueRangeSorter<Value_> valueRangeSorter;
    private final boolean acceptsNullValue;
    private @Nullable List<Entity_>[] onDemandRandomAccessEntity;
    private @Nullable List<Value_>[] onDemandRandomAccessValue;
    private @Nullable ReachableItemValue<Entity_, Value_> firstCachedObject;
    private @Nullable ReachableItemValue<Entity_, Value_> secondCachedObject;

    public ReachableValues(ReachableValuesIndex<Entity_, Entity_> entitiesIndex, ReachableValuesIndex<Value_, ReachableItemValue<Entity_, Value_>> valuesIndex, Class<?> expectedSupertypeOfValue, @Nullable ValueRangeSorter<Value_> valueRangeSorter, boolean acceptsNullValue) {
        this.entitiesIndex = entitiesIndex;
        this.valuesIndex = valuesIndex;
        this.expectedSupertypeOfValue = expectedSupertypeOfValue;
        this.valueRangeSorter = valueRangeSorter;
        this.acceptsNullValue = acceptsNullValue;
        this.clear();
    }

    private @Nullable ReachableItemValue<Entity_, Value_> fetchItemValue(Object value) {
        ReachableItemValue<Entity_, Value_> selected = null;
        if (this.firstCachedObject != null && this.firstCachedObject.value == value) {
            selected = this.firstCachedObject;
        } else if (this.secondCachedObject != null && this.secondCachedObject.value == value) {
            selected = this.secondCachedObject;
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        if (selected == null) {
            Integer index = this.valuesIndex.indexMap().get(value);
            if (index == null) {
                return null;
            }
            selected = this.valuesIndex.allItems().get(index);
            this.secondCachedObject = this.firstCachedObject;
            this.firstCachedObject = selected;
        }
        return selected;
    }

    public List<Entity_> extractEntitiesAsList(Object value) {
        ReachableItemValue<Entity_, Value_> itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        List<Entity_> entityList = this.onDemandRandomAccessEntity[itemValue.ordinal];
        if (entityList == null) {
            this.onDemandRandomAccessEntity[itemValue.ordinal] = entityList = itemValue.getRandomAccessEntityList(this.entitiesIndex.allItems());
        }
        return entityList;
    }

    public List<Value_> extractValuesAsList(Object value) {
        ReachableItemValue<Entity_, Value_> itemValue = this.fetchItemValue(value);
        if (itemValue == null) {
            return Collections.emptyList();
        }
        List<Value_> valueList = this.onDemandRandomAccessValue[itemValue.ordinal];
        if (valueList == null) {
            this.onDemandRandomAccessValue[itemValue.ordinal] = valueList = itemValue.getRandomAccessValueList(this.valuesIndex.allItems(), this.valueRangeSorter);
        }
        return valueList;
    }

    public int getSize() {
        return this.valuesIndex.allItems().size();
    }

    public boolean isEntityReachable(@Nullable Value_ origin, @Nullable Entity_ entity) {
        if (entity == null) {
            return true;
        }
        if (origin == null) {
            return this.acceptsNullValue;
        }
        ReachableItemValue<Entity_, Value_> originItemValue = this.fetchItemValue(origin);
        if (originItemValue == null) {
            return false;
        }
        Integer entityIndex = this.entitiesIndex.indexMap().get(entity);
        if (entityIndex == null) {
            throw new IllegalStateException("The entity %s is not indexed.".formatted(entity));
        }
        return originItemValue.containsEntity(entityIndex);
    }

    public boolean isValueReachable(Value_ origin, @Nullable Value_ otherValue) {
        ReachableItemValue<Entity_, Value_> originItemValue = this.fetchItemValue(Objects.requireNonNull(origin));
        if (originItemValue == null) {
            return false;
        }
        if (otherValue == null) {
            return this.acceptsNullValue;
        }
        Integer otherValueIndex = this.valuesIndex.indexMap().get(Objects.requireNonNull(otherValue));
        if (otherValueIndex == null) {
            return false;
        }
        return originItemValue.containsValue(otherValueIndex);
    }

    public boolean acceptsNullValue() {
        return this.acceptsNullValue;
    }

    public boolean valueHasMatchingType(Value_ value) {
        return this.expectedSupertypeOfValue.isAssignableFrom(value.getClass());
    }

    public ReachableValues<Entity_, Value_> copy(ValueRangeSorter<Value_> sorterAdapter) {
        return new ReachableValues<Entity_, Value_>(this.entitiesIndex, this.valuesIndex, this.expectedSupertypeOfValue, sorterAdapter, this.acceptsNullValue);
    }

    public void clear() {
        this.firstCachedObject = null;
        this.secondCachedObject = null;
        int valueCount = this.valuesIndex.allItems().size();
        this.onDemandRandomAccessEntity = new List[valueCount];
        this.onDemandRandomAccessValue = new List[valueCount];
    }

    @NullMarked
    public record ReachableValuesIndex<Value_, Type_>(Map<Value_, Integer> indexMap, List<Type_> allItems) {
    }

    @NullMarked
    public static final class ReachableItemValue<Entity_, Value_> {
        private final int ordinal;
        private final Value_ value;
        private final BitSet entityBitSet;
        private final BitSet valueBitSet;

        public ReachableItemValue(int ordinal, Value_ value, int entityListSize, int valueListSize) {
            this.ordinal = ordinal;
            this.value = value;
            this.entityBitSet = new BitSet(entityListSize);
            this.valueBitSet = new BitSet(valueListSize);
        }

        public void addEntity(int entityIndex) {
            this.entityBitSet.set(entityIndex);
        }

        public void addValuesExcept(BitSet values, int exceptValueIndex) {
            this.valueBitSet.or(values);
            this.valueBitSet.clear(exceptValueIndex);
        }

        boolean containsEntity(int entityIndex) {
            return this.entityBitSet.get(entityIndex);
        }

        boolean containsValue(int valueIndex) {
            return this.valueBitSet.get(valueIndex);
        }

        List<Entity_> getRandomAccessEntityList(List<Entity_> allEntities) {
            return new BitSetIndexedList(allEntities, this.entityBitSet);
        }

        List<Value_> getRandomAccessValueList(List<ReachableItemValue<Entity_, Value_>> allValues, @Nullable ValueRangeSorter<Value_> valueRangeSorter) {
            BitSetIndexedList<ReachableItemValue, Object> valuesList = new BitSetIndexedList<ReachableItemValue, Object>(allValues, this.valueBitSet, v -> v.value);
            if (valueRangeSorter != null) {
                valueRangeSorter.sort(valuesList);
            }
            return valuesList;
        }
    }

    @NullMarked
    private static final class BitSetIndexedList<Type_, Value_>
    extends AbstractList<Value_> {
        private final Value_[] values;

        private BitSetIndexedList(List<Value_> availableValueList, BitSet containedValueIndex) {
            int valueCount = 0;
            int index = containedValueIndex.nextSetBit(0);
            this.values = new Object[containedValueIndex.cardinality()];
            while (index >= 0) {
                this.values[valueCount++] = availableValueList.get(index);
                index = containedValueIndex.nextSetBit(index + 1);
            }
        }

        private BitSetIndexedList(List<Type_> availableValueList, BitSet containedValueIndex, Function<Type_, Value_> valueExtractor) {
            int valueCount = 0;
            int index = containedValueIndex.nextSetBit(0);
            this.values = new Object[containedValueIndex.cardinality()];
            while (index >= 0) {
                this.values[valueCount++] = valueExtractor.apply(availableValueList.get(index));
                index = containedValueIndex.nextSetBit(index + 1);
            }
        }

        @Override
        public Value_ get(int index) {
            return this.values[index];
        }

        @Override
        public void sort(@Nullable Comparator<? super Value_> comparator) {
            if (comparator == null) {
                return;
            }
            Arrays.sort(this.values, comparator);
        }

        @Override
        public int size() {
            return this.values.length;
        }
    }
}

