/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.ShadowSources;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.impl.domain.variable.declarative.AbstractVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.FixedVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphChangeType;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public final class VariableReferenceGraphBuilder<Solution_> {
    final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToBeforeProcessor;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToAfterProcessor;
    final List<GraphNode<Solution_>> nodeList;
    final Map<Object, Integer> entityToEntityId;
    final Map<GraphNode<Solution_>, List<GraphNode<Solution_>>> fixedEdges;
    final Map<VariableMetaModel<?, ?, ?>, Map<Object, GraphNode<Solution_>>> variableReferenceToContainingNodeMap;
    final Map<Integer, Map<Object, GraphNode<Solution_>>> variableGroupIdToContainingNodeMap;
    boolean isGraphFixed;

    public VariableReferenceGraphBuilder(ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.changedVariableNotifier = changedVariableNotifier;
        this.nodeList = new ArrayList<GraphNode<Solution_>>();
        this.variableReferenceToContainingNodeMap = new HashMap();
        this.variableGroupIdToContainingNodeMap = new HashMap<Integer, Map<Object, GraphNode<Solution_>>>();
        this.variableReferenceToBeforeProcessor = new HashMap();
        this.variableReferenceToAfterProcessor = new HashMap();
        this.fixedEdges = new HashMap<GraphNode<Solution_>, List<GraphNode<Solution_>>>();
        this.entityToEntityId = new IdentityHashMap<Object, Integer>();
        this.isGraphFixed = true;
    }

    public <Entity_> void addVariableReferenceEntity(Entity_ entity, List<VariableUpdaterInfo<Solution_>> variableReferences) {
        Map<Object, GraphNode<Solution_>> instanceMap;
        GraphNode<Solution_> instance;
        int groupId = variableReferences.get(0).groupId();
        boolean isGroup = variableReferences.get(0).groupEntities() != null;
        Object entityRepresentative = entity;
        if (isGroup) {
            entityRepresentative = variableReferences.get(0).groupEntities()[0];
        }
        GraphNode<Solution_> graphNode = instance = (instanceMap = this.variableGroupIdToContainingNodeMap.get(groupId)) == null ? null : instanceMap.get(entityRepresentative);
        if (instance != null) {
            return;
        }
        if (instanceMap == null) {
            instanceMap = new IdentityHashMap<Object, GraphNode<Solution_>>();
            this.variableGroupIdToContainingNodeMap.put(groupId, instanceMap);
        }
        Integer entityId = this.entityToEntityId.computeIfAbsent(entityRepresentative, ignored -> this.entityToEntityId.size());
        int[] groupEntityIds = null;
        if (isGroup) {
            Object[] groupEntities = variableReferences.get(0).groupEntities();
            groupEntityIds = new int[groupEntities.length];
            for (int i = 0; i < groupEntityIds.length; ++i) {
                Object groupEntity = variableReferences.get(0).groupEntities()[i];
                groupEntityIds[i] = this.entityToEntityId.computeIfAbsent(groupEntity, ignored -> this.entityToEntityId.size());
            }
        }
        GraphNode<Solution_> node = new GraphNode<Solution_>(entityRepresentative, variableReferences, this.nodeList.size(), entityId, groupEntityIds);
        if (isGroup) {
            for (Object groupEntity : variableReferences.get(0).groupEntities()) {
                this.addToInstanceMaps(instanceMap, groupEntity, node, variableReferences);
            }
        } else {
            this.addToInstanceMaps(instanceMap, entity, node, variableReferences);
        }
        this.nodeList.add(node);
    }

    private void addToInstanceMaps(Map<Object, GraphNode<Solution_>> instanceMap, Object entity, GraphNode<Solution_> node, List<VariableUpdaterInfo<Solution_>> variableReferences) {
        instanceMap.put(entity, node);
        for (VariableUpdaterInfo<Solution_> variable : variableReferences) {
            Map variableInstanceMap = this.variableReferenceToContainingNodeMap.computeIfAbsent(variable.id(), ignored -> new IdentityHashMap());
            variableInstanceMap.put(entity, node);
        }
    }

    public void addFixedEdge(@NonNull GraphNode<Solution_> from, @NonNull GraphNode<Solution_> to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        this.fixedEdges.computeIfAbsent(from, k -> new ArrayList()).add(to);
    }

    public void addBeforeProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToBeforeProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public void addAfterProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToAfterProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public VariableReferenceGraph build(IntFunction<TopologicalOrderGraph> graphCreator) {
        this.assertNoFixedLoops();
        if (this.nodeList.isEmpty()) {
            return EmptyVariableReferenceGraph.INSTANCE;
        }
        if (this.isGraphFixed) {
            return new FixedVariableReferenceGraph(this, graphCreator);
        }
        return new DefaultVariableReferenceGraph(this, graphCreator);
    }

    public @NonNull GraphNode<Solution_> lookupOrError(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        GraphNode out = (GraphNode)this.variableReferenceToContainingNodeMap.getOrDefault(variableId, Collections.emptyMap()).get(entity);
        if (out == null) {
            throw new IllegalArgumentException();
        }
        return out;
    }

    private void assertNoFixedLoops() {
        DefaultTopologicalOrderGraph graph = new DefaultTopologicalOrderGraph(this.nodeList.size());
        for (Map.Entry<GraphNode<Solution_>, List<GraphNode<Solution_>>> fixedEdge : this.fixedEdges.entrySet()) {
            int fromNodeId = fixedEdge.getKey().graphNodeId();
            for (GraphNode<Solution_> toNode : fixedEdge.getValue()) {
                int toNodeId = toNode.graphNodeId();
                graph.addEdge(fromNodeId, toNodeId);
            }
        }
        BitSet changedBitSet = new BitSet();
        graph.commitChanges(changedBitSet);
        if (changedBitSet.cardinality() == 0) {
            return;
        }
        List<List<Integer>> loopedComponents = graph.getLoopedComponentList();
        int limit = 3;
        boolean isLimited = loopedComponents.size() > limit;
        LinkedHashSet loopedVariables = new LinkedHashSet();
        List<List> nodeCycleList = loopedComponents.stream().map(nodeIds -> nodeIds.stream().mapToInt(Integer::intValue).mapToObj(this.nodeList::get).toList()).toList();
        for (List cycle : nodeCycleList) {
            cycle.stream().flatMap(node -> node.variableReferences().stream()).map(VariableUpdaterInfo::id).forEach(loopedVariables::add);
        }
        StringBuilder out = new StringBuilder("There are fixed dependency loops in the graph for variables %s:%n".formatted(loopedVariables));
        for (List cycle : nodeCycleList) {
            out.append(cycle.stream().map(GraphNode::toString).collect(Collectors.joining(", ", "- [", "] ")));
        }
        if (isLimited) {
            out.append("- ...(");
            out.append(loopedComponents.size() - limit);
            out.append(" more)%n");
        }
        out.append("\nFixed dependency loops indicate a problem in either the input problem or in the @%s of the looped @%s.\nThere are two kinds of fixed dependency loops:\n\n- You have two shadow variables whose sources refer to each other;\n  this is called a source-induced fixed loop.\n  In code, this situation looks like this:\n\n      @ShadowVariable(supplierName=\"variable1Supplier\")\n      String variable1;\n\n      @ShadowVariable(supplierName=\"variable2Supplier\")\n      String variable2;\n\n      // ...\n\n      @ShadowSources(\"variable2\")\n      String variable1Supplier() { /* ... */ }\n\n      @ShadowSources(\"variable1\")\n      String variable2Supplier() { /* ... */ }\n\n- You have a shadow variable whose sources refer to itself transitively via a fact;\n  this is called a fact-induced fixed loop.\n  In code, this situation looks like this:\n\n      @PlanningEntity\n      public class Entity {\n          Entity dependency;\n\n          @ShadowVariable(supplierName=\"variableSupplier\")\n          String variable;\n\n          @ShadowSources(\"dependency.variable\")\n          String variableSupplier() { /* ... */ }\n          // ...\n      }\n\n      Entity a = new Entity();\n      Entity b = new Entity();\n      a.setDependency(b);\n      b.setDependency(a);\n      // a depends on b, and b depends on a, which is invalid.\n\n\nThe solver cannot break a fixed loop since the loop is caused by sources or facts instead of variables.\nFixed loops should not be confused with variable-induced loops, which can be broken by the solver:\n\n      @PlanningEntity\n      public class Entity {\n          Entity dependency;\n\n          @PreviousElementShadowVariable(/* ... */)\n          Entity previous;\n\n          @ShadowVariable(supplierName=\"variableSupplier\")\n          String variable;\n\n          @ShadowSources({\"previous.variable\", \"dependency.variable\"})\n          String variable1Supplier() { /* ... */ }\n          // ...\n      }\n\n      Entity a = new Entity();\n      Entity b = new Entity();\n      b.setDependency(a);\n      a.setPrevious(b);\n      // b depends on a via a fact, and a depends on b via a variable\n      // The solver can break this loop by moving a after b.\n\n\nMaybe check none of your @%s form a loop on the same entity.\n".formatted(ShadowSources.class.getSimpleName(), ShadowVariable.class.getSimpleName(), ShadowSources.class.getSimpleName()));
        throw new IllegalArgumentException(out.toString());
    }
}

