/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.ConsistencyTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityConsistencyState;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalSorter;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;

public final class SingleDirectionalParentVariableReferenceGraph<Solution_>
implements VariableReferenceGraph {
    private final Set<VariableMetaModel<?, ?, ?>> monitoredSourceVariableSet;
    private final VariableUpdaterInfo<Solution_>[] sortedVariableUpdaterInfos;
    private final UnaryOperator<Object> successorFunction;
    private final Comparator<Object> topologicalOrderComparator;
    private final UnaryOperator<Object> keyFunction;
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private final List<Object> changedEntities;
    private final Class<?> monitoredEntityClass;
    private final boolean canTerminateEarly;
    private boolean isUpdating;

    public SingleDirectionalParentVariableReferenceGraph(ConsistencyTracker<Solution_> consistencyTracker, List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeShadowVariableDescriptors, TopologicalSorter topologicalSorter, ChangedVariableNotifier<Solution_> changedVariableNotifier, boolean canTerminateEarly, Object[] entities) {
        this.monitoredEntityClass = sortedDeclarativeShadowVariableDescriptors.get(0).getEntityDescriptor().getEntityClass();
        this.sortedVariableUpdaterInfos = new VariableUpdaterInfo[sortedDeclarativeShadowVariableDescriptors.size()];
        this.monitoredSourceVariableSet = new HashSet();
        this.changedEntities = new ArrayList<Object>();
        this.isUpdating = false;
        this.canTerminateEarly = canTerminateEarly;
        this.successorFunction = topologicalSorter.successor();
        this.topologicalOrderComparator = topologicalSorter.comparator();
        this.keyFunction = topologicalSorter.key();
        this.changedVariableNotifier = changedVariableNotifier;
        Object[] shadowEntities = Arrays.stream(entities).filter(this.monitoredEntityClass::isInstance).sorted(this.topologicalOrderComparator).toArray();
        EntityConsistencyState<Solution_, Object> entityConsistencyState = consistencyTracker.getDeclarativeEntityConsistencyState(sortedDeclarativeShadowVariableDescriptors.get(0).getEntityDescriptor());
        int updaterIndex = 0;
        for (DeclarativeShadowVariableDescriptor<Solution_> variableDescriptor : sortedDeclarativeShadowVariableDescriptors) {
            VariableMetaModel variableMetaModel = variableDescriptor.getVariableMetaModel();
            VariableUpdaterInfo variableUpdaterInfo = new VariableUpdaterInfo(variableMetaModel, updaterIndex, variableDescriptor, entityConsistencyState, variableDescriptor.getMemberAccessor(), variableDescriptor.getCalculator()::executeGetter);
            this.sortedVariableUpdaterInfos[updaterIndex++] = variableUpdaterInfo;
            for (RootVariableSource<?, ?> source : variableDescriptor.getSources()) {
                for (VariableSourceReference sourceReference : source.variableSourceReferences()) {
                    this.monitoredSourceVariableSet.add(sourceReference.variableMetaModel());
                }
            }
        }
        this.changedEntities.addAll(List.of(shadowEntities));
        for (Object shadowEntity : shadowEntities) {
            entityConsistencyState.setEntityIsInconsistent(changedVariableNotifier, shadowEntity, false);
        }
        this.updateChanged();
    }

    @Override
    public void updateChanged() {
        this.isUpdating = true;
        this.changedEntities.sort(this.topologicalOrderComparator);
        IdentityHashMap processed = new IdentityHashMap();
        for (Object changedEntity : this.changedEntities) {
            Object key = this.keyFunction.apply(changedEntity);
            Object lastProcessed = processed.get(key);
            if (lastProcessed != null && this.topologicalOrderComparator.compare(lastProcessed, changedEntity) >= 0) continue;
            lastProcessed = this.updateChanged(changedEntity);
            processed.put(key, lastProcessed);
        }
        this.isUpdating = false;
        this.changedEntities.clear();
    }

    private Object updateChanged(Object entity) {
        Object current;
        Object previous = current = entity;
        while (current != null) {
            boolean anyChanged = false;
            for (VariableUpdaterInfo<Solution_> updater : this.sortedVariableUpdaterInfos) {
                anyChanged |= updater.updateIfChanged(current, this.changedVariableNotifier);
            }
            if (!this.canTerminateEarly || anyChanged) {
                previous = current;
                current = this.successorFunction.apply(current);
                continue;
            }
            return current;
        }
        return previous;
    }

    @Override
    public void beforeVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
    }

    @Override
    public void afterVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (!this.isUpdating && this.monitoredSourceVariableSet.contains(variableReference) && this.monitoredEntityClass.isInstance(entity)) {
            this.changedEntities.add(entity);
        }
    }
}

