/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.impl.domain.variable.ExternalizedIndexVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.ExternalizedListInverseVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.ExternalizedNextPrevElementVariableProcessor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ListVariableState<Solution_> {
    private final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private ExternalizedIndexVariableProcessor<Solution_> externalizedIndexProcessor = null;
    private ExternalizedListInverseVariableProcessor<Solution_> externalizedInverseProcessor = null;
    private ExternalizedNextPrevElementVariableProcessor<Solution_> externalizedPreviousElementProcessor = null;
    private ExternalizedNextPrevElementVariableProcessor<Solution_> externalizedNextElementProcessor = null;
    private boolean requiresPositionMap = true;
    private InnerScoreDirector<Solution_, ?> scoreDirector;
    private int unassignedCount = 0;
    private Map<Object, MutablePosition> elementPositionMap;

    public ListVariableState(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    public void linkShadowVariable(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedIndexProcessor = new ExternalizedIndexVariableProcessor<Solution_>(shadowVariableDescriptor);
    }

    public void linkShadowVariable(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedInverseProcessor = new ExternalizedListInverseVariableProcessor<Solution_>(shadowVariableDescriptor, this.sourceVariableDescriptor);
    }

    public void linkShadowVariable(PreviousElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedPreviousElementProcessor = ExternalizedNextPrevElementVariableProcessor.ofPrevious(shadowVariableDescriptor);
    }

    public void linkShadowVariable(NextElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.externalizedNextElementProcessor = ExternalizedNextPrevElementVariableProcessor.ofNext(shadowVariableDescriptor);
    }

    public void initialize(InnerScoreDirector<Solution_, ?> scoreDirector, int initialUnassignedCount) {
        this.scoreDirector = scoreDirector;
        this.unassignedCount = initialUnassignedCount;
        boolean bl = this.requiresPositionMap = this.externalizedIndexProcessor == null || this.externalizedInverseProcessor == null || this.externalizedPreviousElementProcessor == null || this.externalizedNextElementProcessor == null;
        if (this.requiresPositionMap) {
            if (this.elementPositionMap == null) {
                this.elementPositionMap = CollectionUtils.newIdentityHashMap(this.unassignedCount);
            } else {
                this.elementPositionMap.clear();
            }
        } else {
            this.elementPositionMap = null;
        }
        boolean shouldUnassignElements = !scoreDirector.expectShadowVariablesInCorrectState() && (this.externalizedIndexProcessor != null || this.externalizedInverseProcessor != null || this.externalizedPreviousElementProcessor != null || this.externalizedNextElementProcessor != null);
        Set unassignedValueSet = CollectionUtils.newIdentityHashSet(initialUnassignedCount);
        if (shouldUnassignElements) {
            for (Object unassignedValue : scoreDirector.getValueRangeManager().getFromSolution(this.sourceVariableDescriptor.getValueRangeDescriptor(), scoreDirector.getWorkingSolution())::createOriginalIterator) {
                unassignedValueSet.add(unassignedValue);
            }
        }
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), entity -> {
            int index = 0;
            Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
            Iterator iterator = assignedElements.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                this.addElement(entity, (List<Object>)assignedElements, element, index);
                unassignedValueSet.remove(element);
                ++index;
            }
        });
        if (shouldUnassignElements) {
            for (Object unassignedValue : unassignedValueSet) {
                if (this.externalizedIndexProcessor != null) {
                    this.externalizedIndexProcessor.unassignElement(scoreDirector, unassignedValue);
                }
                if (this.externalizedInverseProcessor != null) {
                    this.externalizedInverseProcessor.unassignElement(scoreDirector, unassignedValue);
                }
                if (this.externalizedNextElementProcessor != null) {
                    this.externalizedNextElementProcessor.unsetElement(scoreDirector, unassignedValue);
                }
                if (this.externalizedPreviousElementProcessor == null) continue;
                this.externalizedPreviousElementProcessor.unsetElement(scoreDirector, unassignedValue);
            }
        }
    }

    public void addElement(Object entity, List<Object> elements, Object element, int index) {
        MutablePosition oldPosition;
        if (this.requiresPositionMap && (oldPosition = this.elementPositionMap.put(element, new MutablePosition(entity, index))) != null) {
            throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) already exists (%s).".formatted(this.sourceVariableDescriptor, element, index, oldPosition));
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.addElement(this.scoreDirector, element, index);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.addElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        --this.unassignedCount;
    }

    public void removeElement(Object entity, Object element, int index) {
        if (this.requiresPositionMap) {
            MutablePosition oldPosition = this.elementPositionMap.remove(element);
            if (oldPosition == null) {
                throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) was already unassigned (%s).".formatted(this.sourceVariableDescriptor, element, index, oldPosition));
            }
            int oldIndex = oldPosition.getIndex();
            if (oldIndex != index) {
                throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) at index (%d) had an old index (%d) which is not the current index (%d).".formatted(this.sourceVariableDescriptor, element, index, oldIndex, index));
            }
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.removeElement(this.scoreDirector, element);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.removeElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.unsetElement(this.scoreDirector, element);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.unsetElement(this.scoreDirector, element);
        }
        ++this.unassignedCount;
    }

    public void unassignElement(Object element) {
        MutablePosition oldPosition;
        if (this.requiresPositionMap && (oldPosition = this.elementPositionMap.remove(element)) == null) {
            throw new IllegalStateException("The supply for list variable (%s) is corrupted, because the element (%s) did not exist before unassigning.".formatted(this.sourceVariableDescriptor, element));
        }
        if (this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.unassignElement(this.scoreDirector, element);
        }
        if (this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.unassignElement(this.scoreDirector, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.unsetElement(this.scoreDirector, element);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.unsetElement(this.scoreDirector, element);
        }
        ++this.unassignedCount;
    }

    public boolean changeElement(Object entity, List<Object> elements, int index) {
        Object element = elements.get(index);
        ChangeType difference = this.processElementPosition(entity, element, index);
        if (difference.indexChanged && this.externalizedIndexProcessor != null) {
            this.externalizedIndexProcessor.changeElement(this.scoreDirector, element, index);
        }
        if (difference.entityChanged && this.externalizedInverseProcessor != null) {
            this.externalizedInverseProcessor.changeElement(this.scoreDirector, entity, element);
        }
        if (this.externalizedPreviousElementProcessor != null) {
            this.externalizedPreviousElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        if (this.externalizedNextElementProcessor != null) {
            this.externalizedNextElementProcessor.setElement(this.scoreDirector, elements, element, index);
        }
        return difference.anythingChanged;
    }

    private ChangeType processElementPosition(Object entity, Object element, int index) {
        if (this.requiresPositionMap) {
            MutablePosition oldPosition = this.elementPositionMap.get(element);
            if (oldPosition == null) {
                this.elementPositionMap.put(element, new MutablePosition(entity, index));
                --this.unassignedCount;
                return ChangeType.BOTH;
            }
            ChangeType changeType = ListVariableState.comparePositions(entity, oldPosition.getEntity(), index, oldPosition.getIndex());
            if (changeType.anythingChanged) {
                if (changeType.entityChanged) {
                    oldPosition.setEntity(entity);
                }
                if (changeType.indexChanged) {
                    oldPosition.setIndex(index);
                }
            }
            return changeType;
        }
        Object oldEntity = this.getInverseSingleton(element);
        if (oldEntity == null) {
            --this.unassignedCount;
            return ChangeType.BOTH;
        }
        Integer oldIndex = this.getIndex(element);
        if (oldIndex == null) {
            return ChangeType.BOTH;
        }
        return ListVariableState.comparePositions(entity, oldEntity, index, oldIndex);
    }

    private static ChangeType comparePositions(Object entity, Object otherEntity, int index, int otherIndex) {
        if (entity != otherEntity) {
            return ChangeType.BOTH;
        }
        if (index != otherIndex) {
            return ChangeType.INDEX;
        }
        return ChangeType.NEITHER;
    }

    public ElementPosition getElementPosition(Object planningValue) {
        if (this.requiresPositionMap) {
            MutablePosition mutablePosition = this.elementPositionMap.get(planningValue);
            if (mutablePosition == null) {
                return ElementPosition.unassigned();
            }
            return mutablePosition.getPosition();
        }
        Object inverse = this.externalizedInverseProcessor.getInverseSingleton(planningValue);
        if (inverse == null) {
            return ElementPosition.unassigned();
        }
        return ElementPosition.of(inverse, this.externalizedIndexProcessor.getIndex(planningValue));
    }

    public Integer getIndex(Object planningValue) {
        if (this.externalizedIndexProcessor == null) {
            MutablePosition position = this.elementPositionMap.get(planningValue);
            if (position == null) {
                return null;
            }
            return position.getIndex();
        }
        return this.externalizedIndexProcessor.getIndex(planningValue);
    }

    public Object getInverseSingleton(Object planningValue) {
        if (this.externalizedInverseProcessor == null) {
            MutablePosition position = this.elementPositionMap.get(planningValue);
            if (position == null) {
                return null;
            }
            return position.getEntity();
        }
        return this.externalizedInverseProcessor.getInverseSingleton(planningValue);
    }

    public Object getPreviousElement(Object element) {
        if (this.externalizedPreviousElementProcessor == null) {
            MutablePosition mutablePosition = this.elementPositionMap.get(element);
            if (mutablePosition == null) {
                return null;
            }
            int index = mutablePosition.getIndex();
            if (index == 0) {
                return null;
            }
            return this.sourceVariableDescriptor.getValue(mutablePosition.getEntity()).get(index - 1);
        }
        return this.externalizedPreviousElementProcessor.getElement(element);
    }

    public Object getNextElement(Object element) {
        if (this.externalizedNextElementProcessor == null) {
            MutablePosition mutablePosition = this.elementPositionMap.get(element);
            if (mutablePosition == null) {
                return null;
            }
            Object list = this.sourceVariableDescriptor.getValue(mutablePosition.getEntity());
            int index = mutablePosition.getIndex();
            if (index == list.size() - 1) {
                return null;
            }
            return list.get(index + 1);
        }
        return this.externalizedNextElementProcessor.getElement(element);
    }

    public int getUnassignedCount() {
        return this.unassignedCount;
    }

    private static final class MutablePosition {
        private Object entity;
        private int index;
        private PositionInList position;

        public MutablePosition(Object entity, int index) {
            this.entity = entity;
            this.index = index;
        }

        public Object getEntity() {
            return this.entity;
        }

        public void setEntity(Object entity) {
            this.entity = entity;
            this.position = null;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
            this.position = null;
        }

        public PositionInList getPosition() {
            if (this.position == null) {
                this.position = ElementPosition.of(this.entity, this.index);
            }
            return this.position;
        }
    }

    private static enum ChangeType {
        BOTH(true, true),
        INDEX(false, true),
        NEITHER(false, false);

        final boolean anythingChanged;
        final boolean entityChanged;
        final boolean indexChanged;

        private ChangeType(boolean entityChanged, boolean indexChanged) {
            this.anythingChanged = entityChanged || indexChanged;
            this.entityChanged = entityChanged;
            this.indexChanged = indexChanged;
        }
    }
}

