/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.impl.domain.variable.ListElementsChangeEvent;
import ai.timefold.solver.core.impl.domain.variable.ListVariableState;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class ExternalizedListVariableStateSupply<Solution_, Entity_>
implements ListVariableStateSupply<Solution_, Entity_, Object> {
    private final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private final ListVariableState<Solution_> listVariableState;
    private boolean previousExternalized = false;
    private boolean nextExternalized = false;
    private @Nullable Solution_ workingSolution;

    public ExternalizedListVariableStateSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
        this.listVariableState = new ListVariableState<Solution_>(sourceVariableDescriptor);
    }

    @Override
    public void externalize(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
    }

    @Override
    public void externalize(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
    }

    @Override
    public void externalize(PreviousElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
        this.previousExternalized = true;
    }

    @Override
    public void externalize(NextElementShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        this.listVariableState.linkShadowVariable(shadowVariableDescriptor);
        this.nextExternalized = true;
    }

    @Override
    public void resetWorkingSolution(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.workingSolution = scoreDirector.getWorkingSolution();
        this.listVariableState.initialize(scoreDirector, (int)scoreDirector.getValueRangeManager().countOnSolution(this.sourceVariableDescriptor.getValueRangeDescriptor(), this.workingSolution));
    }

    @Override
    public void beforeChange(InnerScoreDirector<Solution_, ?> scoreDirector, ListElementsChangeEvent<Entity_> changeEvent) {
    }

    @Override
    public void afterChange(InnerScoreDirector<Solution_, ?> scoreDirector, ListElementsChangeEvent<Entity_> changeEvent) {
        Entity_ entity = changeEvent.entity();
        int fromIndex = changeEvent.changeStartIndexInclusive();
        int toIndex = changeEvent.changeEndIndexExclusive();
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        int elementCount = assignedElements.size();
        int firstChangeIndex = this.nextExternalized ? Math.max(0, fromIndex - 1) : fromIndex;
        int lastChangeIndex = this.previousExternalized ? Math.min(toIndex + 1, elementCount) : toIndex;
        for (int index = firstChangeIndex; index < elementCount; ++index) {
            boolean positionsDiffer = this.listVariableState.changeElement(entity, (List<Object>)assignedElements, index);
            if (positionsDiffer || index < lastChangeIndex) continue;
            return;
        }
    }

    @Override
    public void afterListElementUnassigned(InnerScoreDirector<Solution_, ?> scoreDirector, Object unassignedElement) {
        this.listVariableState.unassignElement(unassignedElement);
    }

    @Override
    public ElementPosition getElementPosition(Object planningValue) {
        return this.listVariableState.getElementPosition(planningValue);
    }

    @Override
    public @Nullable Integer getIndex(Object planningValue) {
        return this.listVariableState.getIndex(planningValue);
    }

    @Override
    public @Nullable Object getInverseSingleton(Object planningValue) {
        return this.listVariableState.getInverseSingleton(planningValue);
    }

    @Override
    public boolean isAssigned(Object element) {
        return this.getInverseSingleton(element) != null;
    }

    @Override
    public boolean isPinned(Object element) {
        if (!this.sourceVariableDescriptor.supportsPinning()) {
            return false;
        }
        ElementPosition position = this.getElementPosition(element);
        if (position instanceof PositionInList) {
            PositionInList assignedPosition = (PositionInList)position;
            return this.sourceVariableDescriptor.isElementPinned(Objects.requireNonNull(this.workingSolution), assignedPosition.entity(), assignedPosition.index());
        }
        return false;
    }

    @Override
    public int getUnassignedCount() {
        return this.listVariableState.getUnassignedCount();
    }

    @Override
    public @Nullable Object getPreviousElement(Object element) {
        return this.listVariableState.getPreviousElement(element);
    }

    @Override
    public @Nullable Object getNextElement(Object element) {
        return this.listVariableState.getNextElement(element);
    }

    @Override
    public ListVariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

