/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.primboolean;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.util.ValueRangeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.jspecify.annotations.NonNull;

public final class BooleanValueRange
extends AbstractCountableValueRange<Boolean> {
    @Override
    public long getSize() {
        return 2L;
    }

    @Override
    public boolean contains(Boolean value) {
        return value != null;
    }

    @Override
    public Boolean get(long index) {
        if (index < 0L || index >= 2L) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must be >= 0 and < 2.");
        }
        return index == 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public @NonNull Iterator<Boolean> createOriginalIterator() {
        return new OriginalBooleanValueRangeIterator();
    }

    @Override
    public @NonNull Iterator<Boolean> createRandomIterator(@NonNull Random workingRandom) {
        return new RandomBooleanValueRangeIterator(workingRandom);
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof BooleanValueRange;
    }

    public String toString() {
        return "[false, true]";
    }

    private static final class OriginalBooleanValueRangeIterator
    extends ValueRangeIterator<Boolean> {
        private boolean hasNext = true;
        private Boolean upcoming = Boolean.FALSE;

        private OriginalBooleanValueRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Boolean next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Boolean next = this.upcoming;
            if (this.upcoming.booleanValue()) {
                this.hasNext = false;
            } else {
                this.upcoming = Boolean.TRUE;
            }
            return next;
        }
    }

    private static final class RandomBooleanValueRangeIterator
    extends ValueRangeIterator<Boolean> {
        private final Random workingRandom;

        public RandomBooleanValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Boolean next() {
            return this.workingRandom.nextBoolean();
        }
    }
}

