/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.composite;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.ValueRangeCache;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.sort.ValueRangeSorter;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CompositeCountableValueRange<T>
extends AbstractCountableValueRange<T> {
    private final boolean isValueImmutable;
    private final List<? extends AbstractCountableValueRange<T>> valueRangeList;
    private final ValueRangeCache<T> cache;

    public CompositeCountableValueRange(List<? extends AbstractCountableValueRange<T>> childValueRangeList) {
        long maximumSize = 0L;
        boolean isImmutable = true;
        for (AbstractCountableValueRange<T> childValueRange : childValueRangeList) {
            isImmutable &= childValueRange.isValueImmutable();
            long size = childValueRange.getSize();
            if (size <= maximumSize) continue;
            maximumSize = size;
        }
        ValueRangeCache.Builder cacheBuilder = isImmutable ? ValueRangeCache.Builder.FOR_TRUSTED_VALUES : ValueRangeCache.Builder.FOR_USER_VALUES;
        this.cache = cacheBuilder.buildCache((int)maximumSize);
        for (AbstractCountableValueRange<T> childValueRange : childValueRangeList) {
            if (childValueRange instanceof NullAllowingCountableValueRange) {
                NullAllowingCountableValueRange nullAllowingCountableValueRange = (NullAllowingCountableValueRange)childValueRange;
                childValueRange = nullAllowingCountableValueRange.getChildValueRange();
            }
            childValueRange.createOriginalIterator().forEachRemaining(this.cache::add);
        }
        this.isValueImmutable = isImmutable;
        this.valueRangeList = childValueRangeList;
    }

    private CompositeCountableValueRange(boolean isValueImmutable, List<? extends AbstractCountableValueRange<T>> valueRangeList, ValueRangeCache<T> cache) {
        this.isValueImmutable = isValueImmutable;
        this.valueRangeList = valueRangeList;
        this.cache = cache;
    }

    @Override
    public boolean isValueImmutable() {
        return this.isValueImmutable;
    }

    @Override
    public long getSize() {
        return this.cache.getSize();
    }

    @Override
    public T get(long index) {
        return this.cache.get((int)index);
    }

    @Override
    public ValueRange<T> sort(ValueRangeSorter<T> sorter) {
        ValueRangeCache<T> sortedCache = this.cache.sort(sorter);
        return new CompositeCountableValueRange<T>(this.isValueImmutable, this.valueRangeList, sortedCache);
    }

    @Override
    public boolean contains(@Nullable T value) {
        return this.cache.contains(value);
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        return this.cache.iterator();
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return this.cache.iterator(workingRandom);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeCountableValueRange)) {
            return false;
        }
        CompositeCountableValueRange that = (CompositeCountableValueRange)o;
        return this.isValueImmutable == that.isValueImmutable && Objects.equals(this.valueRangeList, that.valueRangeList);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Boolean.hashCode(this.isValueImmutable);
        hash = 31 * hash + Objects.hashCode(this.valueRangeList);
        return hash;
    }
}

