/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.collection;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.ValueRangeCache;
import ai.timefold.solver.core.impl.domain.valuerange.sort.ValueRangeSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ListValueRange<T>
extends AbstractCountableValueRange<T> {
    private final boolean isValueImmutable;
    private final List<T> list;
    private @Nullable ValueRangeCache<T> cache;

    public ListValueRange(List<T> list) {
        this(list, false);
    }

    public ListValueRange(List<T> list, boolean isValueImmutable) {
        this.isValueImmutable = isValueImmutable;
        this.list = list;
    }

    @Override
    public boolean isValueImmutable() {
        return this.isValueImmutable;
    }

    @Override
    public long getSize() {
        return this.list.size();
    }

    @Override
    public @Nullable T get(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must fit in an int.");
        }
        return this.list.get((int)index);
    }

    @Override
    public boolean contains(@Nullable T value) {
        if (this.cache == null) {
            ValueRangeCache.Builder cacheBuilder = this.isValueImmutable ? ValueRangeCache.Builder.FOR_TRUSTED_VALUES : ValueRangeCache.Builder.FOR_USER_VALUES;
            this.cache = cacheBuilder.buildCache(this.list);
        }
        return this.cache.contains(value);
    }

    @Override
    public ValueRange<T> sort(ValueRangeSorter<T> sorter) {
        ArrayList<T> sortableList = new ArrayList<T>(this.list);
        sorter.sort(sortableList);
        return new ListValueRange<T>(sortableList, this.isValueImmutable);
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        return this.list.iterator();
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return new CachedListRandomIterator<T>(this.list, workingRandom);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ListValueRange)) {
            return false;
        }
        ListValueRange that = (ListValueRange)o;
        return this.isValueImmutable == that.isValueImmutable && Objects.equals(this.list, that.list);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Boolean.hashCode(this.isValueImmutable);
        hash = 31 * hash + Objects.hashCode(this.list);
        return hash;
    }

    public String toString() {
        return this.list.isEmpty() ? "[]" : "[" + String.valueOf(this.list.get(0)) + "-" + String.valueOf(this.list.get(this.list.size() - 1)) + "]";
    }
}

