/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor.gizmo;

import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoFieldHandler;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMethodExtendedHandler;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMethodHandler;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.function.Consumer;

interface GizmoMemberHandler {
    public static GizmoMemberHandler of(Class<?> declaringClass, String name, FieldDesc fieldDescriptor, boolean ignoreFinalChecks) {
        try {
            Field field = declaringClass.getField(name);
            return new GizmoFieldHandler(declaringClass, fieldDescriptor, ignoreFinalChecks || !Modifier.isFinal(field.getModifiers()));
        }
        catch (NoSuchFieldException e) {
            return new GizmoFieldHandler(declaringClass, fieldDescriptor, false);
        }
    }

    public static GizmoMemberHandler of(Class<?> declaringClass, MethodDesc methodDescriptor) {
        return GizmoMemberHandler.of(declaringClass, null, methodDescriptor);
    }

    public static GizmoMemberHandler of(Class<?> declaringClass, Class<?> readMethodParameterType, MethodDesc methodDescriptor) {
        return readMethodParameterType != null ? new GizmoMethodExtendedHandler(declaringClass, readMethodParameterType, methodDescriptor) : new GizmoMethodHandler(declaringClass, methodDescriptor);
    }

    public void whenIsField(Consumer<FieldDesc> var1);

    public void whenIsMethod(Consumer<MethodDesc> var1);

    public Expr readMemberValue(BlockCreator var1, Expr var2);

    public Expr readMemberValue(BlockCreator var1, Expr var2, Expr var3);

    public boolean writeMemberValue(MethodDesc var1, BlockCreator var2, Expr var3, Expr var4);

    public String getDeclaringClassName();

    public String getTypeName();

    public Type getType();

    public static String getTypeName(ClassDesc classDesc) {
        if (classDesc.isPrimitive()) {
            return classDesc.displayName();
        }
        if (classDesc.isArray()) {
            return GizmoMemberHandler.getTypeName(classDesc.componentType()) + "[]";
        }
        String classDescriptor = classDesc.descriptorString();
        return classDescriptor.substring(1, classDescriptor.length() - 1).replace('/', '.');
    }
}

