/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.impl.domain.common.accessor.AbstractMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ReflectionMethodMemberAccessor
extends AbstractMemberAccessor {
    private final Class<?> returnType;
    private final String methodName;
    private final Method readMethod;
    private final MethodHandle methodHandle;

    public ReflectionMethodMemberAccessor(Method readMethod) {
        this(readMethod, true, false);
    }

    public ReflectionMethodMemberAccessor(Method readMethod, boolean returnTypeRequired, boolean readMethodWithParameter) {
        this.readMethod = readMethod;
        this.returnType = readMethod.getReturnType();
        this.methodName = readMethod.getName();
        try {
            readMethod.setAccessible(true);
            this.methodHandle = MethodHandles.lookup().unreflect(readMethod).asFixedArity();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Impossible state: Method (%s) not accessible.\n%s\n".formatted(readMethod, MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE), e);
        }
        if (!readMethodWithParameter && readMethod.getParameterCount() != 0) {
            throw new IllegalArgumentException("The readMethod (%s) must not have any parameters (%s).".formatted(readMethod, Arrays.toString(readMethod.getParameterTypes())));
        }
        if (readMethodWithParameter && readMethod.getParameterCount() > 1) {
            throw new IllegalArgumentException("The readMethod (%s) must have only one parameter (%s).".formatted(readMethod, Arrays.toString(readMethod.getParameterTypes())));
        }
        if (returnTypeRequired && readMethod.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("The readMethod (%s) must have a return type (%s).".formatted(readMethod, readMethod.getReturnType()));
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.readMethod.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Class<?> getType() {
        return this.returnType;
    }

    @Override
    public Type getGenericType() {
        return this.readMethod.getGenericReturnType();
    }

    Method getReadMethod() {
        return this.readMethod;
    }

    MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    @Override
    public Object executeGetter(Object bean) {
        try {
            return this.methodHandle.invoke(bean);
        }
        catch (Throwable e) {
            throw new IllegalStateException("The property (%s) getterMethod (%s) on bean of class (%s) throws an exception.".formatted(this.methodName, this.readMethod, bean.getClass()), e);
        }
    }

    @Override
    public String getSpeedNote() {
        return "MethodHandle";
    }

    @Override
    public boolean supportSetter() {
        return false;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.readMethod.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.readMethod.getDeclaredAnnotationsByType(annotationClass);
    }

    public String toString() {
        return "method " + this.methodName + " on " + String.valueOf(this.readMethod.getDeclaringClass());
    }
}

