/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.AbstractMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionMethodExtendedMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionMethodMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.AccessorInfo;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class MemberAccessorFactory {
    static final String CLASSLOADER_NUDGE_MESSAGE = "Maybe add getClass().getClassLoader() as a parameter to the %s.create...() method call.".formatted(SolverFactory.class.getSimpleName());
    private final Map<String, MemberAccessor> memberAccessorCache;
    private final GizmoClassLoader gizmoClassLoader = new GizmoClassLoader();

    public static MemberAccessor buildMemberAccessor(Member member, MemberAccessorType memberAccessorType, DomainAccessType domainAccessType, ClassLoader classLoader) {
        return MemberAccessorFactory.buildMemberAccessor(member, memberAccessorType, null, domainAccessType, classLoader);
    }

    public static MemberAccessor buildMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass, DomainAccessType domainAccessType, ClassLoader classLoader) {
        return switch (domainAccessType) {
            default -> throw new IncompatibleClassChangeError();
            case DomainAccessType.GIZMO -> GizmoMemberAccessorFactory.buildGizmoMemberAccessor(member, annotationClass, AccessorInfo.of(memberAccessorType != MemberAccessorType.VOID_METHOD, memberAccessorType == MemberAccessorType.FIELD_OR_READ_METHOD_WITH_OPTIONAL_PARAMETER), (GizmoClassLoader)Objects.requireNonNull(classLoader));
            case DomainAccessType.REFLECTION -> MemberAccessorFactory.buildReflectiveMemberAccessor(member, memberAccessorType, annotationClass);
        };
    }

    private static MemberAccessor buildReflectiveMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass) {
        if (member instanceof Field) {
            Field field = (Field)member;
            return new ReflectionFieldMemberAccessor(field);
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            AbstractMemberAccessor memberAccessor = switch (memberAccessorType) {
                case MemberAccessorType.FIELD_OR_READ_METHOD, MemberAccessorType.FIELD_OR_READ_METHOD_WITH_OPTIONAL_PARAMETER -> {
                    if (!ReflectionHelper.isGetterMethod(method)) {
                        boolean methodWithParameter;
                        boolean v0 = methodWithParameter = memberAccessorType == MemberAccessorType.FIELD_OR_READ_METHOD_WITH_OPTIONAL_PARAMETER && method.getParameterCount() > 0;
                        if (annotationClass == null) {
                            ReflectionHelper.assertReadMethod(method, methodWithParameter);
                        } else {
                            ReflectionHelper.assertReadMethod(method, methodWithParameter, annotationClass);
                        }
                        yield methodWithParameter ? new ReflectionMethodExtendedMemberAccessor(method) : new ReflectionMethodMemberAccessor(method);
                    }
                }
                case MemberAccessorType.FIELD_OR_GETTER_METHOD, MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER -> {
                    boolean getterOnly;
                    boolean v1 = getterOnly = memberAccessorType != MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER;
                    if (annotationClass == null) {
                        ReflectionHelper.assertGetterMethod(method);
                    } else {
                        ReflectionHelper.assertGetterMethod(method, annotationClass);
                    }
                    yield new ReflectionBeanPropertyMemberAccessor(method, getterOnly);
                }
                case MemberAccessorType.VOID_METHOD -> new ReflectionMethodMemberAccessor(method, false, false);
                default -> throw new IllegalStateException("The memberAccessorType (%s) is not implemented.".formatted(new Object[]{memberAccessorType}));
            };
            if (memberAccessorType == MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER && !memberAccessor.supportSetter()) {
                if (annotationClass == null) {
                    throw new IllegalStateException("The class (%s) has a getter method (%s), but lacks a setter for that property (%s).".formatted(method.getDeclaringClass(), method, memberAccessor.getName()));
                }
                throw new IllegalStateException("The class (%s) has a @%s-annotated getter method (%s), but lacks a setter for that property (%s).".formatted(method.getDeclaringClass(), annotationClass.getSimpleName(), method, memberAccessor.getName()));
            }
            return memberAccessor;
        }
        throw new IllegalStateException("Impossible state: the member (%s)'s type is not a %s or a %s.".formatted(member, Field.class.getSimpleName(), Method.class.getSimpleName()));
    }

    public MemberAccessorFactory() {
        this(null);
    }

    public MemberAccessorFactory(Map<String, MemberAccessor> memberAccessorMap) {
        this.memberAccessorCache = memberAccessorMap == null ? new ConcurrentHashMap<String, MemberAccessor>() : new ConcurrentHashMap<String, MemberAccessor>(memberAccessorMap);
    }

    public MemberAccessor buildAndCacheMemberAccessor(Member member, MemberAccessorType memberAccessorType, Class<? extends Annotation> annotationClass, DomainAccessType domainAccessType) {
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        return this.memberAccessorCache.computeIfAbsent(generatedClassName, k -> MemberAccessorFactory.buildMemberAccessor(member, memberAccessorType, annotationClass, domainAccessType, this.gizmoClassLoader));
    }

    public MemberAccessor buildAndCacheMemberAccessor(Member member, MemberAccessorType memberAccessorType, DomainAccessType domainAccessType) {
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        return this.memberAccessorCache.computeIfAbsent(generatedClassName, k -> MemberAccessorFactory.buildMemberAccessor(member, memberAccessorType, domainAccessType, this.gizmoClassLoader));
    }

    public GizmoClassLoader getGizmoClassLoader() {
        return this.gizmoClassLoader;
    }

    public static enum MemberAccessorType {
        FIELD_OR_READ_METHOD,
        FIELD_OR_READ_METHOD_WITH_OPTIONAL_PARAMETER,
        FIELD_OR_GETTER_METHOD,
        FIELD_OR_GETTER_METHOD_WITH_SETTER,
        VOID_METHOD;

    }
}

