/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.placer;

import ai.timefold.solver.core.impl.constructionheuristic.placer.AbstractEntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.move.MoveAdapters;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.IterableFilteringValueSelector;
import java.util.Collections;
import java.util.Iterator;

public class QueuedValuePlacer<Solution_>
extends AbstractEntityPlacer<Solution_>
implements EntityPlacer<Solution_> {
    protected final IterableValueSelector<Solution_> valueSelector;
    protected final MoveSelector<Solution_> moveSelector;

    public QueuedValuePlacer(EntityPlacerFactory<Solution_> factory, HeuristicConfigPolicy<Solution_> configPolicy, IterableValueSelector<Solution_> valueSelector, MoveSelector<Solution_> moveSelector) {
        super(factory, configPolicy);
        this.valueSelector = valueSelector;
        this.moveSelector = moveSelector;
        this.phaseLifecycleSupport.addEventListener(valueSelector);
        this.phaseLifecycleSupport.addEventListener(moveSelector);
    }

    @Override
    public Iterator<Placement<Solution_>> iterator() {
        return new QueuedValuePlacingIterator();
    }

    public boolean hasListChangeMoveSelector() {
        return this.moveSelector instanceof ListChangeMoveSelector;
    }

    @Override
    public EntityPlacer<Solution_> rebuildWithFilter(SelectionFilter<Solution_, Object> filter) {
        return new QueuedValuePlacer<Solution_>(this.factory, this.configPolicy, (IterableFilteringValueSelector)FilteringValueSelector.of(this.valueSelector, filter), this.moveSelector);
    }

    private class QueuedValuePlacingIterator
    extends UpcomingSelectionIterator<Placement<Solution_>> {
        private Iterator<Object> valueIterator = Collections.emptyIterator();

        private QueuedValuePlacingIterator() {
        }

        @Override
        protected Placement<Solution_> createUpcomingSelection() {
            if (!this.valueIterator.hasNext()) {
                this.valueIterator = QueuedValuePlacer.this.valueSelector.iterator();
                if (!this.valueIterator.hasNext()) {
                    return (Placement)this.noUpcomingSelection();
                }
            }
            this.valueIterator.next();
            Iterator moveIterator = QueuedValuePlacer.this.moveSelector.iterator();
            if (!moveIterator.hasNext()) {
                return (Placement)this.noUpcomingSelection();
            }
            return new Placement(MoveAdapters.toNewMoveIterator(moveIterator));
        }
    }
}

