/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.visual;

import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.bavet.common.AbstractNode;
import ai.timefold.solver.core.impl.bavet.common.AbstractTwoInputNode;
import ai.timefold.solver.core.impl.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.core.impl.bavet.common.BavetStream;
import ai.timefold.solver.core.impl.bavet.common.BavetStreamBinaryOperation;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.bavet.visual.GraphEdge;
import ai.timefold.solver.core.impl.bavet.visual.GraphSink;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraint;
import ai.timefold.solver.core.impl.score.stream.bavet.uni.BavetForEachUniConstraintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record NodeGraph<Solution_>(Solution_ solution, List<AbstractNode> sources, List<GraphEdge> edges, List<GraphSink<Solution_>> sinks) {
    public static <Solution_, Stream_ extends BavetStream> NodeGraph<Solution_> of(Solution_ solution, List<AbstractNode> nodeList, Set<Constraint> constraintSet, Function<AbstractNode, Stream_> nodeToStreamFunction, Function<Stream_, AbstractNode> streamToParentNodeFunction) {
        ArrayList<AbstractNode> sourceList = new ArrayList<AbstractNode>();
        ArrayList<GraphEdge> edgeList = new ArrayList<GraphEdge>();
        for (AbstractNode node : nodeList) {
            BavetStream nodeCreator = (BavetStream)nodeToStreamFunction.apply(node);
            if (nodeCreator instanceof BavetForEachUniConstraintStream) {
                sourceList.add(node);
                continue;
            }
            if (nodeCreator instanceof BavetStreamBinaryOperation) {
                BavetStreamBinaryOperation binaryOperation;
                BavetStreamBinaryOperation castBinaryOperation = binaryOperation = (BavetStreamBinaryOperation)((Object)nodeCreator);
                AbstractNode leftParent = streamToParentNodeFunction.apply(castBinaryOperation.getLeftParent());
                edgeList.add(new GraphEdge(leftParent, node));
                AbstractNode rightParent = streamToParentNodeFunction.apply(castBinaryOperation.getRightParent());
                edgeList.add(new GraphEdge(rightParent, node));
                continue;
            }
            AbstractNode parent = streamToParentNodeFunction.apply((BavetStream)nodeCreator.getParent());
            edgeList.add(new GraphEdge(parent, node));
        }
        ArrayList sinkList = new ArrayList();
        for (Constraint constraint : constraintSet) {
            BavetConstraint castConstraint = (BavetConstraint)constraint;
            BavetAbstractConstraintStream stream = (BavetAbstractConstraintStream)((Object)castConstraint.getScoringConstraintStream());
            AbstractNode node = streamToParentNodeFunction.apply(stream);
            sinkList.add(new GraphSink(node, castConstraint));
        }
        return new NodeGraph<Solution_>(solution, sourceList.stream().distinct().toList(), edgeList.stream().distinct().toList(), sinkList.stream().distinct().toList());
    }

    public String buildGraphvizDOT() {
        GraphSink<Solution_> sink;
        StringBuilder stringBuilder = new StringBuilder();
        Stream sourceStream = this.sources.stream();
        Stream edgeStream = this.edges.stream().flatMap(edge -> Stream.of(edge.from(), edge.to()));
        List<AbstractNode> allNodes = Stream.concat(sourceStream, edgeStream).distinct().sorted(Comparator.comparingLong(AbstractNode::getId)).toList();
        stringBuilder.append("    label=<<B>Bavet Node Network for '%s'</B><BR />%d constraints, %d nodes>;%n".formatted(this.solution.toString(), this.sinks.size(), allNodes.size()));
        for (AbstractNode node : allNodes) {
            for (GraphEdge edge2 : this.edges) {
                if (!edge2.from().equals(node)) continue;
                String line2 = "    %s -> %s;%n".formatted(NodeGraph.nodeId(node), NodeGraph.nodeId(edge2.to()));
                stringBuilder.append(line2);
            }
        }
        for (int i = 0; i < this.sinks.size(); ++i) {
            sink = this.sinks.get(i);
            String string = "    %s -> %s;%n".formatted(NodeGraph.nodeId(sink.node()), NodeGraph.constraintId(i));
            stringBuilder.append(string);
        }
        for (AbstractNode node : allNodes) {
            String string = "    %s %s;%n".formatted(NodeGraph.nodeId(node), NodeGraph.getMetadata(node));
            stringBuilder.append(string);
        }
        for (int i = 0; i < this.sinks.size(); ++i) {
            sink = this.sinks.get(i);
            String string = "    %s %s;%n".formatted(NodeGraph.constraintId(i), NodeGraph.getMetadata(sink, this.solution));
            stringBuilder.append(string);
        }
        TreeMap<Long, Set> layerMap = new TreeMap<Long, Set>();
        for (AbstractNode abstractNode : allNodes) {
            long layer = abstractNode.getLayerIndex();
            layerMap.computeIfAbsent(layer, k -> new LinkedHashSet()).add(abstractNode);
        }
        for (Map.Entry entry : layerMap.entrySet()) {
            String line3 = ((Set)entry.getValue()).stream().map(NodeGraph::nodeId).collect(Collectors.joining("; ", "    { rank=same; ", "; }" + System.lineSeparator()));
            stringBuilder.append(line3);
        }
        return "digraph {\n    rankdir=LR;\n%s}".formatted(stringBuilder.toString());
    }

    private static String getMetadata(AbstractNode node) {
        Map<String, String> metadata = NodeGraph.getBaseDOTProperties("lightgrey", false);
        if (node instanceof AbstractForEachUniNode) {
            metadata.put("style", "filled");
            metadata.put("fillcolor", "#3e00ff");
            metadata.put("fontcolor", "white");
        } else if (node instanceof AbstractTwoInputNode) {
            metadata.put("style", "filled");
            metadata.put("fillcolor", "#ff7700");
            metadata.put("fontcolor", "white");
        }
        metadata.put("label", NodeGraph.nodeLabel(node));
        return NodeGraph.mergeMetadata(metadata);
    }

    private static String mergeMetadata(Map<String, String> metadata) {
        return metadata.entrySet().stream().map(entry -> {
            if (((String)entry.getKey()).equals("label")) {
                return "%s=<%s>".formatted(entry.getKey(), entry.getValue());
            }
            return "%s=\"%s\"".formatted(entry.getKey(), entry.getValue());
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    private static <Solution_> String getMetadata(GraphSink<Solution_> sink, Solution_ solution) {
        BavetConstraint<Solution_> constraint = sink.constraint();
        Map<String, String> metadata = NodeGraph.getBaseDOTProperties("#3423a6", true);
        metadata.put("label", "<B>%s</B><BR />(Weight: %s)".formatted(constraint.getConstraintRef().constraintName(), constraint.extractConstraintWeight(solution)));
        return NodeGraph.mergeMetadata(metadata);
    }

    private static Map<String, String> getBaseDOTProperties(String fillcolor, boolean whiteText) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("shape", "plaintext");
        metadata.put("pad", "0.2");
        metadata.put("style", "filled");
        metadata.put("fillcolor", fillcolor);
        metadata.put("fontname", "Courier New");
        metadata.put("fontcolor", whiteText ? "white" : "black");
        return metadata;
    }

    private static String nodeId(AbstractNode node) {
        return "node" + node.getId();
    }

    private static String constraintId(int id) {
        return "impact" + id;
    }

    private static String nodeLabel(AbstractNode node) {
        String className = node.getClass().getSimpleName().replace("Node", "");
        if (node instanceof AbstractForEachUniNode) {
            AbstractForEachUniNode forEachNode = (AbstractForEachUniNode)node;
            return "<B>%s</B><BR/>(%s)".formatted(className, forEachNode.getForEachClass().getSimpleName());
        }
        return "<B>%s</B>".formatted(className);
    }
}

