/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.joiner;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;

public enum JoinerType {
    EQUAL(Objects::equals),
    LESS_THAN((a, b) -> ((Comparable)a).compareTo(b) < 0),
    LESS_THAN_OR_EQUAL((a, b) -> ((Comparable)a).compareTo(b) <= 0),
    GREATER_THAN((a, b) -> ((Comparable)a).compareTo(b) > 0),
    GREATER_THAN_OR_EQUAL((a, b) -> ((Comparable)a).compareTo(b) >= 0),
    CONTAINING((a, b) -> ((Collection)a).contains(b)),
    INTERSECTING((a, b) -> JoinerType.intersecting((Collection)a, (Collection)b)),
    DISJOINT((a, b) -> JoinerType.disjoint((Collection)a, (Collection)b));

    private final BiPredicate<Object, Object> matcher;

    private JoinerType(BiPredicate<Object, Object> matcher) {
        this.matcher = matcher;
    }

    public JoinerType flip() {
        return switch (this) {
            case LESS_THAN -> GREATER_THAN;
            case LESS_THAN_OR_EQUAL -> GREATER_THAN_OR_EQUAL;
            case GREATER_THAN -> LESS_THAN;
            case GREATER_THAN_OR_EQUAL -> LESS_THAN_OR_EQUAL;
            default -> throw new IllegalStateException("The joinerType (%s) cannot be flipped.".formatted(new Object[]{this}));
        };
    }

    public boolean matches(Object left, Object right) {
        try {
            return this.matcher.test(left, right);
        }
        catch (Exception e) {
            throw new IllegalStateException("Joiner (" + String.valueOf((Object)this) + ") threw an exception matching left (" + String.valueOf(left) + ") and right (" + String.valueOf(right) + ") objects.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean disjoint(Collection<?> leftCollection, Collection<?> rightCollection) {
        if (!leftCollection.stream().noneMatch(rightCollection::contains)) return false;
        if (!rightCollection.stream().noneMatch(leftCollection::contains)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean intersecting(Collection<?> leftCollection, Collection<?> rightCollection) {
        if (leftCollection.stream().anyMatch(rightCollection::contains)) return true;
        if (!rightCollection.stream().anyMatch(leftCollection::contains)) return false;
        return true;
    }
}

