/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import ai.timefold.solver.core.impl.bavet.common.index.CompositeKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.KeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.SingleKeyRetriever;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class EqualsIndexer<T, Key_>
implements Indexer<T> {
    private final KeyRetriever<Key_> keyRetriever;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Map<Key_, Indexer<T>> downstreamIndexerMap = new HashMap<Key_, Indexer<T>>();

    public EqualsIndexer(Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.keyRetriever = new SingleKeyRetriever();
        this.downstreamIndexerSupplier = downstreamIndexerSupplier;
    }

    public EqualsIndexer(int keyIndex, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.keyRetriever = new CompositeKeyRetriever(keyIndex);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
    }

    @Override
    public ListEntry<T> put(Object compositeKey, T tuple) {
        Object indexKey = this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.downstreamIndexerMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(compositeKey, tuple);
    }

    @Override
    public void remove(Object compositeKey, ListEntry<T> entry) {
        Object indexKey = this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(compositeKey, indexKey, entry);
        downstreamIndexer.remove(compositeKey, entry);
        if (downstreamIndexer.isEmpty()) {
            this.downstreamIndexerMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(Object compositeKey, Key_ indexerKey, ListEntry<T> entry) {
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (%s) with composite key (%s) doesn't exist in the indexer %s.".formatted(entry, compositeKey, this));
        }
        return downstreamIndexer;
    }

    @Override
    public int size(Object compositeKey) {
        Object indexKey = this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return 0;
        }
        return downstreamIndexer.size(compositeKey);
    }

    @Override
    public void forEach(Object compositeKey, Consumer<T> tupleConsumer) {
        Object indexKey = this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return;
        }
        downstreamIndexer.forEach(compositeKey, tupleConsumer);
    }

    @Override
    public boolean isEmpty() {
        return this.downstreamIndexerMap.isEmpty();
    }

    @Override
    public List<? extends ListEntry<T>> asList(Object compositeKey) {
        Object indexKey = this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.downstreamIndexerMap.get(indexKey);
        if (downstreamIndexer == null) {
            return Collections.emptyList();
        }
        return downstreamIndexer.asList(compositeKey);
    }

    public String toString() {
        return "size = " + this.downstreamIndexerMap.size();
    }
}

