/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common.index;

import ai.timefold.solver.core.impl.bavet.common.index.ComposingList;
import ai.timefold.solver.core.impl.bavet.common.index.CompositeKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.Indexer;
import ai.timefold.solver.core.impl.bavet.common.index.KeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.index.SingleKeyRetriever;
import ai.timefold.solver.core.impl.bavet.common.joiner.JoinerType;
import ai.timefold.solver.core.impl.util.ListEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ComparisonIndexer<T, Key_ extends Comparable<Key_>>
implements Indexer<T> {
    private final KeyRetriever<Key_> keyRetriever;
    private final Supplier<Indexer<T>> downstreamIndexerSupplier;
    private final Comparator<Key_> keyComparator;
    private final boolean hasOrEquals;
    private final NavigableMap<Key_, Indexer<T>> comparisonMap;

    public ComparisonIndexer(JoinerType comparisonJoinerType, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this(comparisonJoinerType, new SingleKeyRetriever(), downstreamIndexerSupplier);
    }

    public ComparisonIndexer(JoinerType comparisonJoinerType, int keyIndex, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this(comparisonJoinerType, new CompositeKeyRetriever(keyIndex), downstreamIndexerSupplier);
    }

    private ComparisonIndexer(JoinerType comparisonJoinerType, KeyRetriever<Key_> keyRetriever, Supplier<Indexer<T>> downstreamIndexerSupplier) {
        this.keyRetriever = Objects.requireNonNull(keyRetriever);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
        this.keyComparator = comparisonJoinerType == JoinerType.GREATER_THAN || comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL ? Comparator.naturalOrder().reversed() : Comparator.naturalOrder();
        this.hasOrEquals = comparisonJoinerType == JoinerType.GREATER_THAN_OR_EQUAL || comparisonJoinerType == JoinerType.LESS_THAN_OR_EQUAL;
        this.comparisonMap = new TreeMap<Key_, Indexer<T>>(this.keyComparator);
    }

    @Override
    public ListEntry<T> put(Object compositeKey, T tuple) {
        Comparable indexKey = (Comparable)this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = (Indexer<T>)this.comparisonMap.get(indexKey);
        if (downstreamIndexer == null) {
            downstreamIndexer = this.downstreamIndexerSupplier.get();
            this.comparisonMap.put(indexKey, downstreamIndexer);
        }
        return downstreamIndexer.put(compositeKey, tuple);
    }

    @Override
    public void remove(Object compositeKey, ListEntry<T> entry) {
        Comparable indexKey = (Comparable)this.keyRetriever.apply(compositeKey);
        Indexer<T> downstreamIndexer = this.getDownstreamIndexer(compositeKey, indexKey, entry);
        downstreamIndexer.remove(compositeKey, entry);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(indexKey);
        }
    }

    private Indexer<T> getDownstreamIndexer(Object compositeKey, Key_ indexerKey, ListEntry<T> entry) {
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(indexerKey);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (%s) with composite key (%s) doesn't exist in the indexer %s.".formatted(entry, compositeKey, this));
        }
        return downstreamIndexer;
    }

    @Override
    public int size(Object compositeKey) {
        int mapSize = this.comparisonMap.size();
        if (mapSize == 0) {
            return 0;
        }
        Comparable indexKey = (Comparable)this.keyRetriever.apply(compositeKey);
        if (mapSize == 1) {
            Map.Entry<Key_, Indexer<T>> entry = this.comparisonMap.firstEntry();
            if (this.boundaryReached((Comparable)entry.getKey(), indexKey)) {
                return 0;
            }
            return entry.getValue().size(compositeKey);
        }
        int size = 0;
        for (Map.Entry entry : this.comparisonMap.entrySet()) {
            if (this.boundaryReached((Comparable)entry.getKey(), indexKey)) break;
            size += ((Indexer)entry.getValue()).size(compositeKey);
        }
        return size;
    }

    private boolean boundaryReached(Key_ entryKey, Key_ indexKey) {
        int comparison = this.keyComparator.compare(entryKey, indexKey);
        if (comparison >= 0) {
            return comparison > 0 || !this.hasOrEquals;
        }
        return false;
    }

    @Override
    public void forEach(Object compositeKey, Consumer<T> tupleConsumer) {
        int size = this.comparisonMap.size();
        if (size == 0) {
            return;
        }
        Comparable indexKey = (Comparable)this.keyRetriever.apply(compositeKey);
        if (size == 1) {
            Map.Entry<Key_, Indexer<T>> entry = this.comparisonMap.firstEntry();
            this.visitEntry(compositeKey, tupleConsumer, indexKey, entry);
        } else {
            for (Map.Entry entry : this.comparisonMap.entrySet()) {
                boolean boundaryReached = this.visitEntry(compositeKey, tupleConsumer, indexKey, entry);
                if (!boundaryReached) continue;
                return;
            }
        }
    }

    private boolean visitEntry(Object compositeKey, Consumer<T> tupleConsumer, Key_ indexKey, Map.Entry<Key_, Indexer<T>> entry) {
        if (this.boundaryReached((Comparable)entry.getKey(), indexKey)) {
            return true;
        }
        entry.getValue().forEach(compositeKey, tupleConsumer);
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }

    @Override
    public List<? extends ListEntry<T>> asList(Object compositeKey) {
        int size = this.comparisonMap.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ComposingList<ListEntry<T>> result = new ComposingList<ListEntry<T>>();
        Comparable indexKey = (Comparable)this.keyRetriever.apply(compositeKey);
        if (size == 1) {
            Map.Entry<Key_, Indexer<T>> entry = this.comparisonMap.firstEntry();
            this.visitEntry(compositeKey, result, indexKey, entry);
        } else {
            for (Map.Entry entry : this.comparisonMap.entrySet()) {
                boolean boundaryReached = this.visitEntry(compositeKey, result, indexKey, entry);
                if (!boundaryReached) continue;
                return result;
            }
        }
        return result;
    }

    private boolean visitEntry(Object compositeKey, ComposingList<ListEntry<T>> result, Key_ indexKey, Map.Entry<Key_, Indexer<T>> entry) {
        if (this.boundaryReached((Comparable)entry.getKey(), indexKey)) {
            return true;
        }
        Indexer indexer = entry.getValue();
        result.addSubList(() -> indexer.asList(compositeKey), indexer.size(compositeKey));
        return false;
    }

    public String toString() {
        return "size = " + this.comparisonMap.size();
    }
}

