/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractTwoInputNode;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InOutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.OutTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;
import java.util.function.Consumer;

public abstract class AbstractJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractTwoInputNode<LeftTuple_, UniTuple<Right_>> {
    protected final int inputStoreIndexLeftOutTupleList;
    protected final int inputStoreIndexRightOutTupleList;
    private final boolean isFiltering;
    private final int outputStoreIndexLeftOutEntry;
    private final int outputStoreIndexRightOutEntry;
    protected final OutTupleStorePositionTracker outputStoreSizeTracker;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractJoinNode(TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, InOutTupleStorePositionTracker tupleStorePositionTracker) {
        this.inputStoreIndexLeftOutTupleList = tupleStorePositionTracker.reserveNextLeft();
        this.inputStoreIndexRightOutTupleList = tupleStorePositionTracker.reserveNextRight();
        this.isFiltering = isFiltering;
        this.outputStoreIndexLeftOutEntry = tupleStorePositionTracker.reserveNextOut();
        this.outputStoreIndexRightOutEntry = tupleStorePositionTracker.reserveNextOut();
        this.outputStoreSizeTracker = tupleStorePositionTracker;
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
    }

    protected abstract OutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void setOutTupleLeftFacts(OutTuple_ var1, LeftTuple_ var2);

    protected abstract void setOutTupleRightFact(OutTuple_ var1, UniTuple<Right_> var2);

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected final void insertOutTuple(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        OutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
        ElementAwareLinkedList outTupleListLeft = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
        ((AbstractTuple)outTuple).setStore(this.outputStoreIndexLeftOutEntry, outTupleListLeft.add(outTuple));
        ElementAwareLinkedList outTupleListRight = (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        ((AbstractTuple)outTuple).setStore(this.outputStoreIndexRightOutEntry, outTupleListRight.add(outTuple));
        this.propagationQueue.insert(outTuple);
    }

    protected final void insertOutTupleFilteredFromLeft(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        if (!((AbstractTuple)leftTuple).state.isActive()) {
            return;
        }
        this.insertOutTupleFiltered(leftTuple, rightTuple);
    }

    protected final void insertOutTupleFiltered(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
            this.insertOutTuple(leftTuple, rightTuple);
        }
    }

    protected final void innerUpdateLeft(LeftTuple_ leftTuple, Consumer<Consumer<UniTuple<Right_>>> rightTupleConsumer) {
        ElementAwareLinkedList outTupleListLeft = (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
        if (!this.isFiltering) {
            for (AbstractTuple outTuple : outTupleListLeft) {
                this.updateOutTupleLeft(outTuple, leftTuple);
            }
        } else {
            if (!((AbstractTuple)leftTuple).state.isActive()) {
                return;
            }
            rightTupleConsumer.accept(rightTuple -> this.processOutTupleUpdate(leftTuple, (UniTuple<Right_>)rightTuple, (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList), outTupleListLeft, this.outputStoreIndexRightOutEntry));
        }
    }

    private void updateOutTupleLeft(OutTuple_ outTuple, LeftTuple_ leftTuple) {
        this.setOutTupleLeftFacts(outTuple, leftTuple);
        this.doUpdateOutTuple(outTuple);
    }

    private void doUpdateOutTuple(OutTuple_ outTuple) {
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (%s) in node (%s) is in an unexpected state (%s).".formatted(new Object[]{outTuple, this, ((AbstractTuple)outTuple).state}));
        }
        if (state != TupleState.OK) {
            return;
        }
        this.propagationQueue.update(outTuple);
    }

    protected final void innerUpdateRight(UniTuple<Right_> rightTuple, Consumer<Consumer<LeftTuple_>> leftTupleConsumer) {
        ElementAwareLinkedList outTupleListRight = (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        if (!this.isFiltering) {
            for (AbstractTuple outTuple : outTupleListRight) {
                this.setOutTupleRightFact(outTuple, rightTuple);
                this.doUpdateOutTuple(outTuple);
            }
        } else {
            leftTupleConsumer.accept(leftTuple -> this.processOutTupleUpdateFromLeft(leftTuple, rightTuple, (ElementAwareLinkedList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList), outTupleListRight, this.outputStoreIndexLeftOutEntry));
        }
    }

    private void processOutTupleUpdateFromLeft(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ElementAwareLinkedList<OutTuple_> outList, ElementAwareLinkedList<OutTuple_> outTupleList, int outputStoreIndexOutEntry) {
        if (!((AbstractTuple)leftTuple).state.isActive()) {
            return;
        }
        this.processOutTupleUpdate(leftTuple, rightTuple, outList, outTupleList, outputStoreIndexOutEntry);
    }

    private void processOutTupleUpdate(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ElementAwareLinkedList<OutTuple_> referenceList, ElementAwareLinkedList<OutTuple_> sourceList, int outputStoreIndexOutEntry) {
        OutTuple_ outTuple = AbstractJoinNode.findOutTuple(sourceList, referenceList, outputStoreIndexOutEntry);
        if (this.testFiltering(leftTuple, rightTuple)) {
            if (outTuple == null) {
                this.insertOutTuple(leftTuple, rightTuple);
            } else {
                this.updateOutTupleLeft(outTuple, leftTuple);
            }
        } else if (outTuple != null) {
            this.retractOutTuple(outTuple);
        }
    }

    private static <Tuple_ extends AbstractTuple> Tuple_ findOutTuple(ElementAwareLinkedList<Tuple_> sourceList, ElementAwareLinkedList<Tuple_> referenceList, int outputStoreIndexOutEntry) {
        for (ElementAwareLinkedList.Entry<Tuple_> item = sourceList.first(); item != null; item = item.next()) {
            AbstractTuple outTuple = (AbstractTuple)item.getElement();
            ElementAwareLinkedList.Entry outEntry = (ElementAwareLinkedList.Entry)outTuple.getStore(outputStoreIndexOutEntry);
            ElementAwareLinkedList outEntryList = outEntry.getList();
            if (referenceList != outEntryList) continue;
            return (Tuple_)outTuple;
        }
        return null;
    }

    private void retractOutTuple(OutTuple_ outTuple) {
        this.removeLeftEntry(outTuple);
        this.removeRightEntry(outTuple);
        this.propagateRetract(outTuple);
    }

    private void removeLeftEntry(OutTuple_ outTuple) {
        this.removeEntry(outTuple, this.outputStoreIndexLeftOutEntry);
    }

    private void removeRightEntry(OutTuple_ outTuple) {
        this.removeEntry(outTuple, this.outputStoreIndexRightOutEntry);
    }

    private void removeEntry(OutTuple_ outTuple, int outputStoreIndex) {
        ElementAwareLinkedList.Entry outEntry = (ElementAwareLinkedList.Entry)((AbstractTuple)outTuple).removeStore(outputStoreIndex);
        outEntry.remove();
    }

    private void propagateRetract(OutTuple_ outTuple) {
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (%s) in node (%s) is in an unexpected state (%s).".formatted(new Object[]{outTuple, this, ((AbstractTuple)outTuple).state}));
        }
        this.propagationQueue.retract(outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    void retractOutTupleByLeft(OutTuple_ outTuple) {
        ((AbstractTuple)outTuple).removeStore(this.outputStoreIndexLeftOutEntry);
        this.removeRightEntry(outTuple);
        this.propagateRetract(outTuple);
    }

    void retractOutTupleByRight(OutTuple_ outTuple) {
        this.removeLeftEntry(outTuple);
        ((AbstractTuple)outTuple).removeStore(this.outputStoreIndexRightOutEntry);
        this.propagateRetract(outTuple);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }
}

