/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.common;

import ai.timefold.solver.core.impl.bavet.common.AbstractTwoInputNode;
import ai.timefold.solver.core.impl.bavet.common.DynamicPropagationQueue;
import ai.timefold.solver.core.impl.bavet.common.ExistsCounter;
import ai.timefold.solver.core.impl.bavet.common.Propagator;
import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.InTupleStorePositionTracker;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleState;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareLinkedList;
import org.jspecify.annotations.NullMarked;

public abstract class AbstractIfExistsNode<LeftTuple_ extends AbstractTuple, Right_>
extends AbstractTwoInputNode<LeftTuple_, UniTuple<Right_>> {
    protected final boolean shouldExist;
    protected final int inputStoreIndexLeftTrackerList;
    protected final int inputStoreIndexRightTrackerList;
    protected final boolean isFiltering;
    private final DynamicPropagationQueue<LeftTuple_, ExistsCounter<LeftTuple_>> propagationQueue;

    protected AbstractIfExistsNode(boolean shouldExist, TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle, boolean isFiltering, InTupleStorePositionTracker tupleStorePositionTracker) {
        this.shouldExist = shouldExist;
        this.inputStoreIndexLeftTrackerList = isFiltering ? tupleStorePositionTracker.reserveNextLeft() : -1;
        this.inputStoreIndexRightTrackerList = isFiltering ? tupleStorePositionTracker.reserveNextRight() : -1;
        this.isFiltering = isFiltering;
        this.propagationQueue = new DynamicPropagationQueue(nextNodesTupleLifecycle);
    }

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected void initCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.propagationQueue.insert(counter);
        }
    }

    protected final void updateUnchangedCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (counter.state != TupleState.OK) {
            return;
        }
        this.propagationQueue.update(counter);
    }

    protected void updateCounterLeft(ExistsCounter<LeftTuple_> counter) {
        block11: {
            TupleState state;
            block10: {
                state = counter.state;
                if (!(this.shouldExist ? counter.countRight > 0 : counter.countRight == 0)) break block10;
                switch (state) {
                    case CREATING: 
                    case UPDATING: {
                        break block11;
                    }
                    case OK: 
                    case DYING: {
                        this.propagationQueue.update(counter);
                        break block11;
                    }
                    case DEAD: 
                    case ABORTING: {
                        this.propagationQueue.insert(counter);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: the counter (%s) has an impossible insert state (%s).".formatted(new Object[]{counter, state}));
                    }
                }
            }
            if (!state.isActive()) {
                return;
            }
            switch (state) {
                case CREATING: {
                    this.propagationQueue.retract(counter, TupleState.ABORTING);
                    break;
                }
                case UPDATING: 
                case OK: {
                    this.propagationQueue.retract(counter, TupleState.DYING);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The counter (%s) has an impossible retract state (%s).".formatted(new Object[]{counter, state}));
                }
            }
        }
    }

    protected void killCounterLeft(ExistsCounter<LeftTuple_> counter) {
        if (this.shouldExist ? counter.countRight > 0 : counter.countRight == 0) {
            this.doRetractCounter(counter);
        }
    }

    protected void incrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doInsertCounter(counter);
            } else {
                this.doRetractCounter(counter);
            }
        }
        ++counter.countRight;
    }

    protected void decrementCounterRight(ExistsCounter<LeftTuple_> counter) {
        --counter.countRight;
        if (counter.countRight == 0) {
            if (this.shouldExist) {
                this.doRetractCounter(counter);
            } else {
                this.doInsertCounter(counter);
            }
        }
    }

    protected ElementAwareLinkedList<FilteringTracker<LeftTuple_>> clearRightTrackerList(UniTuple<Right_> rightTuple) {
        ElementAwareLinkedList rightTrackerList = (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightTrackerList);
        rightTrackerList.clear(tracker -> {
            this.decrementCounterRight(tracker.counter);
            tracker.removeByRight();
        });
        return rightTrackerList;
    }

    protected void updateCounterFromLeft(ExistsCounter<LeftTuple_> counter, UniTuple<Right_> rightTuple, ElementAwareLinkedList<FilteringTracker<LeftTuple_>> leftTrackerList) {
        if (this.testFiltering(counter.leftTuple, rightTuple)) {
            ++counter.countRight;
            new FilteringTracker<LeftTuple_>(counter, leftTrackerList, (ElementAwareLinkedList)rightTuple.getStore(this.inputStoreIndexRightTrackerList));
        }
    }

    protected void updateCounterFromRight(ExistsCounter<LeftTuple_> counter, UniTuple<Right_> rightTuple, ElementAwareLinkedList<FilteringTracker<LeftTuple_>> rightTrackerList) {
        Object leftTuple = counter.leftTuple;
        if (!((AbstractTuple)leftTuple).state.isActive()) {
            return;
        }
        if (this.testFiltering(leftTuple, rightTuple)) {
            this.incrementCounterRight(counter);
            new FilteringTracker<LeftTuple_>(counter, (ElementAwareLinkedList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftTrackerList), rightTrackerList);
        }
    }

    private void doInsertCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case DYING: {
                this.propagationQueue.update(counter);
                break;
            }
            case DEAD: 
            case ABORTING: {
                this.propagationQueue.insert(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (%s) has an impossible insert state (%s).".formatted(new Object[]{counter, counter.state}));
            }
        }
    }

    private void doRetractCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                this.propagationQueue.retract(counter, TupleState.ABORTING);
                break;
            }
            case UPDATING: 
            case OK: {
                this.propagationQueue.retract(counter, TupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (%s) has an impossible retract state (%s).".formatted(new Object[]{counter, counter.state}));
            }
        }
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    @NullMarked
    protected static final class FilteringTracker<LeftTuple_ extends AbstractTuple> {
        final ExistsCounter<LeftTuple_> counter;
        private final ElementAwareLinkedList.Entry<FilteringTracker<LeftTuple_>> leftTrackerEntry;
        private final ElementAwareLinkedList.Entry<FilteringTracker<LeftTuple_>> rightTrackerEntry;

        FilteringTracker(ExistsCounter<LeftTuple_> counter, ElementAwareLinkedList<FilteringTracker<LeftTuple_>> leftTrackerList, ElementAwareLinkedList<FilteringTracker<LeftTuple_>> rightTrackerList) {
            this.counter = counter;
            this.leftTrackerEntry = leftTrackerList.add(this);
            this.rightTrackerEntry = rightTrackerList.add(this);
        }

        public void removeByLeft() {
            this.rightTrackerEntry.remove();
        }

        public void removeByRight() {
            this.leftTrackerEntry.remove();
        }
    }
}

