/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.entity;

import ai.timefold.solver.core.api.domain.common.ComparatorFactory;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Comparator;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"id", "mimicSelectorRef", "entityClass", "cacheType", "selectionOrder", "nearbySelectionConfig", "filterClass", "sorterManner", "sorterComparatorClass", "comparatorClass", "sorterWeightFactoryClass", "comparatorFactoryClass", "sorterOrder", "sorterClass", "probabilityWeightFactoryClass", "selectedCountLimit"})
@NullMarked
public class EntitySelectorConfig
extends SelectorConfig<EntitySelectorConfig> {
    @XmlAttribute
    protected @Nullable String id = null;
    @XmlAttribute
    protected @Nullable String mimicSelectorRef = null;
    protected @Nullable Class<?> entityClass = null;
    protected @Nullable SelectionCacheType cacheType = null;
    protected @Nullable SelectionOrder selectionOrder = null;
    @XmlElement(name="nearbySelection")
    protected @Nullable NearbySelectionConfig nearbySelectionConfig = null;
    protected @Nullable Class<? extends SelectionFilter> filterClass = null;
    protected @Nullable EntitySorterManner sorterManner = null;
    @Deprecated(forRemoval=true, since="1.28.0")
    protected @Nullable Class<? extends Comparator> sorterComparatorClass = null;
    protected @Nullable Class<? extends Comparator> comparatorClass = null;
    @Deprecated(forRemoval=true, since="1.28.0")
    protected @Nullable Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected @Nullable Class<? extends ComparatorFactory> comparatorFactoryClass = null;
    protected @Nullable SelectionSorterOrder sorterOrder = null;
    protected @Nullable Class<? extends SelectionSorter> sorterClass = null;
    protected @Nullable Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected @Nullable Long selectedCountLimit = null;

    public static EntitySelectorConfig newMimicSelectorConfig(String mimicSelectorRef) {
        return new EntitySelectorConfig().withMimicSelectorRef(mimicSelectorRef);
    }

    public EntitySelectorConfig() {
    }

    public EntitySelectorConfig(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public EntitySelectorConfig(@Nullable EntitySelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public @Nullable String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public @Nullable String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(@Nullable String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public @Nullable Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(@Nullable Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public @Nullable SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(@Nullable SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public @Nullable SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(@Nullable SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public @Nullable NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(@Nullable NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public @Nullable Class<? extends SelectionFilter> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(@Nullable Class<? extends SelectionFilter> filterClass) {
        this.filterClass = filterClass;
    }

    public @Nullable EntitySorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(@Nullable EntitySorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public @Nullable Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public void setSorterComparatorClass(@Nullable Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public @Nullable Class<? extends Comparator> getComparatorClass() {
        return this.comparatorClass;
    }

    public void setComparatorClass(@Nullable Class<? extends Comparator> comparatorClass) {
        this.comparatorClass = comparatorClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public @Nullable Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public void setSorterWeightFactoryClass(@Nullable Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public @Nullable Class<? extends ComparatorFactory> getComparatorFactoryClass() {
        return this.comparatorFactoryClass;
    }

    public void setComparatorFactoryClass(@Nullable Class<? extends ComparatorFactory> comparatorFactoryClass) {
        this.comparatorFactoryClass = comparatorFactoryClass;
    }

    public @Nullable SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(@Nullable SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public @Nullable Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(@Nullable Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public @Nullable Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(@Nullable Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public @Nullable Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(@Nullable Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public EntitySelectorConfig withId(String id) {
        this.setId(id);
        return this;
    }

    public EntitySelectorConfig withMimicSelectorRef(String mimicSelectorRef) {
        this.setMimicSelectorRef(mimicSelectorRef);
        return this;
    }

    public EntitySelectorConfig withEntityClass(Class<?> entityClass) {
        this.setEntityClass(entityClass);
        return this;
    }

    public EntitySelectorConfig withCacheType(SelectionCacheType cacheType) {
        this.setCacheType(cacheType);
        return this;
    }

    public EntitySelectorConfig withSelectionOrder(SelectionOrder selectionOrder) {
        this.setSelectionOrder(selectionOrder);
        return this;
    }

    public EntitySelectorConfig withNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    public EntitySelectorConfig withFilterClass(Class<? extends SelectionFilter> filterClass) {
        this.setFilterClass(filterClass);
        return this;
    }

    public EntitySelectorConfig withSorterManner(EntitySorterManner sorterManner) {
        this.setSorterManner(sorterManner);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public EntitySelectorConfig withSorterComparatorClass(Class<? extends Comparator> comparatorClass) {
        this.setSorterComparatorClass(comparatorClass);
        return this;
    }

    public EntitySelectorConfig withComparatorClass(Class<? extends Comparator> comparatorClass) {
        this.setComparatorClass(comparatorClass);
        return this;
    }

    @Deprecated(forRemoval=true, since="1.28.0")
    public EntitySelectorConfig withSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> weightFactoryClass) {
        this.setSorterWeightFactoryClass(weightFactoryClass);
        return this;
    }

    public EntitySelectorConfig withComparatorFactoryClass(Class<? extends ComparatorFactory> comparatorFactoryClass) {
        this.setComparatorFactoryClass(comparatorFactoryClass);
        return this;
    }

    public EntitySelectorConfig withSorterOrder(SelectionSorterOrder sorterOrder) {
        this.setSorterOrder(sorterOrder);
        return this;
    }

    public EntitySelectorConfig withSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.setSorterClass(sorterClass);
        return this;
    }

    public EntitySelectorConfig withProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> factoryClass) {
        this.setProbabilityWeightFactoryClass(factoryClass);
        return this;
    }

    public EntitySelectorConfig withSelectedCountLimit(long selectedCountLimit) {
        this.setSelectedCountLimit(selectedCountLimit);
        return this;
    }

    @Override
    public EntitySelectorConfig inherit(EntitySelectorConfig inheritedConfig) {
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.getId());
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.getMimicSelectorRef());
        this.entityClass = ConfigUtils.inheritOverwritableProperty(this.entityClass, inheritedConfig.getEntityClass());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.filterClass = ConfigUtils.inheritOverwritableProperty(this.filterClass, inheritedConfig.getFilterClass());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.comparatorClass = ConfigUtils.inheritOverwritableProperty(this.comparatorClass, inheritedConfig.getComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.comparatorFactoryClass = ConfigUtils.inheritOverwritableProperty(this.comparatorFactoryClass, inheritedConfig.getComparatorFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
        return this;
    }

    @Override
    public EntitySelectorConfig copyConfig() {
        return new EntitySelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.entityClass);
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.filterClass);
        classVisitor.accept(this.sorterComparatorClass);
        classVisitor.accept(this.comparatorClass);
        classVisitor.accept(this.sorterWeightFactoryClass);
        classVisitor.accept(this.comparatorFactoryClass);
        classVisitor.accept(this.sorterClass);
        classVisitor.accept(this.probabilityWeightFactoryClass);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.entityClass) + ")";
    }

    public static <Solution_> boolean hasSorter(EntitySorterManner entitySorterManner, EntityDescriptor<Solution_> entityDescriptor) {
        return switch (entitySorterManner) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySorterManner.NONE -> false;
            case EntitySorterManner.DECREASING_DIFFICULTY, EntitySorterManner.DESCENDING -> true;
            case EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE, EntitySorterManner.DESCENDING_IF_AVAILABLE -> entityDescriptor.getDescendingSorter() != null;
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <Solution_, T> SelectionSorter<Solution_, T> determineSorter(EntitySorterManner entitySorterManner, EntityDescriptor<Solution_> entityDescriptor) {
        void var2_2;
        switch (entitySorterManner) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            }
            case DECREASING_DIFFICULTY: 
            case DESCENDING: 
            case DECREASING_DIFFICULTY_IF_AVAILABLE: 
            case DESCENDING_IF_AVAILABLE: 
        }
        SelectionSorter<Solution_, Object> sorter = entityDescriptor.getDescendingSorter();
        if (sorter == null) {
            throw new IllegalArgumentException("The sorterManner (%s) on entity class (%s) fails because that entity class's @%s annotation does not declare any difficulty comparison.".formatted(new Object[]{entitySorterManner, entityDescriptor.getEntityClass(), PlanningEntity.class.getSimpleName()}));
        }
        return var2_2;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.nearbySelectionConfig != null;
    }
}

